/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.protocol.is;

import com.day.cq.dam.scene7.impl.protocol.NameValue;
import com.day.cq.dam.scene7.impl.protocol.is.ParamCommand;
import com.day.cq.dam.scene7.impl.protocol.is.ParamUtils;
import java.util.Vector;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paramable
extends NameValue {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ParamCommand paramCmd;

    public Paramable(String name, String inValue, String defaultValue) {
        super(name, ParamUtils.isParamRef(inValue) ? null : inValue, defaultValue);
        if (this.getValue() == null) {
            super.setValue(inValue);
        }
    }

    public Paramable(String name, String inValue) {
        this(name, inValue, null);
    }

    public Paramable(String name) {
        this(name, null, null);
    }

    @Override
    public void setParent(NameValue parent) {
        super.setParent(parent);
        if (parent == null) {
            this.setParamCmd(null);
        } else if (ParamUtils.isParamRef(super.getValue())) {
            this.parameterize(super.getValue());
        }
    }

    @Override
    public void setValue(String inValue) {
        super.setValue(inValue);
        this.valueChanged();
    }

    @Override
    public String nodeString(boolean checked, boolean encode) {
        if (this.isVariable()) {
            String locName = this.getName();
            if (encode && locName != null) {
                locName = Text.escape((String)locName);
            }
            String locValue = this.getParameterizedValue();
            if (encode && locValue != null) {
                locValue = Text.escape((String)locValue);
            }
            return "&" + locName + "=" + locValue;
        }
        return super.nodeString(checked, encode);
    }

    public ParamCommand getParamCmd() {
        return this.paramCmd;
    }

    public void setParamCmd(ParamCommand cmd) {
        if (this.paramCmd == cmd) {
            return;
        }
        this.paramCmd = cmd;
        if (this.paramCmd != null) {
            this.paramCmd.addRef(this);
        }
    }

    public boolean isVariable() {
        return this.paramCmd != null;
    }

    public String getDefaultParameterValue() {
        return this.getValue();
    }

    public String makeParamName() {
        String paramName = "";
        NameValue locCmd = this.getParent();
        while (locCmd.getParent() != null) {
            paramName = locCmd.getName() + "_" + locCmd.getValue() + "_" + paramName;
            locCmd = locCmd.getParent();
        }
        paramName = "$" + paramName + this.getName();
        return paramName;
    }

    protected void parameterize(String paramRef) {
        Vector<String> refs = ParamUtils.getParamRefs(paramRef);
        for (int i = 0; i < refs.size(); ++i) {
            String paramName = refs.elementAt(i);
            ParamCommand locParamCmd = (ParamCommand)this.getRoot().getNode(paramName.substring(0, paramName.length() - 1));
            if (locParamCmd != null) {
                if (!this.getName().equals("text") && !this.getName().equals("textps")) {
                    this.setValue(locParamCmd.getValue());
                }
                this.setParamCmd(locParamCmd);
                continue;
            }
            this.log.warn("Could not locate parameter for " + this.getName() + ": " + paramRef);
        }
    }

    protected String getParameterizedValue() {
        return this.paramCmd.getName() + "$";
    }

    protected void valueChanged() {
        if (this.isVariable() && this.getParent() != null) {
            this.paramCmd.updateRefs(this.getValue(), this);
        }
    }
}

