/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.rendition;

import com.adobe.granite.asset.api.Rendition;
import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7APIClient;
import com.day.cq.dam.scene7.impl.rendition.Scene7RenditionProperty;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scene7Rendition
extends ResourceWrapper
implements Rendition {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7Rendition.class);
    private final ValueMap contentProperties;
    private Scene7APIClient scene7Client;
    private S7ConfigResolver s7ConfigResolver;

    public Scene7Rendition(Resource resource, Scene7APIClient scene7Client, S7ConfigResolver s7ConfigResolver) {
        super(resource);
        this.scene7Client = scene7Client;
        this.s7ConfigResolver = s7ConfigResolver;
        Resource contentResource = resource.getResourceResolver().getResource(resource, "jcr:content");
        this.contentProperties = ResourceUtil.getValueMap((Resource)contentResource);
    }

    public String getMimeType() {
        return (String)this.contentProperties.get(Scene7RenditionProperty.MIME_TYPE.getPropertyName(), (Object)"");
    }

    public long getSize() {
        return ((Integer)this.contentProperties.get(Scene7RenditionProperty.SIZE.getPropertyName(), (Object)0)).intValue();
    }

    public InputStream getStream() {
        Resource resource = this.getResource();
        S7Config config = this.resolveScene7Configuration();
        String assetHandle = (String)this.contentProperties.get(Scene7RenditionProperty.ASSET_HANDLE.getPropertyName(), (Object)"");
        if (StringUtils.isBlank((String)assetHandle)) {
            LOGGER.error("Invalid asset handle found on rendition resource {}", (Object)(resource != null ? resource.getPath() : "null"));
        }
        InputStream renditionInputStream = null;
        if (config != null && StringUtils.isNotBlank((String)assetHandle)) {
            renditionInputStream = this.scene7Client.getOriginalFile(assetHandle, config);
        }
        return renditionInputStream;
    }

    private S7Config resolveScene7Configuration() {
        S7Config config;
        Resource resource = this.getResource();
        Resource configResource = null;
        if (resource != null) {
            ResourceResolver rr = resource.getResourceResolver();
            if (rr != null) {
                configResource = rr.getResource(resource, "../../metadata");
            } else {
                LOGGER.error("Invalid Resource resolver obtained from resource {}", (Object)resource.getPath());
            }
        }
        if ((config = this.s7ConfigResolver.getS7ConfigForResource(configResource)) == null) {
            LOGGER.error("Could not resolve a S7Config from resource {}", (Object)(resource != null ? resource.getPath() : "null"));
        }
        return config;
    }
}

