/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.rendition;

import com.adobe.granite.asset.api.AssetException;
import com.adobe.granite.asset.api.Rendition;
import com.adobe.granite.asset.api.RenditionHandler;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7APIClient;
import com.day.cq.dam.scene7.impl.rendition.Scene7Rendition;
import java.io.InputStream;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;

@Component(immediate=true)
@Properties(value={@Property(name="service.description", value={"Scene7 Proxy RenditionHandler"}), @Property(name="rendition.handler.id", value={"scene7"})})
@Service
public class Scene7RenditionHandler
implements RenditionHandler {
    public static final String ID = "scene7";
    @Reference
    private Scene7APIClient client;
    @Reference
    private S7ConfigResolver s7ConfigResolver;

    public Rendition getRendition(Resource resource) {
        return new Scene7Rendition(resource, this.client, this.s7ConfigResolver);
    }

    public Rendition setRendition(Resource resource, InputStream inputStream, Map<String, Object> renditionConfig) {
        String handlerId = this.getRenditionHandlerId(renditionConfig);
        if (StringUtils.isBlank((String)handlerId) || !handlerId.equals(ID)) {
            throw new IllegalArgumentException("Unsupported rendition handler id set in configuration for this handler");
        }
        try {
            Node renditionNode = (Node)resource.adaptTo(Node.class);
            if (renditionNode != null) {
                Node content = renditionNode.getNode("jcr:content");
                this.setProxyRenditionContent(content, renditionConfig);
            }
            return this.getRendition(resource);
        }
        catch (RepositoryException e) {
            throw new AssetException((Throwable)e);
        }
    }

    public void deleteRendition(Resource resource) {
        throw new UnsupportedOperationException("deletion of S7 proxy renditions is not supported yet");
    }

    private void setProxyRenditionContent(Node content, Map<String, Object> renditionConfig) throws RepositoryException {
        if (renditionConfig != null) {
            for (String key : renditionConfig.keySet()) {
                String value = (String)renditionConfig.get(key);
                content.setProperty(key, value);
            }
        }
    }

    private String getRenditionHandlerId(Map<String, Object> renditionConfig) {
        if (renditionConfig != null) {
            return (String)renditionConfig.get("rendition.handler.id");
        }
        return null;
    }

    protected void bindClient(Scene7APIClient scene7APIClient) {
        this.client = scene7APIClient;
    }

    protected void unbindClient(Scene7APIClient scene7APIClient) {
        if (this.client == scene7APIClient) {
            this.client = null;
        }
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }
}

