/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam:Asset", "sling:OrderedFolder", "sling:Folder"}), @Property(name="sling.servlet.selectors", value={"s7config"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class Scene7AssetDAMPublishServlet
extends SlingAllMethodsServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Scene7AssetDAMPublishServlet.class);
    @Reference
    private S7ConfigResolver s7ConfigResolver;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        Resource damResource = request.getResource();
        String scene7ConfigPath = "";
        if (damResource != null) {
            S7Config scene7Config = this.s7ConfigResolver.getS7ConfigForResource(damResource);
            if (scene7Config != null) {
                scene7ConfigPath = scene7Config.getCloudConfigPath();
            }
        } else {
            LOGGER.error("No resource found on the request!");
        }
        PrintWriter out = response.getWriter();
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("scene7ConfigPath", (Object)scene7ConfigPath);
        }
        catch (JSONException e) {
            LOGGER.error("Error adding element to the JSON response", (Throwable)e);
        }
        out.write(jsonObject.toString());
    }

    protected void bindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7ConfigResolver = s7ConfigResolver;
    }

    protected void unbindS7ConfigResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7ConfigResolver == s7ConfigResolver) {
            this.s7ConfigResolver = null;
        }
    }
}

