/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.PersistableValueMap;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.servlet.name", description="%cq.scene7.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/scene7page"}), @Property(name="sling.servlet.selectors", value={"config"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET", "POST"})})
public class Scene7ConfigServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7ConfigServlet.class);
    @Reference
    protected S7ConfigResolver s7configResolver;
    private static final String PROP = "prop";
    private static final String SET_DEFAULT_CONFIG_PARAM = "setDefault";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        Resource resource = request.getResource();
        S7Config s7Config = null;
        JSONObject json = new JSONObject();
        try {
            if (resource != null) {
                String prop;
                String configPath = resource.getPath();
                s7Config = this.s7configResolver.getS7Config(configPath = configPath.replaceAll("/jcr:content$", ""));
                if (s7Config != null && (prop = request.getParameter(PROP)) != null) {
                    String propertyValue = s7Config.get(prop);
                    json.put(prop, (Object)propertyValue);
                }
            } else {
                LOG.warn("Could not find the config path parameter on the request!");
            }
        }
        catch (JSONException e) {
            LOG.error("Error adding element to the JSON response", (Throwable)e);
        }
        finally {
            out.write(json.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONObject json = new JSONObject();
        try {
            Resource resource;
            ResourceResolver resolver = request.getResourceResolver();
            String setDefaultConfig = request.getParameter(SET_DEFAULT_CONFIG_PARAM);
            if (StringUtils.isNotEmpty((String)setDefaultConfig) && (resource = request.getResource()) != null) {
                String configPath = resource.getPath();
                configPath = configPath.replaceAll("/jcr:content$", "");
                S7Config defaultConfig = this.s7configResolver.getS7Config(configPath);
                List<S7Config> s7CloudConfigurations = this.s7configResolver.getS7Configurations("/etc/cloudservices/scene7");
                for (S7Config s7Config : s7CloudConfigurations) {
                    if (s7Config.equals(defaultConfig) || !s7Config.isDefault()) continue;
                    String s7PageConfig = s7Config.getCloudConfigPath() + "/" + "jcr:content";
                    Resource configResource = resolver.getResource(s7PageConfig);
                    if (configResource != null) {
                        PersistableValueMap properties = (PersistableValueMap)configResource.adaptTo(PersistableValueMap.class);
                        properties.put((Object)"defaultConfiguration", (Object)false);
                        properties.save();
                        break;
                    }
                    LOG.error("Cannot find page content for " + s7PageConfig);
                    break;
                }
            }
            json.put("status", (Object)"ok");
        }
        catch (JSONException e) {
            LOG.error("Error adding element to the JSON response", (Throwable)e);
        }
        finally {
            out.write(json.toString());
        }
    }

    protected void bindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7configResolver = s7ConfigResolver;
    }

    protected void unbindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7configResolver == s7ConfigResolver) {
            this.s7configResolver = null;
        }
    }
}

