/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.Scene7Endpoint;
import com.day.cq.dam.scene7.api.Scene7EndpointsManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.dam.scene7.endpointsservlet.name", description="%cq.dam.scene7.endpointsservlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/scene7Endpoints"}), @Property(name="sling.servlet.selectors", value={"info"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class Scene7EndpointsServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -1430838611398713905L;
    private static final Logger LOG = LoggerFactory.getLogger(Scene7EndpointsServlet.class);
    @Reference
    private Scene7EndpointsManager scene7EndpointsManager;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONArray jsonArray = new JSONArray();
        try {
            List<Scene7Endpoint> endpoints = this.scene7EndpointsManager.getScene7Endpoints();
            for (Scene7Endpoint e : endpoints) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("description", (Object)e.getDescription());
                jsonObject.put("region", (Object)e.getRegion());
                jsonObject.put("apiURL", (Object)e.getApiURL());
                jsonObject.put("apiVersion", (Object)e.getApiVersion());
                jsonObject.put("ipsURL", (Object)e.getIpsURL());
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (Exception e) {
            LOG.error("Unable to retrieve endpoints details", (Throwable)e);
        }
        out.write(jsonArray.toString());
    }

    protected void bindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        this.scene7EndpointsManager = scene7EndpointsManager;
    }

    protected void unbindScene7EndpointsManager(Scene7EndpointsManager scene7EndpointsManager) {
        if (this.scene7EndpointsManager == scene7EndpointsManager) {
            this.scene7EndpointsManager = null;
        }
    }
}

