/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.Scene7FlashTemplatesService;
import com.day.cq.dam.scene7.api.constants.FlashTemplateAssetConstants;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.flashtemplatesservlet.name", description="%cq.scene7.flashtemplatesservlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/flashtemplate"}), @Property(name="sling.servlet.selectors", value={"flashcontent"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class Scene7FlashTemplatesServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 865063600461751483L;
    private static final Logger LOG = LoggerFactory.getLogger(Scene7FlashTemplatesServlet.class);
    static final String PARAM_ELEMENT = "element";
    @Reference
    private Scene7FlashTemplatesService scene7FlashTemplatesService;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        Resource resource = request.getResource();
        PrintWriter out = response.getWriter();
        JSONObject json = new JSONObject();
        if (resource != null) {
            String assetTypeString = request.getParameter(PARAM_ELEMENT);
            FlashTemplateAssetConstants assetType = null;
            if (assetTypeString != null) {
                for (FlashTemplateAssetConstants dbat : FlashTemplateAssetConstants.values()) {
                    if (!assetTypeString.equals(dbat.getAssetType())) continue;
                    assetType = dbat;
                    LOG.debug("Asset type filtering enabled: " + assetTypeString);
                    break;
                }
            }
            json = this.scene7FlashTemplatesService.getFlashTemplateAssets(resource, assetType);
        }
        out.write(json.toString());
    }

    protected void bindScene7FlashTemplatesService(Scene7FlashTemplatesService scene7FlashTemplatesService) {
        this.scene7FlashTemplatesService = scene7FlashTemplatesService;
    }

    protected void unbindScene7FlashTemplatesService(Scene7FlashTemplatesService scene7FlashTemplatesService) {
        if (this.scene7FlashTemplatesService == scene7FlashTemplatesService) {
            this.scene7FlashTemplatesService = null;
        }
    }
}

