/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.Scene7PresetsService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.sling.SlingServlet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SlingServlet(resourceTypes={"dam/components/scene7/scene7page"}, methods={"GET", "POST"}, selectors={"presets.all", "presets.viewer", "presets.encoding"})
public class Scene7PresetServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7PresetServlet.class);
    @Reference
    protected Scene7PresetsService presetsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONArray jsonArray = new JSONArray();
        boolean isAll = false;
        boolean isEncoding = false;
        boolean isViewer = true;
        String selector = request.getRequestPathInfo().getSelectorString();
        if (StringUtils.isNotBlank((String)selector)) {
            isAll = selector.equals("presets.all");
            isEncoding = selector.equals("presets.encoding");
            isViewer = selector.equals("presets.viewer");
        }
        try {
            Resource configResource = request.getResource();
            if (isAll) {
                Iterator<Resource> encodingPresets = this.presetsService.getEncodingPresets(configResource);
                this.writeEncodingPresets(encodingPresets, jsonArray);
                Iterator<Resource> viewerPresets = this.presetsService.getViewerPresets(configResource);
                this.writeViewerPresets(viewerPresets, jsonArray);
            } else if (isEncoding) {
                Iterator<Resource> encodingPresets = this.presetsService.getEncodingPresets(configResource);
                this.writeEncodingPresets(encodingPresets, jsonArray);
            } else if (isViewer) {
                Iterator<Resource> viewerPresets = this.presetsService.getViewerPresets(configResource);
                this.writeViewerPresets(viewerPresets, jsonArray);
            }
        }
        catch (JSONException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
        finally {
            out.write(jsonArray.toString());
        }
    }

    private void writeEncodingPresets(Iterator<Resource> encodingPresets, JSONArray jsonArray) throws JSONException {
        while (encodingPresets.hasNext()) {
            Resource encodingPreset = encodingPresets.next();
            JSONObject object = new JSONObject();
            this.writeGeneralPreset(encodingPreset, object);
            object.put("shared", this.isSharedEncoding(encodingPreset));
            jsonArray.put((Object)object);
        }
    }

    private void writeViewerPresets(Iterator<Resource> viewerPresets, JSONArray jsonArray) throws JSONException {
        while (viewerPresets.hasNext()) {
            Resource viewerPreset = viewerPresets.next();
            JSONObject object = new JSONObject();
            this.writeGeneralPreset(viewerPreset, object);
            object.put("shared", this.isSharedViewer(viewerPreset));
            Resource settingsResource = viewerPreset.getChild("settings");
            if (settingsResource != null) {
                ValueMap properties = (ValueMap)settingsResource.adaptTo(ValueMap.class);
                JSONObject settingsObj = new JSONObject();
                for (String key : properties.keySet()) {
                    String value = (String)properties.get(key, (Object)"");
                    settingsObj.put(key, (Object)value);
                }
                object.put("settings", (Object)settingsObj);
            }
            jsonArray.put((Object)object);
        }
    }

    private void writeGeneralPreset(Resource preset, JSONObject object) throws JSONException {
        ValueMap properties = (ValueMap)preset.adaptTo(ValueMap.class);
        for (String key : properties.keySet()) {
            String value = (String)properties.get(key, (Object)"");
            object.put(key, (Object)value);
        }
        object.put("value", (Object)preset.getPath());
        String prefix = (String)properties.get("playbackOn", (Object)"");
        if (StringUtils.isBlank((String)prefix)) {
            prefix = (String)properties.get("type", (Object)"");
        }
        String postfix = (String)properties.get("name", (Object)"");
        object.put("text", (Object)(prefix + " - " + postfix));
        String qtip = (String)properties.get("description", (Object)"");
        object.put("qtip", (Object)qtip);
    }

    private boolean isShared(Resource presetResource, String relPresetPath) {
        String sharedEcondigPresetPath = "/etc/cloudservices/scene7/" + relPresetPath;
        return presetResource.getParent().getPath().equals(sharedEcondigPresetPath);
    }

    private boolean isSharedEncoding(Resource presetResource) {
        return this.isShared(presetResource, "presets/encoding");
    }

    private boolean isSharedViewer(Resource presetResource) {
        return this.isShared(presetResource, "presets/viewer");
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        boolean isAll = false;
        boolean isEncoding = false;
        boolean isViewer = true;
        String selector = request.getRequestPathInfo().getSelectorString();
        if (StringUtils.isNotBlank((String)selector)) {
            isAll = selector.equals("presets.all");
            isEncoding = selector.equals("presets.encoding");
            isViewer = selector.equals("presets.viewer");
        }
        try {
            Resource configResource = request.getResource();
            boolean success = false;
            if (isAll) {
                success = this.presetsService.updateEncodingPresets(configResource);
                if (success) {
                    success = this.presetsService.updateViewerPresets(configResource);
                }
            } else if (isEncoding) {
                success = this.presetsService.updateEncodingPresets(configResource);
            } else if (isViewer) {
                success = this.presetsService.updateViewerPresets(configResource);
            }
            PrintWriter out = response.getWriter();
            if (success) {
                out.write("Presets successfully updated");
            } else {
                out.write("Error updating presets");
            }
        }
        catch (Exception e) {
            response.setStatus(500);
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void bindPresetsService(Scene7PresetsService scene7PresetsService) {
        this.presetsService = scene7PresetsService;
    }

    protected void unbindPresetsService(Scene7PresetsService scene7PresetsService) {
        if (this.presetsService == scene7PresetsService) {
            this.presetsService = null;
        }
    }
}

