/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.impl.model.FolderAssets;
import com.day.cq.dam.scene7.impl.utils.FolderAssetsUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.HtmlResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.servlet.name", description="%cq.scene7.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"sling:OrderedFolder"}), @Property(name="sling.servlet.selectors", value={"s7publish"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"POST", "GET"})})
public class Scene7PublishDialogServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(Scene7PublishDialogServlet.class);
    private static final String PATH = "path";
    private static final String SUBFOLDER = "subfolders";

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        try {
            JSONArray pathsArray = new JSONArray();
            JSONObject pathsObject = new JSONObject();
            try {
                ResourceResolver resolver = request.getResourceResolver();
                List<String> paths = Arrays.asList(request.getParameterValues(PATH));
                for (String path : paths) {
                    if (path != null && path.length() == 0) {
                        path = null;
                    }
                    Resource pathResource = resolver.getResource(path);
                    Node parentNode = (Node)pathResource.adaptTo(Node.class);
                    JSONObject object = new JSONObject();
                    if (FolderAssetsUtils.isFolderNode(parentNode)) {
                        int deepFileCount = FolderAssetsUtils.getAssetsCount(parentNode, true);
                        int deepFileSize = FolderAssetsUtils.getFolderAssetsFileSizeTotal(pathResource, true);
                        object.put("deepFileSize", deepFileSize);
                        object.put("shallowFileSize", FolderAssetsUtils.getFolderAssetsFileSizeTotal(pathResource, false));
                        object.put("fileSize", deepFileSize);
                        object.put("deepFileCount", deepFileCount);
                        object.put("shallowFileCount", FolderAssetsUtils.getAssetsCount(parentNode, false));
                        object.put("fileCount", deepFileCount);
                        object.put("isfolder", true);
                    } else {
                        int fileSize = FolderAssetsUtils.getAssetFileSize(pathResource);
                        object.put("deepFileSize", fileSize);
                        object.put("shallowFileSize", fileSize);
                        object.put("fileSize", fileSize);
                        object.put("deepFileCount", 1);
                        object.put("shallowFileCount", 1);
                        object.put("fileCount", 1);
                        object.put("isfolder", false);
                    }
                    object.put(PATH, (Object)path);
                    pathsArray.put((Object)object);
                }
                pathsObject.put("success", true);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                pathsObject.put("success", false);
                pathsObject.put("message", (Object)e.getMessage());
            }
            pathsObject.put("paths", (Object)pathsArray);
            pathsObject.write((Writer)response.getWriter());
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        HtmlResponse htmlResponse = new HtmlResponse();
        boolean success = true;
        try {
            ResourceResolver resolver = request.getResourceResolver();
            String[] values = request.getParameterValues(SUBFOLDER);
            if (values != null) {
                List<String> paths = Arrays.asList(values);
                for (String path : paths) {
                    if (path != null && path.length() == 0) continue;
                    Node parentNode = (Node)resolver.getResource(path).adaptTo(Node.class);
                    FolderAssets folderAssets = FolderAssetsUtils.getFolderAssetsList(parentNode, false).get(0);
                    Node metadata = FolderAssetsUtils.prepareScene7FolderContent(folderAssets.getFolderNode(), resolver);
                    metadata.setProperty("dam:scene7PublishSubFolders", "true");
                    metadata.getSession().save();
                    log.debug("dam:scene7PublishSubFolders = " + FolderAssetsUtils.isFolderNodeDeepScene7Managed(folderAssets.getFolderNode()));
                    htmlResponse.onModified(path);
                }
            }
        }
        catch (Exception e) {
            success = false;
            log.error("Failed: Setting subfolders to publish to Scene7 failed with Error ", (Throwable)e);
        }
        if (success) {
            htmlResponse.setStatus(200, "success: Setting subfolders to publish to Scene7 completed.");
        } else {
            htmlResponse.setStatus(500, "failure: Preparing the assets for publish to Scene7 did not complete successfully.");
        }
        htmlResponse.send((HttpServletResponse)response, true);
    }
}

