/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7AssetMimetypeService;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.constants.Scene7AssetType;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.impl.MetadataCondition;
import com.day.cq.dam.scene7.impl.utils.RequestUtils;
import com.day.cq.dam.scene7.impl.utils.Scene7AssetUtils;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.Query;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.servlet.name", description="%cq.scene7.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/scene7page"}), @Property(name="sling.servlet.selectors", value={"search"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class Scene7SearchServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7SearchServlet.class);
    private static final String PATH = "path";
    private static final String SEARCH_TERM = "searchTerm";
    private static final String ASSET_TYPE = "assetType";
    @Reference
    protected Scene7Service scene7Service;
    @Reference
    private S7ConfigResolver s7configResolver;
    @Reference
    private QueryBuilder queryBuilder;
    @Reference
    private Scene7AssetMimetypeService scene7AssetMimeTypeService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        JSONObject mainJSON = new JSONObject();
        JSONArray hitsArray = new JSONArray();
        JSONArray ddGroups = new JSONArray();
        ddGroups.put((Object)"s7media");
        int assetCnt = 0;
        Resource resource = request.getResource();
        S7Config s7Config = null;
        if (resource != null) {
            String configPath = resource.getPath();
            configPath = configPath.replaceAll("/jcr:content$", "");
            s7Config = this.s7configResolver.getS7Config(configPath);
        } else {
            LOG.warn("Could not load a valid Scene7 configuration!");
        }
        try {
            if (s7Config != null) {
                String assetType;
                String path = request.getParameter(PATH);
                String cqRootPath = s7Config.getBasePath();
                path = path == null || path.equals("/content") ? cqRootPath : cqRootPath + path.substring("/content/".length());
                path = URLDecoder.decode(path, "utf-8");
                String term = request.getParameter(SEARCH_TERM);
                MetadataCondition[] conditions = null;
                if (term != null) {
                    conditions = new MetadataCondition[]{new MetadataCondition("name", 2, term)};
                }
                Object[] assetTypes = (assetType = request.getParameter(ASSET_TYPE)) != null ? assetType.split(",") : null;
                String[] assetSubTypes = this.getSubTypes((String[])assetTypes);
                this.convertSubTypes((String[])assetTypes);
                assetTypes = (String[])ArrayUtils.add((Object[])assetTypes, (Object)Scene7AssetType.CATALOG.getValue());
                List<Scene7Asset> assets = null;
                assets = conditions != null ? this.scene7Service.searchAssetsByMetadata(path, Boolean.TRUE, (String[])assetTypes, assetSubTypes, Boolean.TRUE, conditions, s7Config) : this.scene7Service.searchAssets(path, Boolean.FALSE, Boolean.TRUE, (String[])assetTypes, assetSubTypes, new String[]{"assetArray/items/assetHandle", "assetArray/items/type", "assetArray/items/subType", "assetArray/items/name", "totalRows"}, null, s7Config);
                if (assets != null) {
                    int len = assets.size();
                    String[] assetHandles = new String[len];
                    for (int i = 0; i < len; ++i) {
                        assetHandles[i] = assets.get(i).getAssetHandle();
                    }
                    assets = this.scene7Service.getAssets(assetHandles, new String[]{"assetArray/items/assetHandle", "assetArray/items/type", "assetArray/items/subType", "assetArray/items/name", "assetArray/items/folder", "assetArray/items/fileName", "assetArray/items/lastModified", "assetArray/items/metadataArray/items/name", "assetArray/items/metadataArray/items/value", "assetArray/items/imageInfo/width", "assetArray/items/imageInfo/height", "assetArray/items/templateInfo/urlModifier", "assetArray/items/videoInfo/originalPath", "assetArray/items/videoInfo/originalFile", "assetArray/items/masterVideoInfo/originalPath", "assetArray/items/masterVideoInfo/originalFile", "assetArray/items/flashInfo/originalPath", "assetArray/items/flashInfo/originalFile"}, null, s7Config);
                }
                if (assets != null) {
                    String rootPath = s7Config.getBasePath();
                    String publishServer = s7Config.getPublishServer();
                    String imageUrl = publishServer + "is/image/" + rootPath;
                    String videoUrl = publishServer + "e2/";
                    boolean isCQ = false;
                    Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
                    DateFormat outdf = DateFormat.getDateTimeInstance(0, 0);
                    ArrayList<String> filterOutAssets = new ArrayList<String>();
                    filterOutAssets.add(Scene7AssetType.CATALOG.getValue());
                    assets = this.filterByProducts(assets, filterOutAssets, s7Config);
                    for (Scene7Asset asset : assets) {
                        String ref;
                        String lastModified;
                        String type = asset.getAssetTypeStr();
                        String name = asset.getName();
                        String thumb = RequestUtils.buildURL(imageUrl, name, null);
                        String nanos = lastModified = asset.getModifiedDate().toString();
                        try {
                            lastModified = outdf.format(asset.getModifiedDate());
                        }
                        catch (Exception e) {
                            LOG.error(e.getMessage(), (Throwable)e);
                        }
                        String originalPath = asset.getOriginalPath();
                        String originalFile = asset.getOriginalFile();
                        String rootFolder = asset.getRootFolder();
                        String fileName = asset.getFileName();
                        Long width = asset.getWidth();
                        Long height = asset.getHeight();
                        if (Scene7AssetType.VIDEO.getValue().equals(type) || Scene7AssetType.MASTER_VIDEO.getValue().equals(type)) {
                            if (originalFile.endsWith(".swf") || type.equals("MasterVideo") && !originalFile.endsWith(".mp4")) continue;
                            ref = RequestUtils.buildURL(videoUrl, rootFolder + fileName, null);
                        } else {
                            ref = RequestUtils.buildURL(imageUrl, name, null);
                        }
                        String mimeType = this.scene7AssetMimeTypeService.getMimeTypeForAssetType(asset.getAssetType(), Scene7AssetUtils.getExtensionForFileReference(ref));
                        String templateParams = null;
                        if (Scene7AssetType.TEMPLATE.getValue().equals(type)) {
                            asset = Scene7AssetUtils.extractTemplateSizeInformation(asset, this.scene7Service, s7Config);
                            templateParams = Scene7AssetUtils.extractTemplateParams(asset.getUrlModifier());
                            width = asset.getWidth();
                            height = asset.getHeight();
                        }
                        if (Scene7AssetType.FLASH.getValue().equals(type)) {
                            String flashUrl = s7Config.getFlashTemplatesServer();
                            if (!flashUrl.endsWith("/")) {
                                flashUrl = flashUrl + "/";
                            }
                            ref = RequestUtils.buildURL(flashUrl, originalPath + originalFile, null);
                            thumb = RequestUtils.buildURL(flashUrl, originalPath + originalFile, "fmt=png");
                            width = 250L;
                            height = 250L;
                        }
                        if (Scene7AssetType.FXG.getValue().equals(type)) {
                            String fxgServer = s7Config.getFXGServer();
                            ref = RequestUtils.buildURL(fxgServer, rootPath + name, null);
                            thumb = RequestUtils.buildURL(fxgServer, rootPath + name, "fmt=jpeg");
                        }
                        isCQ = false;
                        if (!type.equals("Template")) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put(PATH, "/content/dam");
                            map.put("property", "dam:scene7Name");
                            map.put("property.value", name);
                            Query query = this.queryBuilder.createQuery(PredicateGroup.create(map), session);
                            SearchResult result = query.getResult();
                            isCQ = result.getHits().size() > 0;
                        }
                        JSONObject hitItem = new JSONObject();
                        hitItem.put("name", (Object)name);
                        hitItem.put("thumb", (Object)thumb);
                        hitItem.put(PATH, (Object)ref);
                        hitItem.put("type", (Object)type);
                        hitItem.put("nanos", (Object)nanos);
                        hitItem.put("lastModified", (Object)lastModified);
                        hitItem.put("imageWidth", width != null ? width : JSONObject.NULL);
                        hitItem.put("imageHeight", height != null ? height : JSONObject.NULL);
                        hitItem.put("templateParams", (Object)templateParams);
                        hitItem.put("ddGroups", (Object)ddGroups);
                        hitItem.put("cqContent", (Object)new Boolean(isCQ).toString());
                        hitItem.put("mimeType", (Object)mimeType);
                        hitsArray.put((Object)hitItem);
                        ++assetCnt;
                    }
                }
            }
            mainJSON.put("hits", (Object)hitsArray);
            mainJSON.put("results", assetCnt);
        }
        catch (JSONException e) {
            LOG.error("Error building response JSON", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
        finally {
            out.write(mainJSON.toString());
        }
    }

    private List<Scene7Asset> filterByProducts(List<Scene7Asset> assetList, List<String> assetTypes, S7Config s7Config) {
        HashSet<String> filteredAssetHandles = new HashSet<String>();
        for (Scene7Asset asset : assetList) {
            if (!assetTypes.contains(asset.getAssetTypeStr())) continue;
            filteredAssetHandles.add(asset.getAssetHandle());
            asset = this.scene7Service.getAssociatedAssets(asset, s7Config);
            for (Scene7Asset associatedAsset : asset.getSubAssets()) {
                filteredAssetHandles.add(associatedAsset.getAssetHandle());
            }
        }
        Iterator<Scene7Asset> assetIterator = assetList.iterator();
        while (assetIterator.hasNext()) {
            Scene7Asset currentAsset = assetIterator.next();
            if (!filteredAssetHandles.contains(currentAsset.getAssetHandle())) continue;
            assetIterator.remove();
        }
        return assetList;
    }

    private String[] getSubTypes(String[] assetTypes) {
        if (assetTypes == null) {
            return null;
        }
        ArrayList<String> typeArr = new ArrayList<String>();
        for (int i = 0; i < assetTypes.length; ++i) {
            if (!this.isAssetSet(assetTypes[i])) continue;
            typeArr.add(assetTypes[i]);
        }
        if (typeArr.size() == 0) {
            return null;
        }
        String[] ret = new String[typeArr.size()];
        typeArr.toArray(ret);
        return ret;
    }

    private void convertSubTypes(String[] assetTypes) {
        if (assetTypes == null) {
            return;
        }
        for (int i = 0; i < assetTypes.length; ++i) {
            if (!this.isAssetSet(assetTypes[i])) continue;
            assetTypes[i] = "AssetSet";
        }
    }

    private boolean isAssetSet(String subtype) {
        return subtype.equals("MediaSet") || subtype.equals("MbrSet") || subtype.equals("VideoSet") || subtype.equals("OfferSet") || subtype.equals("TemplateSet") || subtype.equals("SpinSet2d");
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7configResolver = s7ConfigResolver;
    }

    protected void unbindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7configResolver == s7ConfigResolver) {
            this.s7configResolver = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    protected void bindScene7AssetMimeTypeService(Scene7AssetMimetypeService scene7AssetMimetypeService) {
        this.scene7AssetMimeTypeService = scene7AssetMimetypeService;
    }

    protected void unbindScene7AssetMimeTypeService(Scene7AssetMimetypeService scene7AssetMimetypeService) {
        if (this.scene7AssetMimeTypeService == scene7AssetMimetypeService) {
            this.scene7AssetMimeTypeService = null;
        }
    }
}

