/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.i18n.I18n;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.dam.scene7.servlet.name", description="%cq.dam.scene7.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/scene7page"}), @Property(name="sling.servlet.selectors", value={"companies"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"POST"})})
public class Scene7Servlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7Servlet.class);
    private static final String PARAMETER_EMAIL = "email";
    private static final String PARAMETER_PASSWORD = "password";
    private static final String PARAMETER_REGION = "region";
    @Reference
    protected Scene7Service scene7Service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        I18n i18n = new I18n((HttpServletRequest)request);
        String email = request.getParameter(PARAMETER_EMAIL);
        String password = request.getParameter(PARAMETER_PASSWORD);
        String region = request.getParameter(PARAMETER_REGION);
        JSONObject jsonResponse = new JSONObject();
        try {
            if (StringUtils.isNotEmpty((String)email) && StringUtils.isNotEmpty((String)password) && StringUtils.isNotEmpty((String)region)) {
                String userHandle = this.scene7Service.getUserHandle(email, password, region);
                if (userHandle != null) {
                    String companies = this.scene7Service.getCompanyMembership(userHandle, email, password, region);
                    if (companies.startsWith("failed")) {
                        jsonResponse.put("error", (Object)i18n.get("Getting company list from Scene7 failed."));
                        LOG.error("Getting company list from Scene7 failed.");
                    } else {
                        jsonResponse.put("userHandle", (Object)userHandle);
                        JSONArray companiesArray = new JSONArray(companies);
                        jsonResponse.put("companies", (Object)companiesArray);
                    }
                } else {
                    jsonResponse.put("error", (Object)i18n.get("Login to Scene7 failed. Please check the error log for more details."));
                    LOG.error("Login to Scene7 failed.");
                }
            } else {
                jsonResponse.put("error", (Object)i18n.get("Please input all needed data in order to create a Scene7 connection."));
                LOG.error("Not all Scene7 connection parameters were supplied.");
            }
        }
        catch (JSONException e) {
            LOG.error("Error creating JSON response", (Throwable)e);
        }
        finally {
            out.write(jsonResponse.toString());
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }
}

