/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.servlets;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.S7ConfigResolver;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.Scene7Folder;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(label="%cq.scene7.servlet.name", description="%cq.scene7.servlet.description")
@Service
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"dam/components/scene7/scene7page"}), @Property(name="sling.servlet.selectors", value={"foldertree"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"})})
public class Scene7TreeServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7TreeServlet.class);
    @Reference
    protected Scene7Service scene7Service;
    @Reference
    protected S7ConfigResolver s7configResolver;
    private static final String PATH = "path";
    private static final String ASSET_TYPE = "assetType";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        PrintWriter out = response.getWriter();
        Resource resource = request.getResource();
        S7Config s7Config = null;
        if (resource != null) {
            String configPath = resource.getPath();
            configPath = configPath.replaceAll("/jcr:content$", "");
            s7Config = this.s7configResolver.getS7Config(configPath);
        } else {
            LOG.warn("Could not load a valid Scene7 configuration!");
        }
        JSONArray jsonArray = new JSONArray();
        try {
            if (s7Config != null) {
                String assetType;
                String path = request.getParameter(PATH);
                String rootPath = s7Config.getBasePath();
                if (path != null) {
                    path = path.equals("/content") ? rootPath : (path.startsWith("/content/") ? rootPath + path.substring("/content/".length()) : path);
                }
                String[] assetTypes = (assetType = request.getParameter(ASSET_TYPE)) != null ? assetType.split(",") : null;
                Scene7Folder s7Folder = this.scene7Service.getFolderTree(path, 2, new String[]{"folders/folderHandle", "folders/path", "folders/subfolderArray", "folders/childLastModified"}, null, s7Config);
                if (s7Folder != null) {
                    String name = "";
                    int idx = -1;
                    List<Scene7Folder> subFolders = s7Folder.getSubFolders();
                    for (Scene7Folder subFolder : subFolders) {
                        JSONObject element = new JSONObject();
                        name = subFolder.getPath();
                        idx = (name = name.substring(0, name.length() - 1)).lastIndexOf("/");
                        if (idx != -1) {
                            name = name.substring(name.lastIndexOf("/") + 1);
                        }
                        element.put("name", (Object)name);
                        element.put("text", (Object)name);
                        element.put("type", (Object)"sling:Folder");
                        element.put("cls", (Object)"folder");
                        if (assetTypes == null && subFolder.getSubFolders().size() == 0) {
                            element.put("leaf", (Object)"true");
                        }
                        if (element.length() <= 0) continue;
                        jsonArray.put((Object)element);
                    }
                    if (assetTypes != null) {
                        List<Scene7Asset> assets = this.scene7Service.searchAssets(path, Boolean.FALSE, Boolean.TRUE, assetTypes, null, new String[]{"assetArray/items/name", "assetArray/items/assetHandle", "assetArray/items/type", "assetArray/items/subType", "totalRows"}, null, s7Config);
                        for (Scene7Asset asset : assets) {
                            JSONObject element = new JSONObject();
                            element.put("name", (Object)(asset.getName() + " (" + asset.getAssetType().getValue() + ")"));
                            element.put("text", (Object)(asset.getName() + " (" + asset.getAssetType().getValue() + ")"));
                            element.put("type", (Object)"dam:Asset");
                            element.put("cls", (Object)"file");
                            element.put("leaf", (Object)"true");
                            jsonArray.put((Object)element);
                        }
                    }
                }
            }
        }
        catch (JSONException e) {
            LOG.error("Error creating JSON object", (Throwable)e);
        }
        finally {
            out.write(jsonArray.toString());
        }
    }

    protected void bindScene7Service(Scene7Service scene7Service) {
        this.scene7Service = scene7Service;
    }

    protected void unbindScene7Service(Scene7Service scene7Service) {
        if (this.scene7Service == scene7Service) {
            this.scene7Service = null;
        }
    }

    protected void bindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        this.s7configResolver = s7ConfigResolver;
    }

    protected void unbindS7configResolver(S7ConfigResolver s7ConfigResolver) {
        if (this.s7configResolver == s7ConfigResolver) {
            this.s7configResolver = null;
        }
    }
}

