/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.utils;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.util.DamUtil;
import com.day.cq.dam.scene7.impl.model.FolderAssets;
import java.util.ArrayList;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderAssetsUtils {
    private static final Logger log = LoggerFactory.getLogger(FolderAssetsUtils.class);

    public static ArrayList<FolderAssets> getFolderAssetsList(Node parentNode, Boolean includeSubFolders) {
        ArrayList<FolderAssets> folderAssetsList = new ArrayList<FolderAssets>();
        FolderAssets folderAssets = new FolderAssets(parentNode);
        folderAssetsList.add(folderAssets);
        try {
            folderAssets.getAssets().addAll(FolderAssetsUtils.addFolderAssets(parentNode));
            if (includeSubFolders.booleanValue()) {
                NodeIterator childNodes = parentNode.getNodes();
                while (childNodes.hasNext()) {
                    Node node = (Node)childNodes.next();
                    if (!FolderAssetsUtils.isFolderNode(node)) continue;
                    folderAssetsList.addAll(FolderAssetsUtils.getFolderAssetsList(node, includeSubFolders));
                }
            }
        }
        catch (RepositoryException e) {
            log.error("addSubFolderAssets failed with ", (Object)e.getMessage());
        }
        return folderAssetsList;
    }

    private static ArrayList<String> addFolderAssets(Node parentNode) {
        ArrayList<String> assetPaths = new ArrayList<String>();
        try {
            NodeIterator childNodes = parentNode.getNodes();
            while (childNodes.hasNext()) {
                Node node = (Node)childNodes.next();
                if (!FolderAssetsUtils.isAssetNode(node)) continue;
                assetPaths.add(node.getPath());
            }
        }
        catch (RepositoryException e) {
            log.error("addFolderAssets failed with ", (Object)e.getMessage());
        }
        return assetPaths;
    }

    public static int getFolderSubfoldersCount(Node parentNode) {
        int folderCount = 0;
        try {
            if (!FolderAssetsUtils.isFolderNode(parentNode)) {
                return folderCount;
            }
            NodeIterator childNodes = parentNode.getNodes();
            while (childNodes.hasNext()) {
                Node node = (Node)childNodes.next();
                if (!FolderAssetsUtils.isFolderNode(node)) continue;
                ++folderCount;
            }
        }
        catch (RepositoryException e) {
            log.error("getFolderSubfoldersCount failed with ", (Object)e.getMessage());
        }
        return folderCount;
    }

    public static int getAssetsCount(Node parentNode, Boolean includeSubFolders) {
        int fileCount = 0;
        try {
            if (!FolderAssetsUtils.isFolderNode(parentNode)) {
                return fileCount;
            }
            FolderAssets folderAssets = new FolderAssets(parentNode);
            fileCount = FolderAssetsUtils.getAssetsCount(folderAssets);
            if (includeSubFolders.booleanValue()) {
                NodeIterator childNodes = parentNode.getNodes();
                while (childNodes.hasNext()) {
                    Node node = (Node)childNodes.next();
                    if (!FolderAssetsUtils.isFolderNode(node)) continue;
                    fileCount += FolderAssetsUtils.getAssetsCount(node, includeSubFolders);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("getFolderAssetsCount failed with ", (Object)e.getMessage());
        }
        return fileCount;
    }

    public static int getAssetsCount(FolderAssets folderAssets) {
        int fileCount = 0;
        try {
            NodeIterator childNodes = folderAssets.getFolderNode().getNodes();
            while (childNodes.hasNext()) {
                Node node = (Node)childNodes.next();
                if (!FolderAssetsUtils.isAssetNode(node)) continue;
                ++fileCount;
            }
        }
        catch (RepositoryException e) {
            log.error("getFolderAssetsCount failed with ", (Object)e.getMessage());
        }
        return fileCount;
    }

    public static int getFolderAssetsFileSizeTotal(Resource parentResource, Boolean includeSubFolders) {
        int fileSizeTotal = 0;
        Node parentNode = (Node)parentResource.adaptTo(Node.class);
        ResourceResolver resolver = parentResource.getResourceResolver();
        FolderAssets folderAssets = new FolderAssets(parentNode);
        fileSizeTotal = FolderAssetsUtils.getFolderAssetsFileSizeTotal(folderAssets, resolver);
        try {
            if (includeSubFolders.booleanValue()) {
                NodeIterator childNodes = parentNode.getNodes();
                while (childNodes.hasNext()) {
                    Node node = (Node)childNodes.next();
                    if (!FolderAssetsUtils.isFolderNode(node)) continue;
                    Resource resource = resolver.getResource(node.getPath());
                    fileSizeTotal += FolderAssetsUtils.getFolderAssetsFileSizeTotal(resource, includeSubFolders);
                }
            }
        }
        catch (RepositoryException e) {
            log.error("getFolderAssetsFileSizeTotal failed with ", (Object)e.getMessage());
        }
        return fileSizeTotal;
    }

    public static int getFolderAssetsFileSizeTotal(FolderAssets folderAssets, ResourceResolver resolver) {
        int fileSizeTotal = 0;
        try {
            NodeIterator childNodes = folderAssets.getFolderNode().getNodes();
            while (childNodes.hasNext()) {
                Node nextNode = (Node)childNodes.next();
                Resource nextResource = resolver.getResource(nextNode.getPath());
                fileSizeTotal += FolderAssetsUtils.getAssetFileSize(nextResource);
            }
        }
        catch (RepositoryException e) {
            log.error("getFolderAssetsFileSizeTotal failed with ", (Object)e.getMessage());
        }
        return fileSizeTotal;
    }

    public static int getAssetFileSize(Resource assetResource) {
        int fileSize = 0;
        Asset asset = DamUtil.resolveToAsset((Resource)assetResource);
        if (asset != null) {
            fileSize = (int)((long)fileSize + asset.getOriginal().getSize());
        }
        return fileSize;
    }

    public static Node prepareScene7FolderContent(Node folderNode, ResourceResolver resolver) throws RepositoryException {
        return folderNode;
    }

    public static Node getOrAddNode(Node node, String name, String nodetype) throws RepositoryException {
        if (node.hasNode(name)) {
            return node.getNode(name);
        }
        return node.addNode(name, nodetype);
    }

    public static boolean isFolderNodeDeepScene7Managed(Node folderNode) {
        try {
            if (!FolderAssetsUtils.isFolderNode(folderNode)) {
                return false;
            }
            if (FolderAssetsUtils.folderNodeHasSetForDeepPublish(folderNode)) {
                return true;
            }
            if (folderNode.getDepth() > 0) {
                return FolderAssetsUtils.isFolderNodeDeepScene7Managed(folderNode.getParent());
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("isFolderNodeDeepScene7Managed Cloud Config reference not found");
        }
        catch (Exception e) {
            log.error("isFolderNodeDeepS7Managed failed with ", (Object)e.getMessage());
        }
        return false;
    }

    public static boolean isAssetNodeScene7Managed(Node node) {
        try {
            if (!FolderAssetsUtils.isAssetNode(node)) {
                return false;
            }
            if (FolderAssetsUtils.nodeHasScene7CloudConfig(node)) {
                return true;
            }
            if (node.getDepth() > 0 && FolderAssetsUtils.isFolderNodeScene7Managed(node.getParent())) {
                return true;
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("isNodeScene7Managed Cloud Config reference not found");
        }
        catch (Exception e) {
            log.error("isNodeScene7Managed failed with ", (Object)e.getMessage());
        }
        return false;
    }

    public static boolean isFolderNodeScene7Managed(Node node) {
        try {
            if (!FolderAssetsUtils.isFolderNode(node)) {
                return false;
            }
            if (FolderAssetsUtils.nodeHasScene7CloudConfig(node)) {
                return true;
            }
            Node parentNode = node.getParent();
            while (parentNode.getDepth() > 0) {
                if (FolderAssetsUtils.isFolderNodeDeepScene7Managed(parentNode)) {
                    return true;
                }
                parentNode = parentNode.getParent();
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("isNodeScene7Managed Cloud Config reference not found");
        }
        catch (Exception e) {
            log.error("isNodeScene7Managed failed with ", (Object)e.getMessage());
        }
        return false;
    }

    public static boolean folderNodeHasSetForDeepPublish(Node folderNode) {
        try {
            if (!FolderAssetsUtils.isFolderNode(folderNode)) {
                return false;
            }
            Node contentNode = folderNode;
            if (contentNode.hasProperty("dam:scene7PublishSubFolders")) {
                return "true".equals(contentNode.getProperty("dam:scene7PublishSubFolders").getString());
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("nodeHasScene7CloudConfig Cloud Config reference not found");
        }
        catch (Exception e) {
            log.error("nodeHasScene7CloudConfig failed with ", (Object)e.getMessage());
        }
        return false;
    }

    public static void setFolderNodeForDeepPublish(Node node, String value, ResourceResolver resolver) {
        try {
            if (!FolderAssetsUtils.isFolderNode(node)) {
                return;
            }
            Node metadata = FolderAssetsUtils.prepareScene7FolderContent(node, resolver);
            metadata.setProperty("dam:scene7PublishSubFolders", value);
        }
        catch (Exception e) {
            log.error("isNodeScene7Managed failed with ", (Object)e.getMessage());
        }
    }

    public static boolean nodeHasScene7CloudConfig(Node node) {
        try {
            Node contentNode = node;
            if (contentNode.hasProperty("dam:scene7CloudConfigPath")) {
                return contentNode.getProperty("dam:scene7CloudConfigPath").getString() != null;
            }
        }
        catch (ItemNotFoundException e) {
            log.debug("nodeHasScene7CloudConfig Cloud Config reference not found");
        }
        catch (Exception e) {
            log.error("nodeHasScene7CloudConfig failed with ", (Object)e.getMessage());
        }
        return false;
    }

    public static String getScene7CloudConfigPath(Node node) {
        try {
            Node contentNode = node;
            if (contentNode.hasProperty("dam:scene7CloudConfigPath")) {
                return contentNode.getProperty("dam:scene7CloudConfigPath").getString();
            }
            return FolderAssetsUtils.getScene7CloudConfigPath(node.getParent());
        }
        catch (ItemNotFoundException e) {
            log.debug("getScene7CloudConfigPath Config reference not found");
        }
        catch (Exception e) {
            log.error("isNodeScene7Managed failed with ", (Object)e.getMessage());
        }
        return null;
    }

    public static boolean isAssetNode(Node node) throws RepositoryException {
        return node.isNodeType("dam:Asset");
    }

    public static boolean isFolderNode(Node node) throws RepositoryException {
        return node.isNodeType("nt:folder");
    }
}

