/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.scene7.impl.utils;

import com.day.cq.dam.scene7.api.S7Config;
import com.day.cq.dam.scene7.api.Scene7Service;
import com.day.cq.dam.scene7.api.model.Scene7Asset;
import com.day.cq.dam.scene7.api.model.Scene7AssetImpl;
import com.day.cq.dam.scene7.impl.protocol.NameValue;
import com.day.cq.dam.scene7.impl.protocol.is.ISProtocolParser;
import com.day.cq.dam.scene7.impl.protocol.is.ParamCommand;
import com.day.cq.dam.scene7.impl.protocol.is.ParamUtils;
import java.util.HashMap;
import java.util.Vector;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scene7AssetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(Scene7AssetUtils.class);

    public static String getAbsoluteTargetPath(String rootPath, String targetPath, String scene7AssetFolderPath) {
        String path = null;
        if (rootPath != null && scene7AssetFolderPath != null && targetPath != null) {
            if (!rootPath.endsWith("/")) {
                rootPath = rootPath + "/";
            }
            if (!targetPath.endsWith("/")) {
                targetPath = targetPath + "/";
            }
            StringBuilder pathSB = new StringBuilder(targetPath);
            pathSB.append(scene7AssetFolderPath.replaceFirst(rootPath, ""));
            path = pathSB.toString();
        }
        return path;
    }

    public static String extractTemplateParams(String urlModifier) {
        String templateParams = null;
        if (urlModifier != null) {
            NameValue root = ISProtocolParser.parse(urlModifier, true);
            Vector<NameValue> params = ParamUtils.getParameters(root);
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < params.size(); ++j) {
                sb.append("&type=").append(((ParamCommand)params.elementAt(j)).getType()).append(params.elementAt(j).nodeString(false, true));
            }
            if (sb.length() > 0) {
                templateParams = sb.toString();
            }
            if (templateParams != null && templateParams.length() > 0) {
                templateParams = templateParams.substring(1);
            }
        }
        return templateParams;
    }

    public static Scene7Asset extractTemplateSizeInformation(Scene7Asset scene7Asset, Scene7Service scene7Service, S7Config s7Config) {
        String urlMod = scene7Asset.getUrlModifier();
        if (urlMod != null) {
            try {
                NameValue root = ISProtocolParser.parse(urlMod, true);
                NameValue layer0 = root.getNode("layer", "0");
                NameValue size = layer0 != null ? layer0.getNode("size") : null;
                NameValue src = layer0 != null ? layer0.getNode("src") : null;
                Long width = null;
                Long height = null;
                if (size != null) {
                    String[] sizeArr = size.getValue().split(",");
                    if (sizeArr.length > 1) {
                        width = Long.parseLong(sizeArr[0]);
                        height = Long.parseLong(sizeArr[1]);
                    }
                } else if (src != null && (scene7Asset = scene7Service.getAssociatedAssets(scene7Asset, s7Config)).getSubAssets().size() > 0) {
                    Scene7Asset firstSubAsset = scene7Asset.getSubAssets().get(0);
                    width = firstSubAsset.getWidth();
                    height = firstSubAsset.getHeight();
                }
                HashMap<Object, Object> changedAssetProperties = new HashMap<Object, Object>();
                changedAssetProperties.put((Object)Scene7AssetImpl.Scene7AssetProperty.WIDTH, width);
                changedAssetProperties.put((Object)Scene7AssetImpl.Scene7AssetProperty.HEIGHT, height);
                scene7Asset = new Scene7AssetImpl(scene7Asset, changedAssetProperties);
            }
            catch (Exception e) {
                LOG.warn("Could not extract template size information for asset {}!", (Object)scene7Asset.getName());
            }
        }
        return scene7Asset;
    }

    public static Integer parseInt(String string) {
        Integer value = null;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static Long parseLong(String string) {
        Long value = null;
        try {
            value = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return value;
    }

    public static String getExtensionForFileReference(String fileReference) {
        String file;
        int index = fileReference.lastIndexOf("/");
        String extension = null;
        if (index != -1 && "".equals(extension = FilenameUtils.getExtension((String)(file = fileReference.substring(index + 1))))) {
            extension = null;
        }
        return extension;
    }
}

