/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.ffmpeg;

import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FfmpegNotFoundException;
import com.day.cq.dam.handler.ffmpeg.LoggerOutputStream;
import com.day.cq.dam.video.VideoProfile;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMpegWrapper {
    private Boolean installed = null;
    private static final Logger log = LoggerFactory.getLogger(FFMpegWrapper.class);
    private static final LoggerOutputStream LOG_STREAM;
    private static final SimpleDateFormat TIME_FORMAT;
    private static final String FFMPEG_CMD = "ffmpeg";
    private File input;
    private Dimension outputsize;
    private DefaultExecutor infoExecutor = new DefaultExecutor();
    private DefaultExecutor transcodeExecutor = new DefaultExecutor();
    private DefaultExecutor testExecutor = new DefaultExecutor();
    private long duration = -1L;
    private boolean letterbox = false;
    private Dimension inputsize;
    private int bitrate = 0;
    private String fps = null;
    private int bitrateTolerance = 0;
    private String videoCodec = null;
    private String audioCodec = null;
    private int audioChannels = 0;
    private int audioSamplingRate = 0;
    private int audioBitrate = 0;
    private boolean twoPass = false;
    private String[] customFlags = null;
    private long startTime = 0L;
    private long clipDuration = 0L;
    private Rectangle crop;
    private String preset = null;
    private boolean fitInside;
    private String extension;
    private String outputMimetype;
    private String profileName;
    private StringBuilder ffmpegOutput = new StringBuilder();
    private ExecutableLocator locator = new ExecutableLocator(){

        public String getPath(String cmd) {
            return FFMpegWrapper.FFMPEG_CMD;
        }
    };

    public String getOutputExtension() {
        return this.extension;
    }

    public void setOutputExtension(String extension) {
        this.extension = extension;
    }

    public StringBuilder getFFMpegOutput() {
        return this.ffmpegOutput;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getOutputMimetype() {
        return this.outputMimetype;
    }

    public void setOutputMimetype(String outputMimetype) {
        this.outputMimetype = outputMimetype;
    }

    public void setTwoPass() {
        this.twoPass = true;
    }

    public void setTwoPass(boolean twoPass) {
        this.twoPass = twoPass;
    }

    public void setPreset(String preset) {
        this.preset = preset;
    }

    public void setAudioSamplingRate(int audioSamplingRate) {
        this.audioSamplingRate = audioSamplingRate;
    }

    public void setAudioBitrate(int audioBitrate) {
        this.audioBitrate = audioBitrate;
    }

    public void setVideoCodec(String videoCodec) {
        this.videoCodec = videoCodec;
    }

    public void setAudioCodec(String audioCodec) {
        this.audioCodec = audioCodec;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public FFMpegWrapper(File file) {
        this(file, null);
    }

    public FFMpegWrapper(File file, File workingDir) {
        this.setInput(file);
        InfoParser infoParser = new InfoParser(this);
        this.infoExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)infoParser), (OutputStream)((Object)infoParser)));
        this.infoExecutor.setExitValue(1);
        LOG_STREAM.setWrapper(this);
        this.transcodeExecutor.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)((Object)LOG_STREAM), (OutputStream)((Object)LOG_STREAM)));
        if (workingDir != null) {
            this.infoExecutor.setWorkingDirectory(workingDir);
            this.transcodeExecutor.setWorkingDirectory(workingDir);
            this.testExecutor.setWorkingDirectory(workingDir);
        }
    }

    public void setInput(File f) {
        this.input = f;
    }

    public void setExecutableLocator(ExecutableLocator locator) {
        this.locator = locator;
    }

    public void setOutputSize(Dimension dimension) {
        this.outputsize = dimension;
        if (this.outputsize != null) {
            this.outputsize.setSize(this.outputsize.width % 2 + this.outputsize.width, this.outputsize.height % 2 + this.outputsize.height);
        }
    }

    public Dimension getOutputSize() {
        return this.outputsize;
    }

    public long getInputDuration() {
        if (this.duration > -1L) {
            return this.duration;
        }
        try {
            this.info();
        }
        catch (IOException e) {
            return -1L;
        }
        return this.duration;
    }

    public Dimension getInputSize() {
        if (this.inputsize != null) {
            return this.inputsize;
        }
        try {
            this.info();
        }
        catch (IOException e) {
            log.warn("getInputSize: I/O error: ", (Throwable)e);
            return null;
        }
        return this.inputsize;
    }

    private String getFfmpegPath() {
        String path = this.locator.getPath(FFMPEG_CMD);
        if (path == null) {
            log.info("Could not find ffmpeg's location, trying direct call to '{}'", (Object)FFMPEG_CMD);
            path = FFMPEG_CMD;
        }
        return path;
    }

    private CommandLine ffmpeg() {
        if (!this.isFfmpegInstalled()) {
            throw new FfmpegNotFoundException("Could not find ffmpeg's executable");
        }
        String path = this.getFfmpegPath();
        CommandLine cmd = new CommandLine(path);
        return cmd;
    }

    private void info() throws IOException {
        CommandLine cli = this.ffmpeg();
        cli.addArgument("-i");
        cli.addArgument(this.input.getPath());
        log.info("**** Exec (info): [{}]", (Object)cli);
        this.infoExecutor.execute(cli);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage[] getThumbnails(int thumbnails, int start) {
        try {
            double fraction = this.getInputDuration() / 1000L / (long)thumbnails;
            final long specifier = System.currentTimeMillis();
            for (int i = 0; i < thumbnails; ++i) {
                double pos = (double)i * fraction;
                CommandLine cli = this.ffmpeg();
                if (start > 0) {
                    cli.addArgument("-itsoffset");
                    cli.addArgument("-" + String.valueOf(start));
                }
                cli.addArgument("-ss");
                cli.addArgument(String.valueOf(pos));
                cli.addArgument("-i");
                cli.addArgument(this.input.getPath());
                cli.addArgument("-vframes");
                cli.addArgument("1");
                cli.addArgument("-y");
                cli.addArgument(this.input.getParent() + File.separator + "tempthumb." + specifier + "." + i + ".jpg");
                log.debug("grabbing frame [{}] at pos [{}] for [" + this.input.getPath() + "]...", (Object)(i + 1), (Object)pos);
                log.info("**** Exec (thumbs): [{}]", (Object)cli);
                this.transcodeExecutor.execute(cli);
            }
            File[] thumbFiles = this.input.getParentFile().listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches("tempthumb\\." + specifier + "\\.(\\d)+\\.jpg");
                }
            });
            log.info("created {} thumbnails", (Object)thumbFiles.length);
            BufferedImage[] images = new BufferedImage[thumbFiles.length];
            for (int j = 0; j < thumbFiles.length; ++j) {
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(thumbFiles[j]);
                    images[j] = ImageIO.read(fis);
                }
                catch (Exception e) {
                    try {
                        log.warn("error reading image [{}]", (Object)thumbFiles[j]);
                        images[j] = null;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(fis);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)fis);
                }
                IOUtils.closeQuietly((InputStream)fis);
                thumbFiles[j].delete();
            }
            return images;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File join(File other, String name) throws IOException {
        CommandLine intermediate1cli = this.ffmpeg();
        CommandLine intermediate2cli = this.ffmpeg();
        CommandLine joincli = this.ffmpeg();
        File intermediate1file = new File(this.input.getParentFile(), "intermediate." + this.input.getName().replaceAll("\\.\\w+", "") + ".mpg");
        File intermediate2file = new File(other.getParentFile(), "intermediate." + other.getName().replaceAll("\\.\\w+", "") + ".mpg");
        File joinfile = new File(this.input.getParentFile(), name + ".intermediate." + this.input.getName().replaceAll("\\.\\w+", "") + ".mpg");
        File outputfile = new File(this.input.getParentFile(), name + "." + this.input.getName());
        intermediate1cli.addArgument("-i");
        intermediate1cli.addArgument(this.input.getPath());
        intermediate1cli.addArgument("-y");
        intermediate1cli.addArgument("-sameq");
        intermediate1cli.addArgument("-r");
        intermediate1cli.addArgument("24");
        intermediate1cli.addArgument(intermediate1file.getPath());
        log.info("**** Exec (intermediate join 1): [{}]", (Object)joincli);
        this.transcodeExecutor.execute(intermediate1cli);
        intermediate2cli.addArgument("-i");
        intermediate2cli.addArgument(other.getPath());
        intermediate2cli.addArgument("-y");
        intermediate2cli.addArgument("-sameq");
        intermediate2cli.addArgument("-r");
        intermediate2cli.addArgument("24");
        intermediate2cli.addArgument(intermediate2file.getPath());
        log.info("**** Exec (intermediate join 2): [{}]", (Object)joincli);
        this.transcodeExecutor.execute(intermediate2cli);
        FileOutputStream join = null;
        FileInputStream isOne = null;
        FileInputStream isTwo = null;
        try {
            join = new FileOutputStream(joinfile);
            isOne = new FileInputStream(intermediate1file);
            IOUtils.copy((InputStream)isOne, (OutputStream)join);
            join.flush();
            isTwo = new FileInputStream(intermediate2file);
            IOUtils.copy((InputStream)isTwo, (OutputStream)join);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(join);
            IOUtils.closeQuietly(isOne);
            IOUtils.closeQuietly(isTwo);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)join);
        IOUtils.closeQuietly((InputStream)isOne);
        IOUtils.closeQuietly((InputStream)isTwo);
        joincli.addArgument("-i");
        joincli.addArgument(joinfile.getPath());
        joincli.addArgument("-y");
        joincli.addArgument("-sameq");
        joincli.addArgument("-s");
        Dimension size = this.getInputSize();
        joincli.addArgument(size.width + "x" + size.height);
        joincli.addArgument(outputfile.getPath());
        log.info("**** Exec (join): [{}]", (Object)joincli);
        this.transcodeExecutor.execute(joincli);
        intermediate1file.delete();
        intermediate2file.delete();
        joinfile.delete();
        return outputfile;
    }

    public File trim(String name) throws IOException {
        CommandLine cli = this.ffmpeg();
        cli.addArgument("-i");
        cli.addArgument(this.input.getPath());
        cli.addArgument("-y");
        if (this.startTime > 0L) {
            Date start = new Date(this.startTime);
            cli.addArgument("-ss");
            cli.addArgument(TIME_FORMAT.format(start));
        }
        if (this.clipDuration > 0L) {
            Date clipduration = new Date(this.clipDuration);
            cli.addArgument("-t");
            cli.addArgument(TIME_FORMAT.format(clipduration));
        }
        Dimension outputsize = this.getInputSize();
        if (this.crop != null) {
            int cropleft = this.crop.getLocation().x;
            cropleft += cropleft % 2;
            cropleft = Math.max(0, cropleft);
            int croptop = this.crop.getLocation().y;
            croptop += croptop % 2;
            croptop = Math.max(0, croptop);
            int cropright = outputsize.width - cropleft - this.crop.getSize().width;
            cropright -= cropright % 2;
            cropright = Math.max(0, cropright);
            int cropbottom = outputsize.height - croptop - this.crop.getSize().height;
            cropbottom -= cropbottom % 2;
            cropbottom = Math.max(0, cropbottom);
            this.addArgument(cli, "croptop", croptop);
            this.addArgument(cli, "cropleft", cropleft);
            this.addArgument(cli, "cropbottom", cropbottom);
            this.addArgument(cli, "cropright", cropright);
            outputsize.setSize(outputsize.width - cropleft - cropright, outputsize.height - croptop - cropbottom);
        }
        this.outputsize = outputsize;
        this.addResizeArguments(cli);
        File output = new File(this.input.getParentFile(), name + "." + this.input.getName());
        cli.addArgument(output.getPath());
        log.info("**** Exec (trim): [{}]", (Object)cli);
        this.transcodeExecutor.execute(cli);
        return output;
    }

    public File transcode() throws IOException {
        return this.transcode(this.getOutputExtension());
    }

    public File transcode(String extension) throws IOException {
        CommandLine cli = this.ffmpeg();
        cli.addArgument("-i");
        cli.addArgument(this.input.getPath());
        this.addResizeArguments(cli);
        this.addArgument(cli, "b", this.bitrate, "k");
        this.addArgument(cli, "r", this.fps);
        this.addArgument(cli, "bt", this.bitrateTolerance, "k");
        this.addArgument(cli, "vcodec", this.videoCodec);
        this.addArgument(cli, "acodec", this.audioCodec);
        this.addArgument(cli, "ac", this.audioChannels);
        this.addArgument(cli, "ar", this.audioSamplingRate);
        this.addArgument(cli, "ab", this.audioBitrate, "k");
        if (this.customFlags != null) {
            cli.addArguments(this.customFlags, true);
        }
        if (this.preset != null) {
            this.addArgument(cli, "vpre", this.preset);
        }
        cli.addArgument("-y");
        File output = new File(this.input.getParentFile(), this.input.getName().replaceAll("\\.\\w+", "") + ".out." + extension);
        this.ffmpegOutput = new StringBuilder();
        try {
            if (this.twoPass) {
                CommandLine pass2 = this.ffmpeg().addArguments(cli.getArguments());
                this.addArgument(cli, "pass", 1);
                cli.addArgument(output.getPath());
                this.addArgument(pass2, "pass", 2);
                pass2.addArgument(output.getPath());
                log.info("**** Exec (pass1): [{}]", (Object)cli.toString());
                this.ffmpegOutput.append(cli.toString()).append("\n\n");
                this.transcodeExecutor.execute(cli);
                log.info("**** Exec (pass2): [{}]", (Object)pass2.toString());
                this.ffmpegOutput.append(pass2.toString()).append("\n\n");
                this.transcodeExecutor.execute(pass2);
            } else {
                cli.addArgument(output.getPath());
                log.info("**** Exec: [{}]", (Object)cli.toString());
                this.ffmpegOutput.append(cli.toString()).append("\n\n");
                this.transcodeExecutor.execute(cli);
            }
            if (output.exists()) {
                return output;
            }
            throw new IOException("Transcoding did not create an output file");
        }
        catch (ExecuteException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private void addResizeArguments(CommandLine cli) {
        if (this.outputsize != null) {
            if (this.letterbox) {
                cli.addArgument("-aspect");
                cli.addArgument(this.outputsize.width + ":" + this.outputsize.height);
            }
            Dimension inputSize = this.getInputSize();
            int maxwidth = this.outputsize.width > inputSize.width ? inputSize.width : this.outputsize.width;
            int maxheight = this.outputsize.height > inputSize.height ? inputSize.height : this.outputsize.height;
            this.outputsize.setSize(new Dimension(maxwidth, maxheight));
            if (this.fitInside) {
                float inputRatio = (float)inputSize.width / (float)inputSize.height;
                float outputRatio = (float)this.outputsize.width / (float)this.outputsize.height;
                if (inputRatio > outputRatio) {
                    int height = (int)((float)this.outputsize.width / inputRatio);
                    if (this.letterbox) {
                        int padding = this.outputsize.height - height;
                        int padtop = padding / 2;
                        padtop += padtop % 2;
                        int padbottom = padding / 2;
                        padbottom -= padbottom % 2;
                        cli.addArgument("-padtop");
                        cli.addArgument("" + padtop);
                        cli.addArgument("-padbottom");
                        cli.addArgument("" + padbottom);
                    }
                    this.outputsize.height = height;
                } else if (inputRatio < outputRatio) {
                    int width = (int)((float)this.outputsize.height * inputRatio);
                    if (this.letterbox) {
                        int padding = this.outputsize.width - width;
                        int padleft = padding / 2;
                        padleft += padleft % 2;
                        int padright = padding / 2;
                        padright -= padright % 2;
                        cli.addArgument("-padleft");
                        cli.addArgument("" + padleft);
                        cli.addArgument("-padright");
                        cli.addArgument("" + padright);
                    }
                    this.outputsize.width = width;
                }
            }
            cli.addArgument("-s");
            cli.addArgument(this.outputsize.width + "x" + this.outputsize.height);
        }
    }

    public void setLetterbox() {
        this.letterbox = true;
    }

    public void setLetterbox(boolean letterbox) {
        this.letterbox = letterbox;
    }

    public void setFitInside() {
        this.fitInside = true;
    }

    public void setFitInside(boolean fitInside) {
        this.fitInside = fitInside;
    }

    public BufferedImage getFilmStrip(int frames, int width) {
        BufferedImage[] thumbs = this.getThumbnails(frames, 0);
        BufferedImage combined = new BufferedImage(frames * thumbs[0].getWidth(), thumbs[0].getHeight(), 1);
        Graphics g = combined.getGraphics();
        for (int i = 0; i < thumbs.length; ++i) {
            g.drawImage(thumbs[i], thumbs[0].getWidth() * i, 0, null);
        }
        double ratio = (double)width / (double)combined.getWidth();
        int outHeight = (int)((double)combined.getHeight() * ratio);
        BufferedImage resized = new BufferedImage(width, outHeight, 1);
        Graphics2D h = resized.createGraphics();
        AffineTransform scale = AffineTransform.getScaleInstance(ratio, ratio);
        h.drawRenderedImage(combined, scale);
        return resized;
    }

    public void setFps(String fps) {
        this.fps = fps;
    }

    public void setBitrateTolerance(int i) {
        this.bitrateTolerance = i;
    }

    private void addArgument(CommandLine cli, String argument, int value) {
        if (value > 0) {
            cli.addArgument("-" + argument);
            cli.addArgument("" + value);
        }
    }

    private void addArgument(CommandLine cli, String argument, int value, String suffix) {
        if (value > 0) {
            cli.addArgument("-" + argument);
            cli.addArgument(value + suffix);
        }
    }

    private void addArgument(CommandLine cli, String argument, String value) {
        if (value != null) {
            cli.addArgument("-" + argument);
            cli.addArgument(value);
        }
    }

    public void setAudioChannels(int i) {
        this.audioChannels = i;
    }

    public void setCustomFlags(String[] flags) {
        this.customFlags = flags;
    }

    public void setStartTime(long i) {
        this.startTime = i;
    }

    public void setClipDuration(long i) {
        this.clipDuration = i;
    }

    public void setCropArea(Rectangle rectangle) {
        this.crop = rectangle;
    }

    public void setInputsize(Dimension inputsize) {
        this.inputsize = inputsize;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public static FFMpegWrapper fromProfile(File inputFile, VideoProfile profile, File workingDir) {
        ValueMap props = profile.getProperties();
        FFMpegWrapper wrapper = new FFMpegWrapper(inputFile, workingDir);
        wrapper.setProfileName(profile.getName());
        wrapper.setOutputExtension((String)props.get("extension", String.class));
        wrapper.setOutputMimetype((String)props.get("mimeType", String.class));
        wrapper.setTwoPass((Boolean)props.get("twoPass", (Object)Boolean.FALSE));
        boolean customOnly = (Boolean)props.get("customArgsOnly", (Object)Boolean.FALSE);
        if (!customOnly) {
            wrapper.setFps((String)props.get("videoFrameRate", String.class));
            wrapper.setBitrate((Integer)props.get("videoBitrate", (Object)0));
            wrapper.setBitrateTolerance((Integer)props.get("videoBitrateTolerance", (Object)0));
            wrapper.setVideoCodec((String)props.get("videoCodec", String.class));
            wrapper.setAudioCodec((String)props.get("audioCodec", String.class));
            wrapper.setAudioChannels((Integer)props.get("audioChannels", (Object)0));
            wrapper.setAudioSamplingRate((Integer)props.get("audioSamplingRate", (Object)0));
            wrapper.setAudioBitrate((Integer)props.get("audioBitrate", (Object)0));
            wrapper.setOutputSize(profile.getOutputSize());
            wrapper.setFitInside((Boolean)props.get("fitInside", (Object)Boolean.FALSE));
            wrapper.setLetterbox((Boolean)props.get("letterBox", (Object)Boolean.FALSE));
        }
        wrapper.setCustomFlags(FFMpegWrapper.formatCustomArgs((String)props.get("customArgs", String.class)));
        return wrapper;
    }

    private static String[] formatCustomArgs(String customArgs) {
        if (customArgs != null) {
            String[] splitted;
            ArrayList<String> formattetArgs = new ArrayList<String>();
            for (String splitt : splitted = customArgs.split(" ")) {
                formattetArgs.add(splitt.trim());
            }
            return formattetArgs.toArray(new String[formattetArgs.size()]);
        }
        return null;
    }

    private boolean isFfmpegInstalled() {
        if (this.installed == null) {
            String path = this.getFfmpegPath();
            CommandLine cmd = new CommandLine(path);
            cmd.addArgument("-version");
            try {
                int exitValue = this.testExecutor.execute(cmd);
                this.installed = exitValue == 0;
            }
            catch (ExecuteException e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.installed = Boolean.FALSE;
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
                this.installed = Boolean.FALSE;
            }
        }
        return this.installed;
    }

    static {
        TIME_FORMAT = new SimpleDateFormat("H:mm:ss.S");
        TIME_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        LOG_STREAM = new LoggerOutputStream(log);
    }

    private class InfoParser
    extends LogOutputStream {
        private FFMpegWrapper wrapper;

        public InfoParser(FFMpegWrapper wrapper) {
            this.wrapper = wrapper;
        }

        protected void processLine(String line, int level) {
            if (line.matches("^  Duration: .*")) {
                String duration = line.replaceFirst("^  Duration: (\\d\\d:\\d\\d:\\d\\d.\\d\\d),.*", "$1");
                try {
                    Date time = TIME_FORMAT.parse(duration);
                    this.wrapper.setDuration(time.getTime());
                }
                catch (ParseException e) {}
            } else if (line.matches("^    Stream.* Video: .* \\d+x\\d+.*")) {
                String width = line.replaceFirst("^    Stream.* Video: .* (\\d+)x\\d+.*", "$1");
                String height = line.replaceFirst("^    Stream.* Video: .* \\d+x(\\d+).*", "$1");
                this.wrapper.setInputsize(new Dimension(Integer.parseInt(width), Integer.parseInt(height)));
            }
        }
    }
}

