/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.handler.ffmpeg;

import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import java.io.File;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorImpl
implements ExecutableLocator {
    private static final Logger log = LoggerFactory.getLogger(LocatorImpl.class);
    public static final String PROP_SEARCH_PATH = "executable.searchpath";
    private static final String PATH_ENV = "PATH";
    private static final String[] FALLBACK_SEARCH_PATH = new String[]{"PATH"};
    private List<String> searchPath;
    private File last;

    public LocatorImpl() {
    }

    public LocatorImpl(String[] searchPath) {
        this.setSearchPath(searchPath);
    }

    protected void activate(ComponentContext componentContext) {
        Dictionary properties = componentContext.getProperties();
        String[] sp = OsgiUtil.toStringArray(properties.get(PROP_SEARCH_PATH));
        if (sp == null || sp.length == 0) {
            this.setSearchPath(FALLBACK_SEARCH_PATH);
        } else {
            this.setSearchPath(sp);
        }
    }

    protected void setSearchPath(String[] sp) {
        this.searchPath = new ArrayList<String>();
        for (int i = 0; i < sp.length; ++i) {
            if (PATH_ENV.equals(sp[i])) {
                String[] paths = LocatorImpl.getPathEnv();
                for (int j = 0; j < paths.length; ++j) {
                    this.searchPath.add(paths[j]);
                }
                continue;
            }
            this.searchPath.add(sp[i]);
        }
        log.info("Search path: {}", (Object)StringUtils.join((Object[])this.searchPath.toArray(), (String)", "));
    }

    public synchronized String getPath(String cmd) {
        if (SystemUtils.IS_OS_WINDOWS && cmd != null && !cmd.endsWith(".exe")) {
            cmd = cmd + ".exe";
        }
        if (this.last != null && this.last.getName().equals(cmd) && this.last.exists()) {
            log.debug("Found executable '{}' (cached): {}", (Object)cmd, (Object)this.last.getAbsolutePath());
            return this.last.getAbsolutePath();
        }
        if (this.searchPath != null) {
            for (String path : this.searchPath) {
                File file = new File(path, cmd);
                if (!file.exists()) continue;
                this.last = file;
                log.debug("Found executable '{}': {}", (Object)cmd, (Object)file.getAbsolutePath());
                return file.getAbsolutePath();
            }
        }
        log.warn("Could not find executable '{}'!", (Object)cmd);
        return null;
    }

    public static String[] getPathEnv() {
        String path = System.getenv(PATH_ENV);
        if (path == null) {
            path = System.getenv("Path");
        }
        if (path == null) {
            return new String[0];
        }
        return StringUtils.split((String)path, (char)File.pathSeparatorChar);
    }
}

