/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.process.AbstractAssetWorkflowProcess;
import com.day.cq.dam.handler.ffmpeg.ExecutableLocator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.handler.ffmpeg.FfmpegNotFoundException;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.commons.mime.MimeTypeService;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFFMpegProcess
extends AbstractAssetWorkflowProcess {
    protected final Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static final String PROP_WORKING_DIR = "ffmpeg.workingdir";
    protected MimeTypeService mimeTypeService;
    protected ExecutableLocator locator;
    private File workingDir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(WorkItem workItem, WorkflowSession wfSession, MetaDataMap metaData) throws WorkflowException {
        Asset asset = this.getAssetFromPayload(workItem, wfSession.getSession());
        if (asset == null) {
            this.log.error("execute: cannot process video, asset [{}] contained in workflow [{}] doesn't exist.", (Object)workItem.getWorkflowData().getPayload().toString(), (Object)workItem.getId());
            return;
        }
        String assetMimeType = asset.getMimeType();
        if (!(assetMimeType != null && assetMimeType.startsWith("video/") || asset.getName().endsWith(".mov") && asset.getName().endsWith(".m4v") && asset.getName().endsWith(".avi") && asset.getName().endsWith(".flv"))) {
            this.log.info("execute: asset [{}] is not of a video mime type, asset ignored.", (Object)asset.getPath());
            return;
        }
        File tmpDir = null;
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            tmpDir = File.createTempFile("cqdam", null);
            tmpDir.delete();
            tmpDir.mkdir();
            File tmpFile = new File(tmpDir, asset.getName());
            fos = new FileOutputStream(tmpFile);
            is = asset.getOriginal().getStream();
            IOUtils.copy((InputStream)is, (OutputStream)fos);
            this.processVideo(metaData, asset, tmpFile, wfSession);
            FFMpegWrapper wrapper = new FFMpegWrapper(tmpFile, this.getWorkingDir());
            wrapper.setExecutableLocator(this.locator);
            ResourceResolver resolver = this.getResourceResolver(wfSession.getSession());
            Resource assetResource = (Resource)asset.adaptTo(Resource.class);
            Resource metadata = resolver.getResource(assetResource, "jcr:content/metadata");
            if (null != metadata) {
                double height;
                Node metadataNode = (Node)metadata.adaptTo(Node.class);
                metadataNode.setProperty("dc:extent", wrapper.getInputDuration());
                double width = null != wrapper.getInputSize() ? wrapper.getInputSize().getWidth() : 0.0;
                double d = height = null != wrapper.getInputSize() ? wrapper.getInputSize().getHeight() : 0.0;
                if (width > 0.0 && height > 0.0) {
                    metadataNode.setProperty("tiff:ImageWidth", wrapper.getInputSize().getWidth());
                    metadataNode.setProperty("tiff:ImageLength", wrapper.getInputSize().getHeight());
                }
                metadataNode.getSession().save();
            } else {
                this.log.warn("execute: failed setting metdata for asset [{}] in workflow [{}], no metdata node found.", (Object)asset.getPath(), (Object)workItem.getId());
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        catch (IOException e) {
            throw new WorkflowException((Throwable)e);
            catch (RepositoryException e2) {
                throw new WorkflowException((Throwable)e2);
            }
            catch (FfmpegNotFoundException e3) {
                this.log.error(e3.getMessage(), (Throwable)e3);
                return;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        try {
            if (tmpDir == null) return;
            FileUtils.deleteDirectory((File)tmpDir);
            return;
        }
        catch (IOException e) {
            this.log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
            throw new WorkflowException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(is);
            IOUtils.closeQuietly(fos);
            try {
                if (tmpDir != null) {
                    FileUtils.deleteDirectory((File)tmpDir);
                }
            }
            catch (IOException e) {
                this.log.error("Could not delete temp directory: {}", (Object)tmpDir.getPath());
                throw new WorkflowException((Throwable)e);
            }
        }
    }

    public File getWorkingDir() {
        this.workingDir.mkdir();
        return this.workingDir;
    }

    private File resolveWorkingDir(String slingHome, String path) {
        File workingDir;
        if (path == null) {
            path = "";
        }
        if (!(workingDir = new File(path = path.replace('/', File.separatorChar))).isAbsolute()) {
            File baseDir = new File(slingHome == null ? "" : slingHome).getAbsoluteFile();
            workingDir = new File(baseDir, path).getAbsoluteFile();
        }
        try {
            this.log.info("ffmpeg working directory: {}", (Object)workingDir.getCanonicalPath());
        }
        catch (IOException e) {
            this.log.info("ffmpeg working directory: {}", (Object)workingDir.getAbsolutePath());
        }
        return workingDir;
    }

    protected void activate(ComponentContext ctx) {
        String slingHome = ctx.getBundleContext().getProperty("sling.home");
        this.workingDir = this.resolveWorkingDir(slingHome, (String)ctx.getProperties().get(PROP_WORKING_DIR));
    }

    abstract String[] buildArguments(MetaDataMap var1);

    abstract void processVideo(MetaDataMap var1, Asset var2, File var3, WorkflowSession var4) throws IOException, RepositoryException;

    protected void bindLocator(ExecutableLocator executableLocator) {
        this.locator = executableLocator;
    }

    protected void unbindLocator(ExecutableLocator executableLocator) {
        if (this.locator == executableLocator) {
            this.locator = null;
        }
    }
}

