/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.AbstractFFMpegProcess;
import com.day.cq.dam.video.StoryBoard;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMpegStoryBoardProcess
extends AbstractFFMpegProcess {
    private static final Logger log = LoggerFactory.getLogger(FFMpegStoryBoardProcess.class);

    protected void processVideo(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        String[] args = this.buildArguments(metaData);
        FFMpegWrapper wrapper = new FFMpegWrapper(tmpFile, this.getWorkingDir());
        wrapper.setExecutableLocator(this.locator);
        StoryBoard board = new StoryBoard(wrapper, asset);
        for (String arg : args) {
            String frameConfig;
            String value = this.getValue(arg);
            if (arg.startsWith("frames:")) {
                board.setFrames(NumberUtils.toInt((String)value, (int)10));
                continue;
            }
            if (arg.startsWith("start:")) {
                board.setStart(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (arg.startsWith("maxWidth:")) {
                board.setMaxWidth(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (arg.startsWith("maxHeight:")) {
                board.setMaxHeight(NumberUtils.toInt((String)value, (int)0));
                continue;
            }
            if (arg.startsWith("upScale:")) {
                if (null == value) continue;
                board.setUpscale(BooleanUtils.toBoolean((String)value));
                continue;
            }
            if (!arg.startsWith("[") || !arg.endsWith("]") || !StringUtils.isNotBlank((String)(frameConfig = StringUtils.replaceEach((String)arg, (String[])new String[]{"[", "]"}, (String[])new String[]{"", ""})))) continue;
            board.addFrame(frameConfig);
        }
        board.create();
        log.info("created storyboard for video [{}]", (Object)asset.getPath());
    }

    private String getValue(String arg) {
        String[] strings = StringUtils.split((String)arg, (String)":");
        return strings.length == 2 ? strings[1] : null;
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String[] frames;
        Boolean upScale;
        Integer maxHeight;
        Integer maxWidth;
        Integer start;
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        Integer frameCount = (Integer)metaData.get(Arguments.FRAME_COUNT.name(), Integer.class);
        if (frameCount != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.FRAME_COUNT.getArgumentPrefix()).append(frameCount);
            arguments.add(builder.toString());
        }
        if ((start = (Integer)metaData.get(Arguments.START.name(), Integer.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.START.getArgumentPrefix()).append(start);
            arguments.add(builder.toString());
        }
        if ((maxWidth = (Integer)metaData.get(Arguments.MAX_WIDTH.name(), Integer.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.MAX_WIDTH.getArgumentPrefix()).append(maxWidth);
            arguments.add(builder.toString());
        }
        if ((maxHeight = (Integer)metaData.get(Arguments.MAX_HEIGHT.name(), Integer.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.MAX_HEIGHT.getArgumentPrefix()).append(maxHeight);
            arguments.add(builder.toString());
        }
        if ((upScale = (Boolean)metaData.get(Arguments.UPSCALE.name(), Boolean.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.UPSCALE.getArgumentPrefix()).append(upScale);
            arguments.add(builder.toString());
        }
        if ((frames = (String[])metaData.get(Arguments.FRAMES.name(), String[].class)) != null) {
            for (String frame : frames) {
                if (!frame.startsWith("[")) {
                    frame = "[" + frame;
                }
                if (!frame.endsWith("]")) {
                    frame = frame + "]";
                }
                arguments.add(frame);
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        FRAME_COUNT("frames"),
        START("start"),
        MAX_WIDTH("maxWidth"),
        MAX_HEIGHT("maxHeight"),
        UPSCALE("upScale"),
        FRAMES("");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

