/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.commons.thumbnail.ThumbnailGenerator;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.AbstractFFMpegProcess;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class FFMpegThumbnailProcess
extends AbstractFFMpegProcess {
    protected void processVideo(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        Object[] args = this.buildArguments(metaData);
        int start = 0;
        int count = 1;
        int index = 0;
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("start:") || arg.startsWith("count:") || arg.startsWith("index:")) {
                String[] split = StringUtils.split((String)arg, (String)":");
                if (split.length == 2) {
                    if (arg.startsWith("start:")) {
                        start = NumberUtils.toInt((String)split[1], (int)start);
                    } else if (arg.startsWith("count:")) {
                        if ((count = NumberUtils.toInt((String)split[1], (int)count)) <= 0) {
                            count = 1;
                        }
                    } else if (arg.startsWith("index:")) {
                        index = NumberUtils.toInt((String)split[1], (int)index);
                    }
                }
                args = (String[])ArrayUtils.remove((Object[])args, (int)i);
                continue;
            }
            ++i;
        }
        FFMpegWrapper wrapper = new FFMpegWrapper(tmpFile, this.getWorkingDir());
        wrapper.setExecutableLocator(this.locator);
        BufferedImage[] thumbnails = wrapper.getThumbnails(count, start);
        if (thumbnails != null && thumbnails.length > 0) {
            BufferedImage thumbnail;
            if (index >= thumbnails.length) {
                index = thumbnails.length - 1;
            }
            if ((thumbnail = thumbnails[index]) != null) {
                BufferedImage rgbaThumbnail = new BufferedImage(thumbnail.getWidth(), thumbnail.getHeight(), 2);
                rgbaThumbnail.getGraphics().drawImage(thumbnail, 0, 0, null);
                ThumbnailGenerator generator = new ThumbnailGenerator(asset, rgbaThumbnail);
                generator.generate(ThumbnailGenerator.parseConfig((String[])args));
            }
        } else {
            this.log.warn("Could not create thumbnails for video asset {}, maybe ffmpeg is not installed.", (Object)asset.getPath());
        }
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String[] configs;
        String index;
        String count;
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        ArrayList<String> arguments = new ArrayList<String>();
        String start = (String)metaData.get(Arguments.START.name(), String.class);
        if (start != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.START.getArgumentPrefix()).append(start);
            arguments.add(builder.toString());
        }
        if ((count = (String)metaData.get(Arguments.COUNT.name(), String.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.COUNT.getArgumentPrefix()).append(count);
            arguments.add(builder.toString());
        }
        if ((index = (String)metaData.get(Arguments.INDEX.name(), String.class)) != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(Arguments.INDEX.getArgumentPrefix()).append(index);
            arguments.add(builder.toString());
        }
        if ((configs = (String[])metaData.get(Arguments.CONFIGS.name(), String[].class)) != null) {
            for (String config : configs) {
                arguments.add(config);
            }
        }
        return arguments.toArray(new String[arguments.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS("PROCESS_ARGS"),
        START("start"),
        COUNT("count"),
        INDEX("index"),
        CONFIGS("CONFIGS");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

