/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.cq.dam.video.AbstractFFMpegProcess;
import com.day.cq.dam.video.VideoProfile;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.metadata.MetaDataMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.ResourceResolver;

public class FFMpegTranscodeProcess
extends AbstractFFMpegProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processVideo(MetaDataMap metaData, Asset asset, File tmpFile, WorkflowSession wfSession) throws IOException, RepositoryException {
        String[] videoProfiles;
        long start = System.currentTimeMillis();
        this.log.info("processing asset [{}]...", (Object)asset.getPath());
        ResourceResolver resolver = this.getResourceResolver(wfSession.getSession());
        for (String videoProfile : videoProfiles = this.getVideoProfiles(metaData)) {
            VideoProfile profile = VideoProfile.get(resolver, videoProfile);
            if (profile == null) continue;
            this.log.info("processVideo: creating video using profile [{}]", (Object)videoProfile);
            FFMpegWrapper ffmpegWrapper = FFMpegWrapper.fromProfile(tmpFile, profile, this.getWorkingDir());
            ffmpegWrapper.setExecutableLocator(this.locator);
            FileInputStream fis = null;
            try {
                String renditionName = this.getRenditionName(ffmpegWrapper);
                File video = ffmpegWrapper.transcode();
                fis = new FileInputStream(video);
                asset.addRendition(renditionName, (InputStream)fis, ffmpegWrapper.getOutputMimetype());
                video.delete();
            }
            catch (IOException e) {
                try {
                    this.log.error(e.getMessage(), (Throwable)e);
                    this.log.error("processVideo: failed creating video from profile [{}]: {}", (Object)videoProfile, (Object)e.getMessage());
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fis);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fis);
                continue;
            }
            IOUtils.closeQuietly((InputStream)fis);
        }
        this.log.info("finished processing asset [{}] in [{}ms].", (Object)asset.getPath(), (Object)(System.currentTimeMillis() - start));
    }

    private String getRenditionName(FFMpegWrapper ffmpegWrapper) {
        String outputFormat = ffmpegWrapper.getOutputExtension();
        String profileName = ffmpegWrapper.getProfileName();
        StringBuilder builder = new StringBuilder();
        builder.append("cq5dam.video.").append(profileName);
        if (ffmpegWrapper.getOutputSize() != null) {
            builder.append(".").append(ffmpegWrapper.getOutputSize().width).append(".").append(ffmpegWrapper.getOutputSize().height);
        }
        builder.append(".").append(outputFormat);
        return builder.toString();
    }

    public String[] getThumbnailConfigs(MetaDataMap metaData) {
        if (this.isLegacy(metaData)) {
            List configs = this.getValuesFromArgs(Arguments.CONFIGS.getArgumentName(), this.getLegacyArguments(metaData));
            return configs.toArray(new String[configs.size()]);
        }
        String[] configs = (String[])metaData.get(Arguments.CONFIGS.name(), String[].class);
        return configs != null ? configs : new String[]{};
    }

    public String[] getVideoProfiles(MetaDataMap metaData) {
        if (this.isLegacy(metaData)) {
            List profiles = this.getValuesFromArgs(Arguments.VIDEO_PROFILES.getArgumentName(), this.getLegacyArguments(metaData));
            return profiles.toArray(new String[profiles.size()]);
        }
        String[] profiles = (String[])metaData.get(Arguments.VIDEO_PROFILES.name(), String[].class);
        return profiles != null ? profiles : new String[]{};
    }

    private boolean isLegacy(MetaDataMap metaDataMap) {
        return metaDataMap.get(Arguments.PROCESS_ARGS.name(), String.class) != null;
    }

    private String[] getLegacyArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        return new String[0];
    }

    public String[] buildArguments(MetaDataMap metaData) {
        String processArgs = (String)metaData.get(Arguments.PROCESS_ARGS.name(), String.class);
        if (processArgs != null && !processArgs.equals("")) {
            return processArgs.split(",");
        }
        String[] configs = (String[])metaData.get(Arguments.CONFIGS.name(), String[].class);
        if (configs != null) {
            return configs;
        }
        return new String[0];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Arguments {
        PROCESS_ARGS(""),
        CONFIGS("tn"),
        VIDEO_PROFILES("profile");

        private String argumentName;

        private Arguments(String argumentName) {
            this.argumentName = argumentName;
        }

        public String getArgumentName() {
            return this.argumentName;
        }

        public String getArgumentPrefix() {
            return this.argumentName + ":";
        }
    }
}

