/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.handler.ffmpeg.FFMpegWrapper;
import com.day.image.Layer;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoryBoard {
    private static final Logger log = LoggerFactory.getLogger(StoryBoard.class);
    private final List<String> framesList = new LinkedList<String>();
    private final FFMpegWrapper wrapper;
    private final Asset asset;
    private int frames = 10;
    private int start = 0;
    private int maxWidth = 320;
    private int maxHeight = 240;
    private boolean upscale = true;

    public StoryBoard(FFMpegWrapper wrapper, Asset asset) {
        this.wrapper = wrapper;
        this.asset = asset;
        if (null == wrapper) {
            throw new IllegalArgumentException("wrapper may not be null");
        }
        if (null == asset) {
            throw new IllegalArgumentException("asset may not be null");
        }
    }

    public void setFrames(int frames) {
        this.frames = frames;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public void setUpscale(boolean upscale) {
        this.upscale = upscale;
    }

    public synchronized void addFrame(String config) {
        this.framesList.add(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create() throws IOException {
        BufferedImage[] frames = this.wrapper.getThumbnails(this.frames, this.start);
        log.debug("got [{}] thumbs to be processed as key frames for [{}]...", (Object)frames.length, (Object)this.asset.getPath());
        int i = 0;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("keyframe." + System.currentTimeMillis(), ".tmp");
            BufferedImage[] arr$ = frames;
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                BufferedImage frame = arr$[i$];
                if (null == frame) {
                    log.warn("encountered null frame at index [{}] for asset [{}]", (Object)i, (Object)this.asset.getPath());
                } else {
                    log.debug("processing frame [{}] for [{}]...", (Object)i, (Object)this.asset.getPath());
                    Layer l = new Layer(frame);
                    FileOutputStream out = null;
                    FileInputStream in = null;
                    try {
                        out = new FileOutputStream(tmpFile);
                        l.write("image/png", 0.8, (OutputStream)out);
                        in = new FileInputStream(tmpFile);
                        Asset sub = this.asset.addSubAsset(this.asset.getName() + ".keyframe." + (i + 1) + ".png", "image/png", (InputStream)in);
                        log.info("created key frame sub-asset [{}] for [{}],", (Object)sub.getPath(), (Object)this.asset.getPath());
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly((OutputStream)out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)in);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                ++i;
                ++i$;
            }
            return;
        }
        catch (Exception e) {
            log.error("failed creating storyboard for [{}]: ", (Object)this.asset.getPath(), (Object)e);
            return;
        }
        finally {
            if (null != tmpFile) {
                tmpFile.delete();
            }
        }
    }
}

