/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video;

import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.Rendition;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import java.awt.Dimension;
import javax.jcr.Node;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class VideoProfile {
    public static final String PROFILE_BASE_PATH = "/etc/dam/video";
    private Resource resource;

    public static VideoProfile get(ResourceResolver resolver, String name) {
        String path = name.startsWith("/") ? name : "/etc/dam/video/" + name;
        Resource resource = resolver.getResource(path);
        if (resource != null) {
            return new VideoProfile(resource);
        }
        return null;
    }

    public VideoProfile(Resource resource) {
        this.resource = "jcr:content".equals(resource.getName()) ? resource.getParent() : resource;
    }

    public String getName() {
        return this.resource.getName();
    }

    public String getPath() {
        return this.resource.getPath();
    }

    public Resource getResource() {
        return this.resource;
    }

    public Resource getContentResource() {
        return this.resource.getResourceResolver().getResource(this.resource, "jcr:content");
    }

    public ValueMap getProperties() {
        return ResourceUtil.getValueMap((Resource)this.getContentResource());
    }

    public Node getContentNode() {
        Resource content = this.getContentResource();
        return content == null ? null : (Node)content.adaptTo(Node.class);
    }

    public String getHtmlType() {
        return (String)this.getProperties().get("htmlType", (Object)"");
    }

    public Rendition getRendition(Asset asset) {
        String prefix = "cq5dam.video." + this.getName();
        return asset.getRendition((RenditionPicker)new PrefixRenditionPicker(prefix));
    }

    public Dimension getOutputSize() {
        ValueMap props = this.getProperties();
        Integer width = (Integer)props.get("width", Integer.class);
        Integer height = (Integer)props.get("height", Integer.class);
        if (width != null && height != null) {
            return new Dimension(width, height);
        }
        return null;
    }
}

