/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.dam.video.servlet;

import java.io.IOException;
import java.io.Writer;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoProfileListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = -780464494271946961L;
    private final Logger log = LoggerFactory.getLogger(VideoProfileListServlet.class);

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("utf-8");
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            writer.array();
            Node videoProfilesRoot = (Node)request.getResourceResolver().getResource("/etc/dam/video").adaptTo(Node.class);
            this.loopVideoProfiles(writer, videoProfilesRoot);
            writer.endArray();
        }
        catch (RepositoryException e) {
            throw new ServletException("Could not lookup video profiles.", (Throwable)e);
        }
        catch (JSONException e) {
            throw new ServletException("Error", (Throwable)e);
        }
    }

    private void loopVideoProfiles(JSONWriter writer, Node videoProfilesRoot) throws RepositoryException, JSONException {
        NodeIterator profiles = videoProfilesRoot.getNodes();
        while (profiles.hasNext()) {
            Node profile = profiles.nextNode();
            if (profile.isNodeType("nt:folder")) {
                this.loopVideoProfiles(writer, profile);
                continue;
            }
            this.writeVideoProfile(writer, profile);
        }
    }

    private void writeVideoProfile(JSONWriter writer, Node profile) throws RepositoryException, JSONException {
        writer.object();
        writer.key("text").value((Object)this.getProfileTitle(profile));
        writer.key("description").value(this.getProfileDescription(profile));
        writer.key("value").value((Object)this.getProfileName(profile));
        writer.endObject();
    }

    private String getProfileTitle(Node profile) throws RepositoryException {
        String title = profile.getPath();
        try {
            Node jcrContent = profile.getNode("jcr:content");
            title = jcrContent.getProperty("jcr:title").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resovling jcr:title property from profile's jcr:content node. Fallback to profile path");
        }
        return title;
    }

    private Object getProfileDescription(Node profile) throws RepositoryException {
        String description = "";
        try {
            Node jcrContent = profile.getNode("jcr:content");
            description = jcrContent.getProperty("jcr:description").getString();
        }
        catch (PathNotFoundException e) {
            this.log.error("trouble resovling jcr:description property from profile's jcr:content node. Fallback to empty string");
        }
        return description;
    }

    private String getProfileName(Node profileNode) throws RepositoryException {
        String path = profileNode.getPath();
        if (path.startsWith("/etc/dam/video/")) {
            return path.substring("/etc/dam/video".length() + 1);
        }
        return profileNode.getPath();
    }
}

