/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.emailprovider.impl;

import com.day.cq.mcm.emailprovider.EmailService;
import com.day.cq.mcm.emailprovider.service.EmailServiceProvider;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;

@Component
@Service
@Properties(value={@Property(name="service.description", value={"Email Provider Service Implementation"})})
@Reference(name="EmailService", referenceInterface=EmailService.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class EmailServiceProviderImpl
implements EmailServiceProvider {
    private Map<String, EmailService> emailServiceMapping = new ConcurrentHashMap<String, EmailService>();

    public EmailService getEmailService(Configuration configuration) {
        if (configuration != null) {
            String providerName = (String)configuration.getInherited("providerName", (Object)"");
            return this.emailServiceMapping.get(providerName);
        }
        return null;
    }

    public void bindEmailService(EmailService emailService) {
        if (emailService != null) {
            this.emailServiceMapping.put(emailService.getName(), emailService);
        }
    }

    public void unbindEmailService(EmailService emailService) {
        if (emailService != null) {
            this.emailServiceMapping.remove(emailService.getName());
        }
    }

    public EmailService getEmailService(String providerName) {
        if (providerName != null) {
            return this.emailServiceMapping.get(providerName);
        }
        return null;
    }
}

