/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.emailprovider.servlets;

import com.day.cq.i18n.I18n;
import com.day.cq.mcm.api.newsletter.NewsLetter;
import com.day.cq.mcm.api.newsletter.NewsletterService;
import com.day.cq.mcm.core.NewsletterHelper;
import com.day.cq.mcm.emailprovider.EmailService;
import com.day.cq.mcm.emailprovider.EmailServiceException;
import com.day.cq.mcm.emailprovider.service.EmailServiceProvider;
import com.day.cq.mcm.emailprovider.types.Email;
import com.day.cq.mcm.emailprovider.types.EmailServiceActions;
import com.day.cq.mcm.emailprovider.util.EmailHelper;
import com.day.cq.replication.Replicator;
import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.webservicesupport.Configuration;
import com.day.cq.wcm.webservicesupport.ConfigurationManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@Properties(value={@Property(name="sling.servlet.extensions", value={"json"}, propertyPrivate=true), @Property(name="sling.servlet.selectors", value={"emailservice"}, propertyPrivate=true), @Property(name="sling.servlet.resourceTypes", value={"sling/servlet/default"}), @Property(name="sling.servlet.methods", value={"POST", "GET"}, propertyPrivate=true)})
public class EmailServiceHandlerServlet
extends SlingAllMethodsServlet {
    private static final String PARAM_ERROR = "error";
    private static final String ENCODING_UTF_8 = "utf-8";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final Logger log = LoggerFactory.getLogger(EmailServiceHandlerServlet.class);
    private static final String OPERATION_ADDSUBSCRIBER = "addToList";
    private static final String OPERATION_DELETESUBSCRIBER = "deleteFromList";
    private static final String OPERATION_AUTORESPONDEREMAIL = "sendAutoResponderMail";
    private static final String PARAM_PATH = "cfgpath";
    private static final String PARAM_OPERATION = "operation";
    private static final int STATUS_NO_LETTER = -10;
    private static final int STATUS_CQ_PUBLISH_OUTDATED = 9;
    private static final int STATUS_NO_REPLICATOR = -12;
    private static final int STATUS_REPLICATION_EXCEPTION = -13;
    private static final String KEY_STATUS_MESSAGE = "testStatusText";
    private static final String KEY_STATUS = "testStatus";
    @Reference
    private EmailServiceProvider emailServiceProvider;
    @Reference
    private ConfigurationManager cfgMgr;
    @Reference
    private NewsletterService newsletterService;
    @Reference
    private Replicator repl;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType(CONTENT_TYPE_JSON);
        response.setCharacterEncoding(ENCODING_UTF_8);
        String errorMsg = "";
        try {
            this.handleRequest(request, response);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            errorMsg = e.getCause() instanceof UnknownHostException ? "Could not connect to " + e.getCause().getMessage() : "An exception occured.<br>" + e.getMessage();
            PrintWriter out = response.getWriter();
            this.writeResponse(out, PARAM_ERROR, errorMsg);
        }
    }

    private void handleRequest(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        String operation = request.getParameter(PARAM_OPERATION);
        if (operation == null) {
            operation = this.getActionType(request);
        }
        EmailServiceActions op = null;
        try {
            Object serviceResponse;
            op = this.getEmailServiceAction(operation);
            if (op == null) {
                response.sendError(400, I18n.get((HttpServletRequest)request, (String)"Requested Operation not supported: {0}", null, (Object[])new Object[]{operation}));
            }
            if (op == EmailServiceActions.PUBLISH_EMAIL || op == EmailServiceActions.UPDATE_EMAIL) {
                this.handlePublishEmail(request, response, op);
                return;
            }
            Map<String, Object> requestParams = this.getRequestParams(op, request);
            Configuration config = this.getConfiguration(request, response);
            if (config == null && op != EmailServiceActions.CONNECT && op != EmailServiceActions.GET_ACCOUNTS) {
                response.sendError(400, I18n.get((HttpServletRequest)request, (String)"EmailService configuration not found or missing"));
            }
            EmailService service = null;
            service = config == null ? this.getEmailService(request) : this.emailServiceProvider.getEmailService(config);
            if (service == null) {
                response.sendError(503, I18n.get((HttpServletRequest)request, (String)"Requested EmailService not available"));
            }
            if ((serviceResponse = service.execute(op, requestParams, config)) != null) {
                this.writeJSONResponse(serviceResponse, response.getWriter());
            }
            if (op == EmailServiceActions.ADD_SUBSCRIBER || op == EmailServiceActions.DELETE_SUBSCRIBER || op == EmailServiceActions.SEND_AUTO_RESPONDER) {
                EmailHelper.redirectUrl(false, request, response);
            }
        }
        catch (EmailServiceException e) {
            log.error(e.getMessage());
            if (op == EmailServiceActions.ADD_SUBSCRIBER || op == EmailServiceActions.DELETE_SUBSCRIBER || op == EmailServiceActions.SEND_AUTO_RESPONDER) {
                this.redirectOnFormError(request, response, I18n.get((HttpServletRequest)request, (String)"Could not complete request. Please try again later."));
            }
            response.sendError(400, "");
        }
    }

    private JSONArray getJSONFromList(List<Object> list) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (Object object : list) {
                if (object instanceof List) {
                    jsonArray.put((Object)this.getJSONFromList((List)object));
                    continue;
                }
                if (object instanceof Map) {
                    jsonArray.put((Object)this.getJSONFromMap((Map)object));
                    continue;
                }
                jsonArray.put((Object)object.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return jsonArray;
    }

    private void writeJSONResponse(Object serviceResponse, PrintWriter writer) {
        try {
            if (serviceResponse instanceof List) {
                JSONArray jsonArray = this.getJSONFromList((List)serviceResponse);
                writer.write(jsonArray.toString());
            } else if (serviceResponse instanceof Map) {
                JSONObject jsonObject = this.getJSONFromMap((Map)serviceResponse);
                writer.write(jsonObject.toString());
            } else {
                JSONArray wrapObject = new JSONArray().put((Object)serviceResponse.toString());
                writer.write(wrapObject.toString());
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        writer.flush();
    }

    private JSONObject getJSONFromMap(Map<String, Object> map) {
        JSONObject jsonObject = new JSONObject();
        try {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                if (value instanceof Map) {
                    value = this.getJSONFromMap((Map)value);
                } else if (value instanceof List) {
                    value = this.getJSONFromList((List)value);
                }
                jsonObject.put(key, value);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
        }
        return jsonObject;
    }

    private Map<String, Object> getRequestParams(EmailServiceActions op, SlingHttpServletRequest request) {
        HashMap<String, Object> requestParams = new HashMap<String, Object>();
        Enumeration paramsNames = request.getParameterNames();
        while (paramsNames.hasMoreElements()) {
            String key = (String)paramsNames.nextElement();
            requestParams.put(key, request.getParameter(key));
        }
        if (op == EmailServiceActions.ADD_SUBSCRIBER || op == EmailServiceActions.DELETE_SUBSCRIBER || op == EmailServiceActions.SEND_AUTO_RESPONDER) {
            ValueMap values = ResourceUtil.getValueMap((Resource)request.getResource());
            requestParams.putAll((Map<String, Object>)values);
            Iterator formFieldsIter = FormsHelper.getFormElements((Resource)request.getResource());
            ArrayList<String> fieldNames = new ArrayList<String>();
            while (formFieldsIter.hasNext()) {
                Resource fieldResource = (Resource)formFieldsIter.next();
                ValueMap valueMap = ResourceUtil.getValueMap((Resource)fieldResource);
                String name = (String)valueMap.get("name", String.class);
                if (name == null || request.getParameter(name) == null) continue;
                fieldNames.add(name);
            }
            requestParams.put("formFields", fieldNames);
        }
        return requestParams;
    }

    private EmailServiceActions getEmailServiceAction(String operation) {
        for (EmailServiceActions action : EmailServiceActions.values()) {
            if (!action.toString().equals(operation)) continue;
            return action;
        }
        return null;
    }

    private void redirectOnFormError(SlingHttpServletRequest request, SlingHttpServletResponse response, String error) throws IOException {
        log.error(error);
        Node formStart = (Node)request.getResource().adaptTo(Node.class);
        try {
            formStart.setProperty("MCMFormError", error);
            formStart.getSession().save();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        EmailHelper.redirectUrl(true, request, response);
    }

    private Configuration getConfiguration(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        Configuration config = null;
        String path = request.getParameter(PARAM_PATH);
        if (path == null) {
            ValueMap values = ResourceUtil.getValueMap((Resource)request.getResource());
            path = (String)values.get(PARAM_PATH, String.class);
        }
        if (path != null) {
            config = this.cfgMgr.getConfiguration(path);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(PrintWriter out, String propertyname, String msg) {
        JSONObject returnValue = new JSONObject();
        try {
            returnValue.put(propertyname, (Object)msg);
            out.write(returnValue.toString());
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            out.flush();
        }
    }

    private EmailService getEmailService(SlingHttpServletRequest request) throws EmailServiceException {
        EmailService emailService = null;
        Configuration config = null;
        String path = request.getParameter(PARAM_PATH);
        if (path != null) {
            config = this.cfgMgr.getConfiguration(path);
        }
        String providerName = null;
        if (config != null) {
            emailService = this.emailServiceProvider.getEmailService(config);
        } else {
            providerName = request.getParameter("providerName");
            emailService = this.emailServiceProvider.getEmailService(providerName);
        }
        if (emailService == null) {
            throw new EmailServiceException("Unable to locate any EmailService for this request, Path: " + path + ", Name: " + providerName);
        }
        return emailService;
    }

    private String getActionType(SlingHttpServletRequest request) {
        String addSubscriber = "addSubscriber";
        String autoResponder = "autoResponder";
        String deleteSubscriber = "deleteSubscriber";
        ValueMap values = ResourceUtil.getValueMap((Resource)request.getResource());
        String actionType = (String)values.get("actionType", String.class);
        if (actionType.indexOf("addSubscriber") != -1) {
            return OPERATION_ADDSUBSCRIBER;
        }
        if (actionType.indexOf("deleteSubscriber") != -1) {
            return OPERATION_DELETESUBSCRIBER;
        }
        if (actionType.indexOf("autoResponder") != -1) {
            return OPERATION_AUTORESPONDEREMAIL;
        }
        return "";
    }

    private void handlePublishEmail(SlingHttpServletRequest request, SlingHttpServletResponse response, EmailServiceActions op) throws IOException {
        try {
            Configuration config = this.getConfiguration(request, response);
            EmailService emailService = null;
            PrintWriter out = response.getWriter();
            JSONWriter json = new JSONWriter((Writer)out);
            json.object();
            if (config == null) {
                json.key(KEY_STATUS).value(500L);
                json.key(KEY_STATUS_MESSAGE).value((Object)I18n.get((HttpServletRequest)request, (String)"Email Service configuration not found"));
                json.endObject();
                return;
            }
            emailService = this.emailServiceProvider.getEmailService(config);
            if (this.newsletterService == null || emailService == null) {
                response.sendError(503);
                return;
            }
            String path = request.getParameter("newsletter");
            if (path == null) {
                response.sendError(400);
                return;
            }
            NewsLetter letter = null;
            try {
                letter = NewsletterHelper.fromRequest((SlingHttpServletRequest)request, (NewsletterService)this.newsletterService);
            }
            catch (RepositoryException e1) {
                log.error("Error while accesing repository: ", (Object)e1.getMessage());
                json.key(KEY_STATUS).value(2L);
                json.key(KEY_STATUS_MESSAGE).value((Object)I18n.get((HttpServletRequest)request, (String)"Error while accesing repository."));
            }
            if (letter == null) {
                json.key(KEY_STATUS).value(-10L);
                json.key(KEY_STATUS_MESSAGE).value((Object)I18n.get((HttpServletRequest)request, (String)"Letter could not be built"));
            } else if (!NewsletterHelper.isPublishUptodate((NewsLetter)letter, (ResourceResolver)request.getResourceResolver())) {
                json.key(KEY_STATUS).value(9L);
            } else {
                int code = 0;
                String msg = null;
                try {
                    String name = request.getParameter("name");
                    Email email = EmailHelper.getEmail(name, letter);
                    Resource emailResource = request.getResourceResolver().resolve(path);
                    HashMap<String, Object> requestParams = new HashMap<String, Object>(request.getParameterMap());
                    requestParams.put("subject", email.getSubject());
                    requestParams.put("content", email.getContent());
                    requestParams.put("isHtml", email.isHtml());
                    requestParams.put("name", email.getName());
                    requestParams.put("resource", emailResource);
                    if (ResourceUtil.isNonExistingResource((Resource)emailResource)) {
                        throw new Exception(I18n.get((HttpServletRequest)request, (String)"Email Resource does not exist"));
                    }
                    if (op == EmailServiceActions.PUBLISH_EMAIL) {
                        emailService.execute(EmailServiceActions.PUBLISH_EMAIL, requestParams, config);
                        msg = I18n.get((HttpServletRequest)request, (String)"{0} successfully published to Email Service provider.", null, (Object[])new Object[]{name});
                    } else if (op == EmailServiceActions.UPDATE_EMAIL) {
                        emailService.execute(EmailServiceActions.UPDATE_EMAIL, requestParams, config);
                        msg = I18n.get((HttpServletRequest)request, (String)"{0} successfully updated to Email Service Provider.", null, (Object[])new Object[]{name});
                    }
                }
                catch (EmailServiceException e) {
                    log.error(e.getMessage());
                    code = 500;
                    msg = I18n.get((HttpServletRequest)request, (String)"Could not publish. Make sure Email Settings are appropriate.");
                }
                catch (Exception e) {
                    code = 500;
                    msg = I18n.get((HttpServletRequest)request, (String)"Could not publish. Make sure Email Settings are appropriate.");
                    log.error("Email Service Publish: error on publish:", (Throwable)e);
                }
                json.key(KEY_STATUS).value((long)code);
                json.key(KEY_STATUS_MESSAGE).value((Object)msg);
            }
            json.endObject();
        }
        catch (JSONException e) {
            log.error(e.getMessage());
        }
    }

    protected void bindEmailServiceProvider(EmailServiceProvider emailServiceProvider) {
        this.emailServiceProvider = emailServiceProvider;
    }

    protected void unbindEmailServiceProvider(EmailServiceProvider emailServiceProvider) {
        if (this.emailServiceProvider == emailServiceProvider) {
            this.emailServiceProvider = null;
        }
    }

    protected void bindCfgMgr(ConfigurationManager configurationManager) {
        this.cfgMgr = configurationManager;
    }

    protected void unbindCfgMgr(ConfigurationManager configurationManager) {
        if (this.cfgMgr == configurationManager) {
            this.cfgMgr = null;
        }
    }

    protected void bindNewsletterService(NewsletterService newsletterService) {
        this.newsletterService = newsletterService;
    }

    protected void unbindNewsletterService(NewsletterService newsletterService) {
        if (this.newsletterService == newsletterService) {
            this.newsletterService = null;
        }
    }

    protected void bindRepl(Replicator replicator) {
        this.repl = replicator;
    }

    protected void unbindRepl(Replicator replicator) {
        if (this.repl == replicator) {
            this.repl = null;
        }
    }
}

