/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.exacttarget.impl;

import com.day.cq.mcm.emailprovider.types.ConnectionParams;
import com.day.cq.mcm.exacttarget.ExactTargetClient;
import com.day.cq.mcm.exacttarget.ExactTargetException;
import com.day.cq.mcm.exacttarget.auth.PasswordTokenHandler;
import com.day.cq.mcm.exacttarget.client.APIObject;
import com.day.cq.mcm.exacttarget.client.APIProperty;
import com.day.cq.mcm.exacttarget.client.Account;
import com.day.cq.mcm.exacttarget.client.ArrayOfObjectDefinitionRequest;
import com.day.cq.mcm.exacttarget.client.ClientID;
import com.day.cq.mcm.exacttarget.client.CreateOptions;
import com.day.cq.mcm.exacttarget.client.CreateRequest;
import com.day.cq.mcm.exacttarget.client.CreateResponse;
import com.day.cq.mcm.exacttarget.client.CreateResult;
import com.day.cq.mcm.exacttarget.client.DataExtension;
import com.day.cq.mcm.exacttarget.client.DataExtensionField;
import com.day.cq.mcm.exacttarget.client.DataSourceTypeEnum;
import com.day.cq.mcm.exacttarget.client.DefinitionRequestMsg;
import com.day.cq.mcm.exacttarget.client.DefinitionResponseMsg;
import com.day.cq.mcm.exacttarget.client.DeleteOptions;
import com.day.cq.mcm.exacttarget.client.DeleteRequest;
import com.day.cq.mcm.exacttarget.client.DeleteResponse;
import com.day.cq.mcm.exacttarget.client.DeleteResult;
import com.day.cq.mcm.exacttarget.client.Email;
import com.day.cq.mcm.exacttarget.client.EmailSendDefinition;
import com.day.cq.mcm.exacttarget.client.ExecuteRequest;
import com.day.cq.mcm.exacttarget.client.ExecuteRequestMsg;
import com.day.cq.mcm.exacttarget.client.ExecuteResponse;
import com.day.cq.mcm.exacttarget.client.ExecuteResponseMsg;
import com.day.cq.mcm.exacttarget.client.FilterPart;
import com.day.cq.mcm.exacttarget.client.ListSubscriber;
import com.day.cq.mcm.exacttarget.client.ObjectDefinition;
import com.day.cq.mcm.exacttarget.client.ObjectDefinitionExtendedProperties;
import com.day.cq.mcm.exacttarget.client.ObjectDefinitionRequest;
import com.day.cq.mcm.exacttarget.client.PartnerAPILocator;
import com.day.cq.mcm.exacttarget.client.PerformOptions;
import com.day.cq.mcm.exacttarget.client.PerformRequestMsg;
import com.day.cq.mcm.exacttarget.client.PerformRequestMsgDefinitions;
import com.day.cq.mcm.exacttarget.client.PerformResponseMsg;
import com.day.cq.mcm.exacttarget.client.PropertyDefinition;
import com.day.cq.mcm.exacttarget.client.RetrieveOptions;
import com.day.cq.mcm.exacttarget.client.RetrieveRequest;
import com.day.cq.mcm.exacttarget.client.RetrieveRequestMsg;
import com.day.cq.mcm.exacttarget.client.RetrieveResponseMsg;
import com.day.cq.mcm.exacttarget.client.SendClassification;
import com.day.cq.mcm.exacttarget.client.SendDefinitionList;
import com.day.cq.mcm.exacttarget.client.SimpleFilterPart;
import com.day.cq.mcm.exacttarget.client.SimpleOperators;
import com.day.cq.mcm.exacttarget.client.Soap_PortType;
import com.day.cq.mcm.exacttarget.client.Subscriber;
import com.day.cq.mcm.exacttarget.client.SubscriberList;
import com.day.cq.mcm.exacttarget.client.UpdateOptions;
import com.day.cq.mcm.exacttarget.client.UpdateRequest;
import com.day.cq.mcm.exacttarget.client.UpdateResponse;
import com.day.cq.mcm.exacttarget.client.UpdateResult;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Stub;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.wsdl.symbolTable.BaseType;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExactTargetClientImpl
implements ExactTargetClient {
    private static final String AXIS_CLIENT_CONFIG_XML = "axis_client_config.xml";
    private static final String ACTION_CREATE = "create";
    private static final String PARAM_LOGIN_URL = "LoginUrl";
    private static final String PARAM_ENTITY_TYPE = "entityType";
    private static final String ENTITY_TYPE_EMAIL = "email";
    private static final String PARAM_ENTITY_ID = "entityID";
    private static final String PARAM_DISPLAY_NAVI = "displayNavi";
    private static final String DATA_EXTENSION = "DataExtension";
    private static final String DATA_EXTENSION_FIELD = "DataExtensionField";
    private final Random randomNoGenerator = new Random();
    private static final Logger log = LoggerFactory.getLogger(ExactTargetClientImpl.class);
    private ConnectionParams connectionParams;

    private ExactTargetClientImpl() {
    }

    public ExactTargetClientImpl(ConnectionParams connectionParams) {
        this.connectionParams = connectionParams;
    }

    public Soap_PortType init() throws Exception {
        Soap_PortType stub = null;
        InputStream inConfig = null;
        try {
            log.debug("Initializing ET WebService Client");
            inConfig = BaseType.class.getClassLoader().getResourceAsStream(AXIS_CLIENT_CONFIG_XML);
            FileProvider config = new FileProvider(inConfig);
            PartnerAPILocator locator = new PartnerAPILocator((EngineConfiguration)config);
            locator.setSoapEndpointAddress(this.connectionParams.getUrl());
            stub = locator.getSoap();
            Stub axisPort = (Stub)stub;
            axisPort._setProperty("user", (Object)this.connectionParams.getId());
            axisPort._setProperty("passwordCallbackRef", (Object)new PasswordTokenHandler(this.connectionParams.getKey()));
            log.debug("Initialized ET WebService Client");
        }
        catch (Exception e) {
            log.error("Error in initializing ET WebService Client ", (Throwable)e);
            throw e;
        }
        finally {
            if (inConfig != null) {
                inConfig.close();
            }
        }
        return stub;
    }

    @Override
    public List<PropertyDefinition> describeSubscriber() throws ExactTargetException {
        ArrayList<PropertyDefinition> list = new ArrayList<PropertyDefinition>();
        try {
            ObjectDefinition[] objectDefinitions;
            Soap_PortType stub = this.init();
            ObjectDefinitionRequest request = new ObjectDefinitionRequest();
            request.setObjectType("Subscriber");
            ClientID clientId = this.createAccount();
            request.setClient(clientId);
            DefinitionRequestMsg requestMsg = new DefinitionRequestMsg();
            ArrayOfObjectDefinitionRequest requestArr = new ArrayOfObjectDefinitionRequest();
            requestArr.setObjectDefinitionRequest(new ObjectDefinitionRequest[]{request});
            requestMsg.setDescribeRequests(requestArr);
            DefinitionResponseMsg responseMsg = stub.describe(requestMsg);
            for (ObjectDefinition definition : objectDefinitions = responseMsg.getObjectDefinition()) {
                ObjectDefinitionExtendedProperties extProps = definition.getExtendedProperties();
                if (extProps == null) continue;
                log.debug("Extended Properties ...");
                for (PropertyDefinition propDef : extProps.getExtendedProperty()) {
                    log.debug("Name " + propDef.getName() + " isViewable " + propDef.getIsViewable());
                    list.add(propDef);
                }
            }
            return list;
        }
        catch (Exception e) {
            log.error("Error in getting subscriber details from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    @Override
    public List<com.day.cq.mcm.exacttarget.client.List> getSubscriberList(FilterPart filter) throws ExactTargetException {
        ArrayList<com.day.cq.mcm.exacttarget.client.List> subscriberLists = new ArrayList<com.day.cq.mcm.exacttarget.client.List>();
        try {
            ClientID clientId;
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest retrieveReq = new RetrieveRequest();
            retrieveReq.setObjectType("List");
            if (filter != null) {
                retrieveReq.setFilter(filter);
            }
            if ((clientId = this.createAccount()) != null) {
                retrieveReq.setClientIDs(new ClientID[]{clientId});
            }
            retrieveReq.setProperties(new String[]{"ListName", "ID", "ListClassification"});
            retrieveMsg.setRetrieveRequest(retrieveReq);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            APIObject[] results = responseMsg.getResults();
            log.debug("Getting lists from ET, Status ==> " + responseMsg.getOverallStatus());
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                for (APIObject apiObj : results) {
                    if (!(apiObj instanceof com.day.cq.mcm.exacttarget.client.List)) continue;
                    com.day.cq.mcm.exacttarget.client.List list = (com.day.cq.mcm.exacttarget.client.List)apiObj;
                    log.debug("List");
                    log.debug("ListID:" + list.getID() + "");
                    log.debug("ListName: " + list.getListName());
                    log.debug("ListClassification: " + list.getListClassification());
                    subscriberLists.add(list);
                }
            }
        }
        catch (Exception e) {
            log.error("Error in getting lists from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
        return subscriberLists;
    }

    @Override
    public void addSubscriberToList(Subscriber sub) throws ExactTargetException {
        try {
            Soap_PortType stub = this.init();
            this.addSubscriberToList(stub, sub);
        }
        catch (Exception e) {
            log.error("Error in adding subscriber to a list in ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    private void addSubscriberToList(Soap_PortType stub, Subscriber subscriber) throws ExactTargetException, RemoteException {
        CreateRequest createRequest = new CreateRequest();
        ClientID clientId = this.createAccount();
        if (clientId != null) {
            subscriber.setClient(clientId);
        }
        createRequest.setOptions(new CreateOptions());
        createRequest.setObjects(new APIObject[]{subscriber});
        CreateResponse crResponse = stub.create(createRequest);
        log.debug("Adding Subscriber in ET (create call), Status ==> " + crResponse.getOverallStatus());
        CreateResult[] crResults = crResponse.getResults();
        boolean alreadyExists = false;
        for (CreateResult result : crResults) {
            log.debug("Status message : " + result.getStatusMessage());
            log.debug("Error code : " + result.getErrorCode());
            Integer errorCode = result.getErrorCode();
            if (errorCode == null || errorCode != 12014) continue;
            alreadyExists = true;
        }
        if (alreadyExists) {
            this.updateSubscriberToList(stub, subscriber);
        }
    }

    private void updateSubscriberToList(Soap_PortType stub, Subscriber subscriber) throws ExactTargetException, RemoteException {
        UpdateResult[] upResults;
        subscriber.setLists(null);
        UpdateRequest updateRequest = new UpdateRequest();
        updateRequest.setOptions(new UpdateOptions());
        updateRequest.setObjects(new APIObject[]{subscriber});
        UpdateResponse upResponse = stub.update(updateRequest);
        log.debug("Adding Subscriber in ET (update call), Status ==>" + upResponse.getOverallStatus());
        for (UpdateResult result : upResults = upResponse.getResults()) {
            log.debug("Status message : " + result.getStatusMessage());
            log.debug("Error code : " + result.getErrorCode());
        }
    }

    @Override
    public Email publishEmail(Email email) throws ExactTargetException {
        try {
            Soap_PortType stub = this.init();
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                email.setClient(clientId);
            }
            CreateRequest request = new CreateRequest();
            request.setObjects(new APIObject[]{email});
            request.setOptions(new CreateOptions());
            CreateResponse response = stub.create(request);
            log.debug("Publish email to ET, Status ==> " + response.getOverallStatus());
            CreateResult[] results = response.getResults();
            log.debug("Status message : " + results[0].getStatusMessage());
            if (results[0].getErrorCode() != null) {
                log.debug("Error code : " + results[0].getErrorCode());
                throw new ExactTargetException("ExactTarget Error code " + results[0].getErrorCode() + "Status " + results[0].getStatusCode() + ":" + results[0].getStatusMessage());
            }
            email.setID(Integer.valueOf(results[0].getNewID()));
        }
        catch (Exception e) {
            log.error("Error in publishing email to ET ", (Throwable)e);
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
        return email;
    }

    @Override
    public void updateEmail(Email email) throws ExactTargetException {
        try {
            Soap_PortType stub = this.init();
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                email.setClient(clientId);
            }
            UpdateRequest request = new UpdateRequest();
            request.setObjects(new APIObject[]{email});
            request.setOptions(new UpdateOptions());
            UpdateResponse response = stub.update(request);
            log.debug("Update email to ET, Status ==> " + response.getOverallStatus());
            UpdateResult[] results = response.getResults();
            log.debug("Status message : " + results[0].getStatusMessage());
            if (results[0].getErrorCode() != null) {
                log.debug("Error code : " + results[0].getErrorCode());
                throw new ExactTargetException("ExactTarget Error code " + results[0].getErrorCode() + "Status " + results[0].getStatusCode() + ":" + results[0].getStatusMessage());
            }
        }
        catch (Exception e) {
            log.error("Error in updating email on ET ", (Throwable)e);
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    private void performSendDefinition(String sendKey, Soap_PortType stub) throws Exception {
        EmailSendDefinition sendDef = new EmailSendDefinition();
        sendDef.setCustomerKey(sendKey);
        ClientID clientId = this.createAccount();
        if (clientId != null) {
            sendDef.setClient(clientId);
        }
        PerformRequestMsg performRequest = new PerformRequestMsg();
        performRequest.setAction("start");
        performRequest.setOptions(new PerformOptions());
        PerformRequestMsgDefinitions defs = new PerformRequestMsgDefinitions();
        defs.setDefinition((APIObject[])new EmailSendDefinition[]{sendDef});
        performRequest.setDefinitions(defs);
        PerformResponseMsg result = stub.perform(performRequest);
        log.debug("Send email from ET, Status ==> " + result.getOverallStatus());
    }

    private void deleteSendDefinition(Soap_PortType stub, String sendKey) throws RemoteException, ExactTargetException {
        DeleteResult[] results;
        EmailSendDefinition sendDef = new EmailSendDefinition();
        sendDef.setCustomerKey(sendKey);
        ClientID clientId = this.createAccount();
        if (clientId != null) {
            sendDef.setClient(clientId);
        }
        DeleteRequest deleteReq = new DeleteRequest();
        deleteReq.setOptions(new DeleteOptions());
        deleteReq.setObjects(new APIObject[]{sendDef});
        DeleteResponse deleteResponse = stub.delete(deleteReq);
        log.debug("Delete send definition from ET, Status ==> " + deleteResponse.getOverallStatus());
        for (DeleteResult result : results = deleteResponse.getResults()) {
            log.debug("Status message : " + result.getStatusMessage());
            log.debug("Error code : " + result.getErrorCode());
            if (result.getErrorCode() == null) continue;
            throw new ExactTargetException(result.getStatusMessage());
        }
    }

    @Override
    public void deleteSubscriberFromList(Subscriber subscriber) throws ExactTargetException {
        try {
            UpdateResult[] updateResults;
            Soap_PortType stub = this.init();
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                subscriber.setClient(clientId);
            }
            UpdateRequest updateRequest = new UpdateRequest();
            updateRequest.setOptions(new UpdateOptions());
            updateRequest.setObjects(new APIObject[]{subscriber});
            UpdateResponse updateResponse = stub.update(updateRequest);
            log.debug("Delete subscriber from list in ET, Status => " + updateResponse.getOverallStatus());
            for (UpdateResult result : updateResults = updateResponse.getResults()) {
                log.debug("Status message : " + result.getStatusMessage());
                log.debug("Error code : " + result.getErrorCode());
            }
        }
        catch (Exception e) {
            log.error("Error in deleting a subscriber from list in ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    @Override
    public List<Email> getEmails(FilterPart filter) throws ExactTargetException {
        ArrayList<Email> emailList = new ArrayList<Email>();
        try {
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest retrieveReq = new RetrieveRequest();
            retrieveReq.setObjectType("Email");
            retrieveReq.setProperties(new String[]{"ID", "Name"});
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                retrieveReq.setClientIDs(new ClientID[]{clientId});
            }
            if (filter != null) {
                retrieveReq.setFilter(filter);
            }
            retrieveMsg.setRetrieveRequest(retrieveReq);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            APIObject[] results = responseMsg.getResults();
            log.debug("Get emails from ET, Status ==> " + responseMsg.getOverallStatus());
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                for (APIObject apiObj : results) {
                    if (!(apiObj instanceof Email)) continue;
                    Email email = (Email)apiObj;
                    log.debug("Emails");
                    log.debug("EmailID: " + email.getID());
                    log.debug("Name: " + email.getName());
                    emailList.add(email);
                }
            }
        }
        catch (Exception e) {
            log.error("Error in getting emails from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
        return emailList;
    }

    @Override
    public List<SendClassification> getSendClassifications(FilterPart filter) throws ExactTargetException {
        ArrayList<SendClassification> sendClassifications = new ArrayList<SendClassification>();
        try {
            ClientID clientId;
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest retrieveReq = new RetrieveRequest();
            retrieveReq.setObjectType("SendClassification");
            retrieveReq.setProperties(new String[]{"Name", "CustomerKey"});
            if (filter != null) {
                retrieveReq.setFilter(filter);
            }
            if ((clientId = this.createAccount()) != null) {
                retrieveReq.setClientIDs(new ClientID[]{clientId});
            }
            retrieveMsg.setRetrieveRequest(retrieveReq);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            APIObject[] results = responseMsg.getResults();
            log.debug("Get SendClassifications from ET, Status ==> " + responseMsg.getOverallStatus());
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                for (APIObject apiObj : results) {
                    if (!(apiObj instanceof SendClassification)) continue;
                    SendClassification list = (SendClassification)apiObj;
                    log.debug("SendClassifications");
                    log.debug("CustomerKey:" + list.getCustomerKey() + "");
                    log.debug("Name: " + list.getName());
                    sendClassifications.add(list);
                }
            }
            return sendClassifications;
        }
        catch (Exception e) {
            log.error("Error in getting classifications from ET ", (Throwable)e);
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendEmail(Email email, Subscriber subscriber) throws ExactTargetException {
        Soap_PortType stub = null;
        com.day.cq.mcm.exacttarget.client.List tempList = null;
        try {
            stub = this.init();
            String tempListName = this.randomNoGenerator.nextInt(100000) + "_" + System.nanoTime();
            com.day.cq.mcm.exacttarget.client.List list = new com.day.cq.mcm.exacttarget.client.List();
            list.setListName(tempListName);
            tempList = this.createList(stub, list);
            SubscriberList subList = new SubscriberList();
            subList.setID(tempList.getID());
            subList.setAction(ACTION_CREATE);
            subscriber.setLists(new SubscriberList[]{subList});
            this.addSubscriberToList(stub, subscriber);
            this.sendEmail(stub, email, subList);
            if (tempList == null) return;
        }
        catch (Exception e) {
            try {
                log.error("Error in sending email through ET ", (Throwable)e);
                if (!(e instanceof ExactTargetException)) throw new ExactTargetException(e.getMessage(), e);
                throw (ExactTargetException)((Object)e);
            }
            catch (Throwable throwable) {
                if (tempList == null) throw throwable;
                try {
                    this.deleteList(stub, tempList);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.info("unable to delete temp list " + tempList.getListName(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.deleteList(stub, tempList);
            return;
        }
        catch (Exception e) {
            log.info("unable to delete temp list " + tempList.getListName(), (Throwable)e);
            return;
        }
    }

    @Override
    public com.day.cq.mcm.exacttarget.client.List createList(com.day.cq.mcm.exacttarget.client.List list) throws ExactTargetException {
        try {
            Soap_PortType stub = this.init();
            return this.createList(stub, list);
        }
        catch (Exception e) {
            log.error("Error in creating a list in ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    private com.day.cq.mcm.exacttarget.client.List createList(Soap_PortType stub, com.day.cq.mcm.exacttarget.client.List list) throws ExactTargetException, RemoteException {
        ClientID clientId = this.createAccount();
        if (clientId != null) {
            list.setClient(clientId);
        }
        CreateRequest createRequest = new CreateRequest();
        createRequest.setOptions(new CreateOptions());
        createRequest.setObjects(new APIObject[]{list});
        CreateResponse crResponse = stub.create(createRequest);
        log.debug("Create a list in ET, Status ==> " + crResponse.getOverallStatus());
        CreateResult[] crResults = crResponse.getResults();
        log.debug("Status message : " + crResults[0].getStatusMessage());
        if (crResults[0].getErrorCode() != null) {
            log.debug("Error code : " + crResults[0].getErrorCode());
            throw new ExactTargetException("ExactTarget Error code " + crResults[0].getErrorCode() + "Status " + crResults[0].getStatusCode() + ":" + crResults[0].getStatusMessage());
        }
        if (crResults[0].getObject() instanceof com.day.cq.mcm.exacttarget.client.List) {
            return (com.day.cq.mcm.exacttarget.client.List)crResults[0].getObject();
        }
        return null;
    }

    @Override
    public void deleteList(String listId) throws ExactTargetException {
        com.day.cq.mcm.exacttarget.client.List list = new com.day.cq.mcm.exacttarget.client.List();
        list.setID(Integer.valueOf(Integer.parseInt(listId)));
        this.deleteList(list);
    }

    private void deleteList(com.day.cq.mcm.exacttarget.client.List list) throws ExactTargetException {
        try {
            Soap_PortType stub = this.init();
            this.deleteList(stub, list);
        }
        catch (Exception e) {
            log.error("Error in deleting a list from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    private void deleteList(Soap_PortType stub, com.day.cq.mcm.exacttarget.client.List list) throws ExactTargetException, RemoteException {
        DeleteResult[] results;
        DeleteRequest deleteReq = new DeleteRequest();
        ClientID clientId = this.createAccount();
        if (clientId != null) {
            list.setClient(clientId);
        }
        deleteReq.setOptions(new DeleteOptions());
        deleteReq.setObjects(new APIObject[]{list});
        DeleteResponse deleteResponse = stub.delete(deleteReq);
        log.debug("Delete a list from ET, Status ==> " + deleteResponse.getOverallStatus());
        for (DeleteResult result : results = deleteResponse.getResults()) {
            log.debug("Status message : " + result.getStatusMessage());
            log.debug("Error code : " + result.getErrorCode());
            if (result.getErrorCode() == null) continue;
            throw new ExactTargetException(result.getStatusMessage());
        }
    }

    @Override
    public void sendEmail(Email email, SubscriberList subscriberList) throws ExactTargetException {
        Soap_PortType stub = null;
        try {
            stub = this.init();
            this.sendEmail(stub, email, subscriberList);
        }
        catch (Exception e) {
            log.error("Error in sending email to a list in ET ", (Throwable)e);
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendEmail(Soap_PortType stub, Email email, SubscriberList subscriberList) throws ExactTargetException {
        String key = null;
        try {
            CreateResult[] results;
            EmailSendDefinition emailSendDefinition = new EmailSendDefinition();
            key = email.getID() + "_" + subscriberList.getID() + "_" + System.nanoTime();
            emailSendDefinition.setName(key);
            emailSendDefinition.setCustomerKey(key);
            emailSendDefinition.setEmail(email);
            com.day.cq.mcm.exacttarget.client.List list = new com.day.cq.mcm.exacttarget.client.List();
            list.setID(subscriberList.getID());
            SendDefinitionList sdfList = new SendDefinitionList();
            sdfList.setList(list);
            sdfList.setDataSourceTypeID(DataSourceTypeEnum.List);
            emailSendDefinition.setSendDefinitionList(new SendDefinitionList[]{sdfList});
            SendClassification sendClassification = new SendClassification();
            sendClassification.setCustomerKey(email.getCustomerKey());
            emailSendDefinition.setSendClassification(sendClassification);
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                emailSendDefinition.setClient(clientId);
            }
            CreateRequest request = new CreateRequest();
            request.setObjects(new APIObject[]{emailSendDefinition});
            request.setOptions(new CreateOptions());
            CreateResponse response = stub.create(request);
            log.debug("Send email to a list, Status ==> " + response.getOverallStatus());
            for (CreateResult result : results = response.getResults()) {
                log.debug("Status message : " + result.getStatusMessage());
                log.debug("Error code : " + result.getErrorCode());
                if (result.getErrorCode() == null) continue;
                throw new ExactTargetException(result.getStatusMessage());
            }
            this.performSendDefinition(key, stub);
            if (stub == null) return;
            if (key == null) return;
        }
        catch (Exception e) {
            try {
                log.error("Error in sending email  to list", (Throwable)e);
                if (!(e instanceof ExactTargetException)) throw new ExactTargetException(e.getMessage(), e);
                throw (ExactTargetException)((Object)e);
            }
            catch (Throwable throwable) {
                if (stub == null) throw throwable;
                if (key == null) throw throwable;
                try {
                    this.deleteSendDefinition(stub, key);
                    throw throwable;
                }
                catch (Exception e2) {
                    log.info("unable to delete temp send definition ", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.deleteSendDefinition(stub, key);
            return;
        }
        catch (Exception e) {
            log.info("unable to delete temp send definition ", (Throwable)e);
            return;
        }
    }

    @Override
    public List<ListSubscriber> getSubscribers(String listId) throws ExactTargetException {
        ArrayList<ListSubscriber> subscriberList = new ArrayList<ListSubscriber>();
        try {
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest retrieveReq = new RetrieveRequest();
            retrieveReq.setObjectType("ListSubscriber");
            retrieveReq.setProperties(new String[]{"SubscriberKey", "Status"});
            ClientID clientId = this.createAccount();
            if (clientId != null) {
                retrieveReq.setClientIDs(new ClientID[]{clientId});
            }
            retrieveMsg.setRetrieveRequest(retrieveReq);
            SimpleFilterPart filterPart = new SimpleFilterPart();
            filterPart.setProperty("ListID");
            filterPart.setSimpleOperator(SimpleOperators.equals);
            filterPart.setValue(new String[]{listId});
            retrieveReq.setFilter((FilterPart)filterPart);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            APIObject[] results = responseMsg.getResults();
            log.debug("Getting subscribers from ET, Status ==> " + responseMsg.getOverallStatus());
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                for (APIObject apiObj : results) {
                    if (!(apiObj instanceof ListSubscriber)) continue;
                    ListSubscriber listSubscriber = (ListSubscriber)apiObj;
                    log.debug("ListSubscriber");
                    log.debug("SubscriberKey: " + listSubscriber.getSubscriberKey());
                    log.debug("Status: " + listSubscriber.getStatus());
                    subscriberList.add(listSubscriber);
                }
            }
        }
        catch (Exception e) {
            log.error("Error in getting lists from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
        return subscriberList;
    }

    @Override
    public List<Account> getAccounts(FilterPart filter) throws ExactTargetException {
        ArrayList<Account> accountList = new ArrayList<Account>();
        try {
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest retrieveReq = new RetrieveRequest();
            retrieveReq.setObjectType("Account");
            retrieveReq.setOptions(new RetrieveOptions());
            retrieveReq.setProperties(new String[]{"Name", "ID"});
            retrieveReq.setQueryAllAccounts(Boolean.valueOf(true));
            if (filter != null) {
                retrieveReq.setFilter(filter);
            }
            retrieveMsg.setRetrieveRequest(retrieveReq);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            APIObject[] results = responseMsg.getResults();
            log.debug("Getting account information from ET, Status ==> " + responseMsg.getOverallStatus());
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                for (APIObject apiObj : results) {
                    if (!(apiObj instanceof Account)) continue;
                    Account etAccount = (Account)apiObj;
                    log.debug("Account");
                    log.debug("ID:" + etAccount.getID() + "");
                    log.debug("Name: " + etAccount.getName());
                    accountList.add(etAccount);
                }
            }
        }
        catch (Exception e) {
            log.error("Error in getting accounts from ET ", (Throwable)e);
            throw new ExactTargetException(e.getMessage(), e);
        }
        return accountList;
    }

    @Override
    public void checkCredentials() throws ExactTargetException {
        this.getDirectLoginToken();
    }

    private ClientID createAccount() {
        if (!StringUtils.isEmpty((String)this.connectionParams.getAccountId())) {
            ClientID clientId = new ClientID();
            clientId.setID(Integer.valueOf(Integer.parseInt(this.connectionParams.getAccountId())));
            return clientId;
        }
        return null;
    }

    private Map<String, String> getDirectLoginToken() throws ExactTargetException {
        ExecuteResponse[] results = null;
        try {
            ExecuteRequestMsg executeMsg = new ExecuteRequestMsg();
            ExecuteRequest executeReq = new ExecuteRequest();
            executeReq.setName("GetUserToken");
            executeMsg.setRequests(new ExecuteRequest[]{executeReq});
            Soap_PortType stub = this.init();
            ExecuteResponseMsg responseMsg = stub.execute(executeMsg);
            results = responseMsg.getResults();
            log.debug("Publish email to ET, Status ==> " + responseMsg.getOverallStatus());
            log.debug("Status message : " + results[0].getStatusMessage());
            log.debug("Error code : " + results[0].getErrorCode());
            if (results[0].getErrorCode() != null) {
                throw new ExactTargetException(results[0].getStatusMessage());
            }
            return this.getResponseProperties(results);
        }
        catch (Exception e) {
            log.error("Error in getting loginurl and usertoken from ExactTarget ", (Throwable)e);
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            return this.getResponseProperties(results);
        }
    }

    private Map<String, String> getResponseProperties(ExecuteResponse[] results) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ExecuteResponse result : results) {
            APIProperty[] properties;
            for (APIProperty prop : properties = result.getResults()) {
                map.put(prop.getName(), prop.getValue());
            }
        }
        return map;
    }

    @Override
    public Map<String, String> viewPublishedNewsletter(String entityId) throws ExactTargetException {
        Map<String, String> tokenParams = this.getDirectLoginToken();
        StringBuffer urlBuffer = new StringBuffer(tokenParams.get(PARAM_LOGIN_URL));
        urlBuffer.append("?&entityType=email&entityID=" + entityId + "&" + PARAM_DISPLAY_NAVI + "=true");
        tokenParams.put(PARAM_LOGIN_URL, urlBuffer.toString());
        return tokenParams;
    }

    @Override
    public List<DataExtensionField> retrieveDataExtensionFields(FilterPart filter, String[] fields) throws ExactTargetException {
        if (filter == null) {
            throw new ExactTargetException("Please specify the DataExtension to be used using filter");
        }
        try {
            APIObject[] results = this.retrieveObjects(DATA_EXTENSION_FIELD, fields, filter);
            ArrayList<DataExtensionField> fieldsArray = new ArrayList<DataExtensionField>();
            for (APIObject apiObj : results) {
                if (!(apiObj instanceof DataExtensionField)) continue;
                fieldsArray.add((DataExtensionField)apiObj);
            }
            return fieldsArray;
        }
        catch (Exception e) {
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    @Override
    public List<DataExtension> retrieveDataExtension(String[] properties, FilterPart filter) throws ExactTargetException {
        try {
            APIObject[] results = this.retrieveObjects(DATA_EXTENSION, properties, filter);
            ArrayList<DataExtension> dataExtL = new ArrayList<DataExtension>();
            for (APIObject apiObj : results) {
                if (!(apiObj instanceof DataExtension)) continue;
                DataExtension dExt = (DataExtension)apiObj;
                dataExtL.add(dExt);
            }
            return dataExtL;
        }
        catch (Exception e) {
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    private APIObject[] retrieveObjects(String objectType, String[] properties, FilterPart filter) throws ExactTargetException {
        try {
            ClientID clientId;
            Soap_PortType stub = this.init();
            RetrieveRequestMsg retrieveMsg = new RetrieveRequestMsg();
            RetrieveRequest rr = new RetrieveRequest();
            rr.setObjectType(objectType);
            rr.setProperties(properties);
            if (filter != null) {
                rr.setFilter(filter);
            }
            if ((clientId = this.createAccount()) != null) {
                rr.setClientIDs(new ClientID[]{clientId});
            }
            retrieveMsg.setRetrieveRequest(rr);
            RetrieveResponseMsg responseMsg = stub.retrieve(retrieveMsg);
            if (responseMsg.getOverallStatus().equals("OK") || responseMsg.getOverallStatus().equals("MoreDataAvailable")) {
                return responseMsg.getResults();
            }
            log.debug(responseMsg.getOverallStatus());
            throw new ExactTargetException(responseMsg.getOverallStatus());
        }
        catch (Exception e) {
            throw new ExactTargetException(e.getMessage(), e);
        }
    }
}

