/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.exacttarget.impl;

import com.adobe.granite.crypto.CryptoException;
import com.adobe.granite.crypto.CryptoSupport;
import com.day.cq.commons.inherit.InheritanceValueMap;
import com.day.cq.mcm.emailprovider.impl.types.ConnectionParamsImpl;
import com.day.cq.mcm.emailprovider.impl.types.ListAttributeImpl;
import com.day.cq.mcm.emailprovider.types.ConnectionParams;
import com.day.cq.mcm.emailprovider.types.EmailServiceActions;
import com.day.cq.mcm.emailprovider.types.ListAttribute;
import com.day.cq.mcm.exacttarget.ExactTargetClient;
import com.day.cq.mcm.exacttarget.ExactTargetException;
import com.day.cq.mcm.exacttarget.ExactTargetService;
import com.day.cq.mcm.exacttarget.client.Account;
import com.day.cq.mcm.exacttarget.client.Attribute;
import com.day.cq.mcm.exacttarget.client.DataExtension;
import com.day.cq.mcm.exacttarget.client.DataExtensionField;
import com.day.cq.mcm.exacttarget.client.Email;
import com.day.cq.mcm.exacttarget.client.FilterPart;
import com.day.cq.mcm.exacttarget.client.ListClassificationEnum;
import com.day.cq.mcm.exacttarget.client.ListSubscriber;
import com.day.cq.mcm.exacttarget.client.PropertyDefinition;
import com.day.cq.mcm.exacttarget.client.SendClassification;
import com.day.cq.mcm.exacttarget.client.SimpleFilterPart;
import com.day.cq.mcm.exacttarget.client.SimpleOperators;
import com.day.cq.mcm.exacttarget.client.Subscriber;
import com.day.cq.mcm.exacttarget.client.SubscriberList;
import com.day.cq.mcm.exacttarget.client.SubscriberStatus;
import com.day.cq.mcm.exacttarget.impl.ExactTargetClientImpl;
import com.day.cq.wcm.webservicesupport.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="%cq.mcm.exacttarget.service.name", description="%cq.mcm.exacttarget.service.description")
@Service
@Properties(value={@Property(name="service.description", value={"ExactTarget Service Implementation"})})
public class ExactTargetServiceImpl
implements ExactTargetService {
    private static final String FULL_NAME_FIELD_NAME = "Full Name";
    private static final String FULL_NAME_PARAM = "fullname";
    private static final String OPTION_TEXT = "text";
    private static final String OPTION_VALUE = "value";
    private static final String EMAIL_ADDRESS_PARAM = "emailaddr";
    private static final String EMAIL_ADDRESS_FIELD_NAME = "Email Address";
    private static final String SERVICE_NAME = "exacttarget";
    private static final String ACTION_CREATE = "create";
    private static final String ACTION_DELETE = "delete";
    private static final String ISO_8859_1 = "iso-8859-1";
    private static final String PARAM_ENTITY_ID = "entityID";
    private static final String TYPE_ID = "id";
    private static final String TYPE_NAME = "name";
    private static final String PERSONALIZATION_PREFIX = "%%";
    private static final String PERSONALIZATION_SUFFIX = "%%";
    private static final String PROFILE_CENTER_PARAM_2 = "<a href=\"%%profile_center_url%%\" alias=\"Update Profile\">Update Profile</a>\n";
    private static final String PROFILE_CENTER_PARAM_1 = "\n<table cellpadding=\"2\" cellspacing=\"0\" width=\"600\" ID=\"Table5\" Border=0><tr><td><font face=\"verdana\" size=\"1\" color=\"#444444\">This email was sent by: <b>%%Member_Busname%%</b><br>%%Member_Addr%% %%Member_City%%, %%Member_State%%, %%Member_PostalCode%%, %%Member_Country%%<br><br></font></td></tr></table>\n";
    private static final String TEST_PROFILE_CENTER_PARAM = "<a href=\"%%profile_center_url%%\"";
    private static final String TEST_PROFILE_PARAM_SENTBY = "This email was sent by: <b>%%Member_Busname%%</b>";
    private static final String END_BODY_TAG = "</body>";
    private static final String UTF_8 = "utf-8";
    private static final String PARAM_DESCRIPTION = "description";
    private static final String PARAM_CLASSIFICATION = "classification";
    private static final Logger log = LoggerFactory.getLogger(ExactTargetServiceImpl.class);
    @Reference
    private CryptoSupport cryptoSupport;

    public String getName() {
        return SERVICE_NAME;
    }

    private ExactTargetClient getExactTargetClient(Configuration configuration) throws ExactTargetException {
        return this.getExactTargetClient(this.getConnectionParameters(configuration));
    }

    private ExactTargetClient getExactTargetClient(ConnectionParams connectionParams) {
        return new ExactTargetClientImpl(connectionParams);
    }

    private List<Map<String, Object>> handleGetAccounts(Map<String, Object> params) throws ExactTargetException {
        List<Account> accounts = this.getAccounts(this.getConnectionParams(params), null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Account account : accounts) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TYPE_ID, account.getID());
            map.put(TYPE_NAME, account.getName());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<Account> getAccounts(ConnectionParams connectionParams, FilterPart filterPart) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(connectionParams);
        return client.getAccounts(filterPart);
    }

    @Override
    public void checkCredentials(ConnectionParams connectionParams) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(connectionParams);
        client.checkCredentials();
    }

    public Object execute(EmailServiceActions op, Map<String, Object> params, Configuration config) throws ExactTargetException {
        switch (op) {
            case CONNECT: {
                this.checkCredentials(this.getConnectionParams(params));
                return null;
            }
            case GET_ACCOUNTS: {
                return this.handleGetAccounts(params);
            }
        }
        if (config == null) {
            throw new ExactTargetException("No ET Configuration specified while invoking " + op.name());
        }
        switch (op) {
            case ADD_SUBSCRIBER: {
                this.handleAddSubscriber(params, config);
                return null;
            }
            case DELETE_SUBSCRIBER: {
                this.handleDeleteSubscriber(params, config);
                return null;
            }
            case PUBLISH_EMAIL: {
                this.handlePublishEmail(params, config);
                return null;
            }
            case UPDATE_EMAIL: {
                this.handleUpdateEmail(params, config);
                return null;
            }
            case SEND_AUTO_RESPONDER: {
                this.handleAutoResponder(params, config);
                return null;
            }
            case SEND_EMAIL_TO_SUBSCRIBER: {
                this.handleSendMailToSubscriber(params, config);
                return null;
            }
            case SEND_EMAIL_TO_SUBSCRIBER_LIST: {
                this.handleSendMailToSubscriberList(params, config);
                return null;
            }
            case GET_LISTS: {
                return this.handleGetLists(params, config);
            }
            case GET_PERSONALIZATION_INFO: {
                return this.handleGetPersonalizationInfo(params, config);
            }
            case GET_EMAILS: {
                return this.handleGetEmails(params, config);
            }
            case GET_EMAIL_CLASSIFICATIONS: {
                return this.handleGetEmailClassifications(params, config);
            }
            case CREATE_SUBSCRIPTION_LIST: {
                return this.handleCreateSubscriptionList(params, config);
            }
            case DELETE_SUBSCRIPTION_LIST: {
                this.handleDeleteSubscriptionList(params, config);
                return null;
            }
            case GET_SUBSCRIBERS: {
                return this.handleGetSubscribers(params, config);
            }
            case GET_FORM_FIELDS: {
                return this.handleGetFormFields(params, config);
            }
        }
        throw new ExactTargetException("Unsupported Operation: " + op.name());
    }

    private Object handleGetFormFields(Map<String, Object> params, Configuration config) throws ExactTargetException {
        List<PropertyDefinition> profileAttributes = this.describeSubscriber(config);
        ArrayList<ListAttributeImpl> attributes = new ArrayList<ListAttributeImpl>();
        String actionType = (String)params.get("actionType");
        EmailServiceActions formAction = null;
        if (actionType.indexOf("addSubscriber") != -1) {
            formAction = EmailServiceActions.ADD_SUBSCRIBER;
        } else if (actionType.indexOf("deleteSubscriber") != -1) {
            formAction = EmailServiceActions.DELETE_SUBSCRIBER;
        } else if (actionType.indexOf("autoResponder") != -1) {
            formAction = EmailServiceActions.SEND_AUTO_RESPONDER;
        } else {
            throw new ExactTargetException("Form fields not associated with given form action: " + actionType);
        }
        ListAttributeImpl attribute = new ListAttributeImpl("email", "email", true);
        attributes.add(attribute);
        for (PropertyDefinition profileAttribute : profileAttributes) {
            attributes.add(new ListAttributeImpl(profileAttribute.getName(), profileAttribute.getDataType(), profileAttribute.getIsRequired().booleanValue()));
        }
        ArrayList<Map> mapList = new ArrayList<Map>();
        for (ListAttribute listAttribute : attributes) {
            if (formAction == EmailServiceActions.DELETE_SUBSCRIBER && !listAttribute.isRequired()) continue;
            mapList.add(listAttribute.getPropertiesMap());
        }
        return mapList;
    }

    private ConnectionParams getConnectionParams(Map<String, Object> params) throws ExactTargetException {
        String username = (String)params.get("username");
        String password = (String)params.get("password");
        String endpoint = (String)params.get("endpoint");
        String accountId = (String)params.get("accountId");
        if (username == null || password == null || endpoint == null) {
            throw new ExactTargetException("Error retrieving connection parameters");
        }
        ConnectionParamsImpl connectionParams = new ConnectionParamsImpl();
        connectionParams.setId(username);
        connectionParams.setKey(password);
        connectionParams.setUrl(endpoint);
        if (accountId != null) {
            connectionParams.setAccountId(accountId);
        }
        return connectionParams;
    }

    private SubscriberList[] initializeSubscriberLists(Object lists, String action) {
        Object[] listIds = null;
        if (lists == null) {
            return null;
        }
        if (!(lists instanceof Object[])) {
            listIds = new Object[]{lists};
        } else if (lists instanceof Object[]) {
            listIds = (Object[])lists;
        }
        SubscriberList[] subscriberLists = new SubscriberList[listIds.length];
        for (int i = 0; i < listIds.length; ++i) {
            subscriberLists[i] = new SubscriberList();
            subscriberLists[i].setID(Integer.valueOf(Integer.parseInt(listIds[i].toString())));
            subscriberLists[i].setAction(action);
        }
        return subscriberLists;
    }

    private void handleAddSubscriber(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String emailAddress = (String)params.get("email");
        Object listIds = params.get("subscriptionlist");
        if (emailAddress == null || "".equals(emailAddress) || listIds == null) {
            throw new ExactTargetException("Subscriber Email or Subscription list can't be empty");
        }
        Subscriber subscriber = null;
        List formFields = (List)params.get("formFields");
        if (formFields != null) {
            subscriber = this.getSubscriber(params, formFields);
        } else {
            subscriber = new Subscriber();
            subscriber.setEmailAddress(emailAddress);
            subscriber.setStatus(SubscriberStatus.Active);
        }
        SubscriberList[] subscriberLists = this.initializeSubscriberLists(listIds, ACTION_CREATE);
        if (subscriberLists == null) {
            throw new ExactTargetException("Subscription list can't be empty");
        }
        subscriber.setLists(subscriberLists);
        this.addSubscriberToList(configuration, subscriber);
    }

    private Subscriber getSubscriber(Map<String, Object> params, List<String> formFields) {
        Subscriber subscriber = new Subscriber();
        Attribute[] attributes = new Attribute[formFields.size()];
        subscriber.setAttributes(attributes);
        for (int i = 0; i < formFields.size(); ++i) {
            String fieldName = formFields.get(i);
            String fieldValue = (String)params.get(fieldName);
            Attribute attr = new Attribute();
            attr.setName(fieldName);
            attr.setValue(fieldValue);
            subscriber.setAttributes(i, attr);
        }
        String emailAddress = (String)params.get("email");
        subscriber.setEmailAddress(emailAddress);
        return subscriber;
    }

    @Override
    public void addSubscriberToList(Configuration configuration, Subscriber subscriber) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.addSubscriberToList(subscriber);
    }

    private void handleDeleteSubscriber(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String emailAddress = (String)params.get("email");
        Object listIds = params.get("subscriptionlist");
        if (emailAddress == null || "".equals(emailAddress) || listIds == null) {
            throw new ExactTargetException("Subscriber Email or Subscription list can't be empty");
        }
        Subscriber subscriber = null;
        List formFields = (List)params.get("formFields");
        if (formFields != null) {
            subscriber = this.getSubscriber(params, formFields);
        } else {
            subscriber = new Subscriber();
            subscriber.setEmailAddress(emailAddress);
            subscriber.setStatus(SubscriberStatus.Active);
        }
        subscriber.setEmailAddress(emailAddress);
        subscriber.setStatus(SubscriberStatus.Active);
        SubscriberList[] subscriberLists = this.initializeSubscriberLists(listIds, ACTION_DELETE);
        if (subscriberLists == null) {
            throw new ExactTargetException("Subscription list can't be empty");
        }
        subscriber.setLists(subscriberLists);
        this.deleteSubscriberFromList(configuration, subscriber);
    }

    @Override
    public void deleteSubscriberFromList(Configuration configuration, Subscriber subscriber) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.deleteSubscriberFromList(subscriber);
    }

    private String updateEmailTools(String content) {
        content = content.replaceAll("<a shape=\"rect\" rref=", "<a href=");
        return content.replaceAll(" rref=", " href=");
    }

    private String addETParameters(String html) {
        StringBuffer strBuf = new StringBuffer();
        int startIndex = html.lastIndexOf(END_BODY_TAG);
        strBuf.append(html.substring(0, startIndex));
        if (!html.contains(TEST_PROFILE_PARAM_SENTBY)) {
            strBuf.append(PROFILE_CENTER_PARAM_1);
        }
        if (!html.contains(TEST_PROFILE_CENTER_PARAM)) {
            strBuf.append(PROFILE_CENTER_PARAM_2);
        }
        strBuf.append(html.substring(startIndex));
        return strBuf.toString();
    }

    private Email getEmail(Map<String, Object> params) {
        Email email = new Email();
        email.setSubject((String)params.get("subject"));
        email.setIsActive(Boolean.valueOf(true));
        String content = (String)params.get("content");
        if (((Boolean)params.get("isHtml")).booleanValue()) {
            email.setHTMLBody(this.addETParameters(this.updateEmailTools(content)));
        } else {
            email.setTextBody(content);
        }
        email.setName((String)params.get(TYPE_NAME));
        try {
            Resource emailResource = (Resource)params.get("resource");
            ValueMap values = ResourceUtil.getValueMap((Resource)emailResource);
            String characterSet = (String)values.get("characterSet", String.class);
            if (characterSet != null) {
                email.setCharacterSet(characterSet);
            } else {
                email.setCharacterSet(UTF_8);
            }
        }
        catch (Exception e) {
            log.error("Error while retrieving character set for email. Setting to default utf-8 encoding");
            email.setCharacterSet(UTF_8);
        }
        return email;
    }

    private void handlePublishEmail(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        try {
            Email publishedEmail = this.publishEmail(configuration, this.getEmail(params));
            Resource resource = (Resource)params.get("resource");
            Node emailNode = (Node)resource.adaptTo(Node.class);
            emailNode.setProperty(PARAM_ENTITY_ID, Integer.toString(publishedEmail.getID()));
            emailNode.getSession().save();
        }
        catch (Exception e) {
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    @Override
    public Email publishEmail(Configuration configuration, Email email) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.publishEmail(email);
    }

    private void handleUpdateEmail(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        try {
            Email email = this.getEmail(params);
            Resource resource = (Resource)params.get("resource");
            Node emailNode = (Node)resource.adaptTo(Node.class);
            String entityID = emailNode.getProperty(PARAM_ENTITY_ID).getString();
            if (entityID == null) {
                throw new ExactTargetException("ExactTarget Email Update operation: entityID missing");
            }
            email.setID(Integer.valueOf(Integer.parseInt(entityID)));
            this.updateEmail(configuration, email);
        }
        catch (Exception e) {
            if (e instanceof ExactTargetException) {
                throw (ExactTargetException)((Object)e);
            }
            throw new ExactTargetException(e.getMessage(), e);
        }
    }

    @Override
    public void updateEmail(Configuration configuration, Email email) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.updateEmail(email);
    }

    private void handleAutoResponder(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        this.handleSendMailToSubscriber(params, configuration);
    }

    private void handleSendMailToSubscriber(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        Email email = new Email();
        String newsLetterId = (String)params.get("autoresponderemail");
        String emailClassification = (String)params.get("emailclassification");
        String emailAddress = (String)params.get("email");
        if (emailAddress == null || "".equals(emailAddress) || newsLetterId == null || "".equals(newsLetterId) || emailClassification == null || "".equals(emailClassification)) {
            throw new ExactTargetException("Recipient Email or Autoresponder or Email Classification can't be empty");
        }
        email.setID(Integer.valueOf(Integer.parseInt(newsLetterId)));
        email.setCustomerKey(emailClassification);
        Subscriber subscriber = null;
        List formFields = (List)params.get("formFields");
        if (formFields != null) {
            subscriber = this.getSubscriber(params, formFields);
        } else {
            subscriber = new Subscriber();
            subscriber.setEmailAddress(emailAddress);
        }
        subscriber.setEmailAddress(emailAddress);
        this.sendEmail(configuration, email, subscriber);
    }

    @Override
    public void sendEmail(Configuration configuration, Email email, Subscriber subscriber) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.sendEmail(email, subscriber);
    }

    private void handleSendMailToSubscriberList(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        Email email = new Email();
        String newsLetterId = (String)params.get("autoresponderemail");
        String emailClassification = (String)params.get("emailclassification");
        String listID = (String)params.get("listID");
        if (newsLetterId == null || "".equals(newsLetterId) || emailClassification == null || "".equals(emailClassification) || listID == null || "".equals(listID)) {
            throw new ExactTargetException("Recipient List or Newsletter or Email Classification can't be empty");
        }
        email.setID(Integer.valueOf(Integer.parseInt(newsLetterId)));
        email.setCustomerKey(emailClassification);
        SubscriberList subList = new SubscriberList();
        subList.setID(Integer.valueOf(Integer.parseInt(listID)));
        this.sendEmail(configuration, email, subList);
    }

    @Override
    public void sendEmail(Configuration configuration, Email email, SubscriberList subList) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.sendEmail(email, subList);
    }

    private List<Map<String, Object>> handleGetSubscribers(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String listId = (String)params.get("ListID");
        if (listId == null || listId.trim().equals("")) {
            throw new ExactTargetException("Either listID is not specified or it is invalid. ListID -" + listId);
        }
        List<ListSubscriber> subscribers = this.getSubscribers(configuration, listId);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (ListSubscriber subscriber : subscribers) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("emailAddress", subscriber.getSubscriberKey());
            map.put("status", subscriber.getStatus().toString());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<ListSubscriber> getSubscribers(Configuration configuration, String listId) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.getSubscribers(listId);
    }

    private void handleDeleteSubscriptionList(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String listId = (String)params.get("ListID");
        if (listId == null || listId.trim().equals("")) {
            throw new ExactTargetException("Either listID is not specified or it is invalid. ListID -" + listId);
        }
        this.deleteList(configuration, listId);
    }

    @Override
    public void deleteList(Configuration configuration, String listId) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        client.deleteList(listId);
    }

    private List<Map<String, Object>> handleCreateSubscriptionList(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String classification;
        com.day.cq.mcm.exacttarget.client.List list = new com.day.cq.mcm.exacttarget.client.List();
        list.setListName((String)params.get("listName"));
        String desc = (String)params.get(PARAM_DESCRIPTION);
        if (desc != null) {
            list.setDescription(desc);
        }
        if ((classification = (String)params.get(PARAM_CLASSIFICATION)) != null) {
            list.setListClassification(ListClassificationEnum.fromString((String)classification));
        }
        com.day.cq.mcm.exacttarget.client.List createdList = this.createList(configuration, list);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(TYPE_ID, createdList.getID());
        map.put(TYPE_NAME, createdList.getListName());
        mapList.add(map);
        return mapList;
    }

    @Override
    public com.day.cq.mcm.exacttarget.client.List createList(Configuration configuration, com.day.cq.mcm.exacttarget.client.List list) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.createList(list);
    }

    private List<Map<String, Object>> handleGetEmailClassifications(Map<String, Object> filterMap, Configuration configuration) throws ExactTargetException {
        List<SendClassification> etClassifications = this.getSendClassifications(configuration, null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (SendClassification etClassification : etClassifications) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(TYPE_ID, etClassification.getCustomerKey());
            map.put(TYPE_NAME, etClassification.getName());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<SendClassification> getSendClassifications(Configuration configuration, FilterPart filter) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.getSendClassifications(filter);
    }

    private List<Map<String, Object>> handleGetEmails(Map<String, Object> filterMap, Configuration configuration) throws ExactTargetException {
        List<Email> emails = this.getEmails(configuration, null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (Email email : emails) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TYPE_ID, email.getID());
            map.put(TYPE_NAME, email.getName());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<Email> getEmails(Configuration configuration, FilterPart filter) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.getEmails(filter);
    }

    private List<Map<String, Object>> handleGetPersonalizationInfo(Map<String, Object> params, Configuration configuration) throws ExactTargetException {
        String propertyName;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        InheritanceValueMap configValues = configuration.getProperties();
        String dataExtensionCustomerKey = (String)configValues.get(propertyName = "DataExtension.CustomerKey", String.class);
        if (dataExtensionCustomerKey != null) {
            SimpleFilterPart filter = new SimpleFilterPart();
            filter.setProperty(propertyName);
            filter.setSimpleOperator(SimpleOperators.equals);
            filter.setValue(new String[]{dataExtensionCustomerKey});
            List<DataExtensionField> dExtFs = this.retrieveDataExtensionFields(configuration, (FilterPart)filter, new String[]{"Name"});
            for (DataExtensionField dExtF : dExtFs) {
                HashMap<String, String> mapDE = new HashMap<String, String>();
                mapDE.put(OPTION_TEXT, dExtF.getName());
                mapDE.put(OPTION_VALUE, dExtF.getName());
                mapList.add(mapDE);
            }
            return mapList;
        }
        List<PropertyDefinition> propertyDefs = this.describeSubscriber(configuration);
        for (PropertyDefinition propDef : propertyDefs) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(OPTION_TEXT, propDef.getName());
            map.put(OPTION_VALUE, "%%" + propDef.getName() + "%%");
            mapList.add(map);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(OPTION_TEXT, EMAIL_ADDRESS_FIELD_NAME);
        map.put(OPTION_VALUE, "%%emailaddr%%");
        mapList.add(map);
        map = new HashMap();
        map.put(OPTION_TEXT, FULL_NAME_FIELD_NAME);
        map.put(OPTION_VALUE, "%%fullname%%");
        mapList.add(map);
        return mapList;
    }

    @Override
    public List<PropertyDefinition> describeSubscriber(Configuration configuration) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.describeSubscriber();
    }

    private List<Map<String, Object>> handleGetLists(Map<String, Object> filterMap, Configuration configuration) throws ExactTargetException {
        List<com.day.cq.mcm.exacttarget.client.List> subscriberLists = this.getSubscriberList(configuration, null);
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        for (com.day.cq.mcm.exacttarget.client.List subscriberList : subscriberLists) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(TYPE_ID, subscriberList.getID());
            map.put(TYPE_NAME, subscriberList.getListName());
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    public List<com.day.cq.mcm.exacttarget.client.List> getSubscriberList(Configuration configuration, FilterPart filter) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.getSubscriberList(filter);
    }

    private ConnectionParams getConnectionParameters(Configuration configuration) throws ExactTargetException {
        String password;
        String username = (String)configuration.getInherited("username", (Object)"");
        String endpoint = (String)configuration.getInherited("apiendpoint", (Object)"");
        String accountId = (String)configuration.getInherited("accountId", (Object)"");
        String providerName = (String)configuration.getInherited("providerName", (Object)"");
        try {
            password = this.getPassword(configuration);
        }
        catch (CryptoException e) {
            throw new ExactTargetException(e.getMessage(), e);
        }
        ConnectionParamsImpl connectionParams = new ConnectionParamsImpl();
        connectionParams.setId(username);
        connectionParams.setKey(password);
        connectionParams.setUrl(endpoint);
        connectionParams.setAccountId(accountId);
        connectionParams.setProviderName(providerName);
        return connectionParams;
    }

    private String getPassword(Configuration configuration) throws CryptoException {
        String password = (String)configuration.getInherited("password", (Object)"");
        return this.cryptoSupport.isProtected(password) ? this.cryptoSupport.unprotect(password) : password;
    }

    @Override
    public Map<String, String> viewPublishedNewsletter(Configuration configuration, String entityId) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.viewPublishedNewsletter(entityId);
    }

    @Override
    public List<DataExtension> retrieveDataExtension(Configuration configuration, String[] properties, FilterPart filter) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.retrieveDataExtension(properties, filter);
    }

    @Override
    public List<DataExtensionField> retrieveDataExtensionFields(Configuration configuration, FilterPart filter, String[] fields) throws ExactTargetException {
        ExactTargetClient client = this.getExactTargetClient(configuration);
        return client.retrieveDataExtensionFields(filter, fields);
    }

    protected void bindCryptoSupport(CryptoSupport cryptoSupport) {
        this.cryptoSupport = cryptoSupport;
    }

    protected void unbindCryptoSupport(CryptoSupport cryptoSupport) {
        if (this.cryptoSupport == cryptoSupport) {
            this.cryptoSupport = null;
        }
    }
}

