/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.leadform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.SlingPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={SlingPostProcessor.class})
public class LeadFormParagraphPostProcessor
implements SlingPostProcessor {
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final String PAGE_MARKER = "/jcr:content/";
    public static final String RT_LEAD_FORM_PREFIX = "mcm/components/cta-form/";
    public static final String RT_LEAD_FORM_BEGIN = "mcm/components/cta-form/start";
    public static final String RT_LEAD_FORM_END = "mcm/components/cta-form/end";
    public static final String START_PROPERTY_FORMID = "formid";
    public static final String START_PROPERTY_END_RESOURCE_TYPE = "endResourceType";
    private static final String START_PROPERTY_ACTION_TYPE = "actionType";
    private static final String DEFAULT_ACTION_TYPE = "mcm/components/cta-form/actions/createLead";

    public void process(SlingHttpServletRequest request, List<Modification> changes) throws Exception {
        HashSet<String> fixPaths = new HashSet<String>();
        for (Modification mod : changes) {
            switch (mod.getType()) {
                case ORDER: 
                case MOVE: 
                case COPY: {
                    break;
                }
                case MODIFY: 
                case CREATE: 
                case DELETE: {
                    int pageEndPos = mod.getSource().indexOf("/jcr:content/");
                    if (pageEndPos == -1) break;
                    String pagePath = mod.getSource().substring(0, pageEndPos);
                    fixPaths.add(pagePath);
                }
            }
        }
        ResourceResolver resolver = request.getResourceResolver();
        for (String pagePath : fixPaths) {
            String contentPath = pagePath + '/' + "jcr:content";
            this.logger.debug("Checking page for form paragraphs {}", (Object)pagePath);
            Resource contentResource = resolver.getResource(contentPath);
            if (contentResource == null) continue;
            this.fixStructure(contentResource);
        }
    }

    private void fixStructure(Resource contentResource) throws RepositoryException {
        Iterator rI = ResourceUtil.listChildren((Resource)contentResource);
        while (rI.hasNext()) {
            Resource res = (Resource)rI.next();
            if (ResourceUtil.isA((Resource)res, (String)RT_LEAD_FORM_BEGIN) || ResourceUtil.isA((Resource)res, (String)RT_LEAD_FORM_END)) {
                if (this.checkFormStructure(res) == null) continue;
                this.logger.debug("Fixed forms structure at {}", (Object)contentResource.getPath());
                continue;
            }
            this.fixStructure(res);
        }
    }

    private Resource searchFormStart(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        if (RT_LEAD_FORM_BEGIN.equals(resource.getResourceType())) {
            return resource;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        ArrayList<Resource> predecessor = new ArrayList<Resource>();
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            predecessor.add(current);
        }
        Collections.reverse(predecessor);
        for (Resource current2 : predecessor) {
            if (RT_LEAD_FORM_BEGIN.equals(current2.getResourceType())) {
                return resource;
            }
            if (!RT_LEAD_FORM_END.equals(current2.getResourceType())) continue;
            return null;
        }
        return this.searchFormStart(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource checkFormStructure(Resource rsrc) {
        Resource formStart;
        if (LeadFormParagraphPostProcessor.checkResourceType(rsrc, RT_LEAD_FORM_BEGIN)) {
            Node start = (Node)rsrc.adaptTo(Node.class);
            if (start != null) {
                try {
                    if (!start.hasProperty(START_PROPERTY_FORMID)) {
                        start.setProperty(START_PROPERTY_FORMID, rsrc.getPath().replaceAll("[/:.]", "_"));
                    }
                    if (!start.hasProperty(START_PROPERTY_ACTION_TYPE)) {
                        start.setProperty(START_PROPERTY_ACTION_TYPE, DEFAULT_ACTION_TYPE);
                    }
                    start.getSession().save();
                }
                catch (RepositoryException e) {
                    this.logger.error("Unable to add default action type and form id " + rsrc, (Throwable)e);
                }
            } else {
                this.logger.error("Resource is not adaptable to node - unable to add default action type and form id for " + rsrc);
            }
            Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
            while (!((Resource)iter.next()).getPath().equals(rsrc.getPath())) {
            }
            Resource formEnd = null;
            Resource nextPar = null;
            boolean stop = false;
            while (iter.hasNext() && formEnd == null && !stop) {
                Resource current = (Resource)iter.next();
                if (nextPar == null) {
                    nextPar = current;
                }
                if (LeadFormParagraphPostProcessor.checkResourceType(current, RT_LEAD_FORM_END)) {
                    formEnd = current;
                    continue;
                }
                if (!LeadFormParagraphPostProcessor.checkResourceType(current, RT_LEAD_FORM_BEGIN)) continue;
                stop = true;
            }
            if (formEnd == null) {
                Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
                if (parent != null) {
                    try {
                        String nodeName = "form_end_" + System.currentTimeMillis();
                        Node node = parent.addNode(nodeName);
                        ValueMap props = ResourceUtil.getValueMap((Resource)rsrc);
                        String resourceType = RT_LEAD_FORM_END;
                        if (props != null) {
                            resourceType = (String)props.get(START_PROPERTY_END_RESOURCE_TYPE, (Object)resourceType);
                        }
                        node.setProperty("sling:resourceType", resourceType);
                        if (!resourceType.equals(RT_LEAD_FORM_END)) {
                            node.setProperty("sling:resourceSuperType", RT_LEAD_FORM_END);
                        }
                        if (nextPar != null) {
                            parent.orderBefore(node.getName(), ResourceUtil.getName((Resource)nextPar));
                        }
                        parent.getSession().save();
                        Iterator i = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)rsrc));
                        while (true) {
                            if (!i.hasNext()) break;
                            Resource r = (Resource)i.next();
                            if (!nodeName.equals(ResourceUtil.getName((Resource)r))) continue;
                            Resource resource = r;
                            return resource;
                        }
                    }
                    catch (RepositoryException re) {
                        this.logger.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                    }
                    finally {
                        try {
                            if (parent.getSession().hasPendingChanges()) {
                                parent.getSession().refresh(false);
                            }
                        }
                        catch (RepositoryException re) {}
                    }
                } else {
                    this.logger.error("Resource is not adaptable to node - unable to add missing form end element for " + rsrc);
                }
            }
        } else if (LeadFormParagraphPostProcessor.checkResourceType(rsrc, RT_LEAD_FORM_END) && (formStart = this.searchFormStart(rsrc)) == null) {
            Node node = (Node)rsrc.adaptTo(Node.class);
            Node parent = (Node)ResourceUtil.getParent((Resource)rsrc).adaptTo(Node.class);
            if (node != null && parent != null) {
                try {
                    node.remove();
                    parent.getSession().save();
                    Resource nextPar = rsrc;
                    return nextPar;
                }
                catch (RepositoryException re) {
                    this.logger.error("Unable to create missing form end element for form start " + rsrc, (Throwable)re);
                }
                finally {
                    try {
                        if (node.getSession().hasPendingChanges()) {
                            node.getSession().refresh(false);
                        }
                    }
                    catch (RepositoryException re) {}
                }
            }
            this.logger.error("Resource is not adaptable to node - unable to remove form element " + rsrc);
        }
        return null;
    }

    public static boolean checkResourceType(Resource resource, String type) {
        return ResourceUtil.isA((Resource)resource, (String)type);
    }
}

