/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.leadform.creator;

import com.day.cq.i18n.I18n;
import com.day.cq.mcm.landingpage.leadform.AuthorizableLeadFormRequestProperties;
import com.day.cq.security.Authorizable;
import com.day.cq.security.Group;
import com.day.cq.security.NoSuchAuthorizableException;
import com.day.cq.security.UserManager;
import com.day.cq.security.profile.Profile;
import com.day.cq.wcm.api.Page;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.auth.core.AuthUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service(value={LeadFormsCreator.class})
public class LeadFormsCreator {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "cta-form";
    protected static final String ATTR_RESOURCE = LeadFormsCreator.class.getName() + "/resource";
    protected static final String PARAM_GROUP_NAME = "groupName";
    protected static final String PARAM_INTERMEDIATE_PATH = "intermediatePath";
    protected static final String PARAM_PASSWORD = "rep:password";

    public void createUser(Resource resource, Page page, HttpServletRequest request) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)resource.getPath());
        }
        Authorizable authorizable = null;
        ResourceResolver resolver = ((Resource)page.adaptTo(Resource.class)).getResourceResolver();
        Session s = (Session)resolver.adaptTo(Session.class);
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        AuthorizableLeadFormRequestProperties props = new AuthorizableLeadFormRequestProperties(LeadFormsCreator.getActionParameterMap(resource, request));
        Map<String, String[]> parameter = LeadFormsCreator.getActionParameterMap(resource, request);
        String userId = props.getUserID();
        if (StringUtils.isEmpty((String)userId)) {
            if (StringUtils.isEmpty((String)request.getParameter("email"))) {
                throw new SlingException("UserId and email, both cannot be null or empty", (Throwable)new Exception());
            }
            userId = request.getParameter("email");
        }
        try {
            String groupName;
            String intermediatePath = props.getIntermediatePath();
            try {
                authorizable = userManager.get(userId);
            }
            catch (NoSuchAuthorizableException ex) {
                String password = props.getPassword();
                if (password == null) {
                    String pwdChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNPQRSTUVWXYZ123456789";
                    password = "";
                    for (int i = 0; i < 12; ++i) {
                        password = password + pwdChars.charAt((int)(Math.random() * (double)pwdChars.length()));
                    }
                }
                authorizable = userManager.createUser(userId, password, userId, intermediatePath);
            }
            String cat = LeadFormsCreator.getParameter(resource, request, "cq:authorizableCategory");
            if (cat != null) {
                authorizable.setProperty("cq:authorizableCategory", cat);
            }
            if (authorizable.isUser() && (groupName = props.getGroupName()) != null) {
                Authorizable groupNameAuthorizable = null;
                try {
                    groupNameAuthorizable = userManager.get(groupName);
                }
                catch (NoSuchAuthorizableException ex) {
                    this.logger.debug("groupName - " + groupName + " does not exist");
                }
                if (groupNameAuthorizable == null) {
                    groupNameAuthorizable = userManager.createGroup(groupName, groupName, intermediatePath);
                    if (cat != null) {
                        groupNameAuthorizable.setProperty("cq:authorizableCategory", cat);
                    }
                    this.logger.debug("Create group {}", (Object)groupNameAuthorizable.getID());
                }
                ((Group)groupNameAuthorizable).addMember(authorizable);
                this.logger.debug("Added authorizable {} to group {}", (Object)authorizable.getID(), (Object)groupNameAuthorizable.getID());
            }
            Profile profile = authorizable.getProfile();
            this.setProfileProperties(profile, parameter);
            if (parameter.containsKey("useasemailid")) {
                profile.put((Object)"email", (Object)userId);
            }
            profile.save();
            try {
                s.save();
            }
            catch (RepositoryException e) {
                try {
                    s.refresh(false);
                }
                catch (RepositoryException e1) {
                    this.logger.error("Failed to revert pending changes", (Throwable)e);
                }
                throw new SlingException(e.getMessage(), (Throwable)e);
            }
        }
        catch (AccessDeniedException e) {
            throw new SlingException(e.getMessage(), (Throwable)e);
        }
    }

    public void redirectUrl(Page containingPage, String extension, Boolean isError, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String redirectUrl = request.getParameter(":redirect");
        if (redirectUrl != null && !AuthUtil.isRedirectValid((HttpServletRequest)request, (String)redirectUrl)) {
            this.logger.error("Invalid redirect specified: ", (Object)redirectUrl);
            redirectUrl = containingPage.getPath() + "." + EXTENSION;
        }
        if (isError.booleanValue() || redirectUrl == null) {
            redirectUrl = request.getContextPath() + containingPage.getPath() + extension;
        }
        response.sendRedirect(redirectUrl);
    }

    public void unSubscribe() {
    }

    private void setProfileProperties(Profile profile, Map<String, String[]> props) throws AccessDeniedException {
        for (String entry : props.keySet()) {
            if (entry.startsWith(":") || entry.startsWith("_") || entry.equals("cq:authorizableCategory")) continue;
            String[] value = props.get(entry);
            if (value.length == 0) {
                profile.remove((Object)entry);
                continue;
            }
            profile.put((Object)entry, (Object)value[0]);
        }
    }

    public void unsubscribeUser(Resource resource, Page page, SlingHttpServletRequest slingRequest, HttpServletRequest request) throws ServletException, IOException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Validating POST request with form definition stored at {}.", (Object)resource.getPath());
        }
        Authorizable authorizable = null;
        I18n i18n = new I18n(slingRequest.getResourceBundle(page.getLanguage(false)));
        ResourceResolver resolver = ((Resource)page.adaptTo(Resource.class)).getResourceResolver();
        Session s = (Session)resolver.adaptTo(Session.class);
        UserManager userManager = (UserManager)resolver.adaptTo(UserManager.class);
        AuthorizableLeadFormRequestProperties props = new AuthorizableLeadFormRequestProperties(LeadFormsCreator.getActionParameterMap(resource, request));
        String userId = props.getUserID();
        if (StringUtils.isEmpty((String)userId)) {
            if (StringUtils.isEmpty((String)request.getParameter("email"))) {
                throw new SlingException(i18n.get("UserId and email, both cannot be null or empty "), (Throwable)new Exception());
            }
            userId = request.getParameter("email");
        }
        try {
            try {
                authorizable = userManager.get(userId);
            }
            catch (NoSuchAuthorizableException ex) {
                throw new SlingException(i18n.get("User does not exist for id - {0}", null, new Object[]{userId}), (Throwable)new Exception());
            }
            String cat = LeadFormsCreator.getParameter(resource, request, "cq:authorizableCategory");
            if (cat != null) {
                authorizable.setProperty("cq:authorizableCategory", cat);
            }
            if (authorizable.isUser()) {
                String groupName = props.getGroupName();
                if (groupName != null) {
                    Authorizable groupNameAuthorizable = null;
                    try {
                        groupNameAuthorizable = userManager.get(groupName);
                    }
                    catch (NoSuchAuthorizableException ex) {
                        throw new SlingException(i18n.get("Please provide valid subscription list. {0} is not valid. ", null, new Object[]{groupName}), (Throwable)new Exception());
                    }
                    ((Group)groupNameAuthorizable).removeMember(authorizable);
                    this.logger.debug("Removed id {} from group {}", (Object)authorizable.getID(), (Object)groupNameAuthorizable.getID());
                } else {
                    throw new SlingException(i18n.get("Subscription list cannot be null"), (Throwable)new Exception());
                }
            }
            try {
                s.save();
            }
            catch (RepositoryException e) {
                try {
                    s.refresh(false);
                }
                catch (RepositoryException e1) {
                    this.logger.error("Failed to revert pending changes", (Throwable)e);
                }
                throw new SlingException(e.getMessage(), (Throwable)e);
            }
        }
        catch (AccessDeniedException e) {
            throw new SlingException(e.getMessage(), (Throwable)e);
        }
    }

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)formResource));
        LeadFormsCreator.collectFormElements(list, iter);
        return list.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        boolean stop = false;
        while (!stop && iter.hasNext()) {
            Resource n = iter.next();
            if (n.getResourceType().startsWith("mcm/components/cta-form/") || n.getResourceSuperType() != null && n.getResourceSuperType().startsWith("mcm/components/cta-form/")) {
                list.add(n);
                continue;
            }
            Iterator cI = ResourceUtil.listChildren((Resource)n);
            if (cI == null) continue;
            stop = LeadFormsCreator.collectFormElements(list, cI);
        }
        return stop;
    }

    public static void printTitle(String fieldId, String title, boolean required, boolean hideLabel, String className, Writer out) throws IOException {
        out.write("<div class=\"form_leftcol\"");
        if (hideLabel) {
            out.write(" style=\"display: none;\"");
        }
        title = title != null && title.length() > 0 ? StringEscapeUtils.escapeHtml4((String)title) : "&nbsp;";
        out.write(">");
        String titileClassName = "form_leftcollabel" + (!StringUtils.isEmpty((String)className) ? " " + className : "");
        titileClassName = StringEscapeUtils.escapeHtml4((String)titileClassName);
        out.write("<div class=\"" + titileClassName + "\">");
        if (fieldId != null) {
            fieldId = StringEscapeUtils.escapeHtml4((String)fieldId);
            out.write("<label for=\"" + fieldId + "\">" + title + "</label>");
        } else {
            out.write("<span>" + title + "</span>");
        }
        out.write("</div>");
        out.write("<div class=\"form_leftcolmark\">");
        if (!hideLabel) {
            if (required) {
                out.write(" *");
            } else {
                out.write("&nbsp;");
            }
        }
        out.write("</div>");
        out.write("</div>\n");
    }

    private static Map<String, String[]> getActionParameterMap(Resource resource, HttpServletRequest request) {
        Map unmodifiableMap = request.getParameterMap();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>(unmodifiableMap);
        ValueMap values = ResourceUtil.getValueMap((Resource)resource);
        Set keyset = values.keySet();
        for (String key : keyset) {
            if (!key.equals(PARAM_GROUP_NAME) && !key.equals(PARAM_INTERMEDIATE_PATH) && !key.equals(PARAM_PASSWORD) && !key.equals("rep:userId") && !key.equals("cq:authorizableCategory")) continue;
            parameterMap.put(key, new String[]{(String)values.get(key, String.class)});
        }
        return parameterMap;
    }

    private static String getParameter(Resource resource, HttpServletRequest request, String paramName) {
        String paramValue = request.getParameter(paramName);
        if (paramValue == null) {
            ValueMap values = ResourceUtil.getValueMap((Resource)resource);
            paramValue = (String)values.get(paramName, String.class);
        }
        return paramValue;
    }
}

