/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.parser.taghandlers.cta;

import com.day.cq.dam.indd.PageComponent;
import com.day.cq.wcm.designimporter.DesignImportException;
import com.day.cq.wcm.designimporter.parser.HTMLContentType;
import com.day.cq.wcm.designimporter.parser.taghandlers.AbstractTagHandler;
import com.day.cq.wcm.designimporter.util.TagUtils;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.ccil.cowan.tagsoup.AttributesImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;

public class GraphicalClickThroughComponentTagHandler
extends AbstractTagHandler {
    private Logger logger = LoggerFactory.getLogger(GraphicalClickThroughComponentTagHandler.class);
    private static final String RESOURCE_TYPE_CTA = "mcm/components/cta-graphicallink";
    private Map<String, Object> base = new HashMap<String, Object>();
    private String suffix;

    public void beginHandling(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        super.beginHandling(uri, localName, qName, atts);
        if ("a".equalsIgnoreCase(localName)) {
            AttributesImpl modAttibutes = new AttributesImpl(atts);
            int index = atts.getIndex("data-cq-component");
            if (index > -1) {
                modAttibutes.removeAttribute(index);
            }
            this.startElement(uri, localName, qName, (Attributes)modAttibutes);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws DesignImportException {
        if (StringUtils.equalsIgnoreCase((String)"a", (String)localName)) {
            this.base.put("targetURL", atts.getValue("href"));
            this.base.put("hrefTargets", atts.getValue("target"));
            this.base.put("anchorCss", atts.getValue("class"));
            this.base.put("anchorId", atts.getValue("id"));
        } else if (StringUtils.equalsIgnoreCase((String)"img", (String)localName)) {
            this.base.put("fileReference", this.getDesignPath() + "/" + atts.getValue("src"));
            String titleValue = atts.getValue("title");
            this.base.put("jcr:title", titleValue);
            String altValue = atts.getValue("alt");
            this.base.put("alt", altValue);
            this.base.put("height", atts.getValue("height"));
            this.base.put("width", atts.getValue("width"));
            this.base.put("imgCss", atts.getValue("class"));
            this.base.put("imgId", atts.getValue("id"));
            if (altValue == null || altValue.trim().equals("")) {
                this.base.put("alt", titleValue);
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws DesignImportException {
        String chars = new String(ch).substring(start, start + length);
        if (chars.length() > 0) {
            // empty if block
        }
    }

    private String getDesignPath() {
        try {
            return this.designImporterContext.designNode.getPath();
        }
        catch (RepositoryException e) {
            this.logger.error("A repository exception occured while trying to obtain the design path from the landing page context", (Throwable)e);
            return "";
        }
    }

    public void endHandling(String uri, String localName, String qName) throws DesignImportException {
        super.endHandling(uri, localName, qName);
        if ("a".equalsIgnoreCase(localName)) {
            this.endElement(uri, localName, qName);
        }
        ValueMapDecorator properties = new ValueMapDecorator(this.base);
        this.suffix = this.designImporterContext.componentSuffixGenerator.getSuffix("clickthroughgraphicallink");
        PageComponent textComponent = this.pageBuilder.createComponent(RESOURCE_TYPE_CTA, (ValueMap)properties, this.getNameHint());
        this.getPageComponents().add(textComponent);
    }

    public boolean supportsContent(HTMLContentType htmlContentType) {
        return htmlContentType == HTMLContentType.MARKUP;
    }

    private String getNameHint() {
        return "graphicallink" + this.suffix;
    }

    public Object getContent(HTMLContentType htmlContentType) {
        if (htmlContentType == HTMLContentType.MARKUP) {
            String cqIncludeJspTag = "<sling:include path=\"" + this.getNameHint() + "\"" + "/>";
            return this.componentDivStartTag + cqIncludeJspTag + TagUtils.getMatchingEndTag((String)this.componentDivStartTag);
        }
        return null;
    }
}

