/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.mcm.landingpage.servlets;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
@Service
@Properties(value={@Property(name="sling.servlet.paths", value={"/bin/mcm/ctaforms/ctaactions"}, propertyPrivate=true), @Property(name="sling.servlet.extensions", value={"json", "html"}, propertyPrivate=true), @Property(name="sling.servlet.methods", value={"GET"}, propertyPrivate=true)})
public class LeadFormActionsServlet
extends AbstractPredicateServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Reference
    private FormsManager formsManager;
    private final String CTA_ACTION_FILTER = "ctaformaction";

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        try {
            JSONWriter w = new JSONWriter((Writer)resp.getWriter());
            if (req.getRequestURI().contains("/ctaactions")) {
                resp.setContentType("application/json");
                resp.setCharacterEncoding("utf-8");
                this.writeActions(w);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while generating JSON list", (Throwable)e);
            resp.sendError(500, e.toString());
            return;
        }
    }

    private void writeActions(JSONWriter w) throws JSONException {
        Iterator descIter = this.formsManager.getActions();
        this.writeJson(this.filterActions(descIter, "ctaformaction"), w, false);
    }

    private Iterator<FormsManager.ComponentDescription> filterActions(Iterator<FormsManager.ComponentDescription> descIter, String filter) {
        ArrayList<FormsManager.ComponentDescription> actions = new ArrayList<FormsManager.ComponentDescription>();
        while (descIter.hasNext()) {
            FormsManager.ComponentDescription desc = descIter.next();
            if (desc.getHint() == null || !desc.getHint().equals(filter)) continue;
            actions.add(desc);
        }
        return actions.iterator();
    }

    private void writeJson(Iterator<FormsManager.ComponentDescription> descIter, JSONWriter w, boolean writeEmpty) throws JSONException {
        w.array();
        if (writeEmpty) {
            w.object();
            w.key("value").value((Object)"");
            w.key("text").value((Object)"None");
            w.endObject();
        }
        while (descIter.hasNext()) {
            FormsManager.ComponentDescription desc = descIter.next();
            w.object();
            w.key("value");
            w.value((Object)desc.getResourceType());
            w.key("text");
            w.value((Object)desc.getTitle());
            if (desc.getHint() != null) {
                w.key("qtip");
                w.value((Object)desc.getHint());
            }
            w.endObject();
        }
        w.endArray();
    }

    protected void bindFormsManager(FormsManager formsManager) {
        this.formsManager = formsManager;
    }

    protected void unbindFormsManager(FormsManager formsManager) {
        if (this.formsManager == formsManager) {
            this.formsManager = null;
        }
    }
}

