/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.day.cq.commons.Filter;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.WCMMode;
import javax.servlet.ServletRequest;

public class PageFilter
implements Filter<Page> {
    private final boolean includeInvalid;
    private final boolean includeHidden;

    public PageFilter() {
        this(false, false);
    }

    public PageFilter(WCMMode mode) {
        this(mode != WCMMode.DISABLED, false);
    }

    public PageFilter(ServletRequest req) {
        this(WCMMode.fromRequest(req));
    }

    public PageFilter(boolean includeInvalid, boolean includeHidden) {
        this.includeInvalid = includeInvalid;
        this.includeHidden = includeHidden;
    }

    public boolean includes(Page page) {
        return !(!this.includeHidden && page.isHideInNav() || !this.includeInvalid && !page.isValid() || page.getDeleted() != null);
    }

    public boolean isIncludeInvalid() {
        return this.includeInvalid;
    }

    public boolean isIncludeHidden() {
        return this.includeHidden;
    }
}

