/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api.components;

import javax.jcr.Node;
import org.apache.sling.jcr.resource.JcrPropertyMap;

public class InplaceEditingConfig {
    public static final String PN_ACTIVE = "active";
    public static final String PN_EDITOR_TYPE = "editorType";
    public static final String PN_CONFIG_PATH = "configPath";
    public static final String NN_CONFIG_DEFAULT = "/config";
    private final boolean isActive;
    private final String editorType;
    private final String configPath;

    public InplaceEditingConfig(Node configNode) {
        JcrPropertyMap configProps = new JcrPropertyMap(configNode);
        this.editorType = (String)configProps.get(PN_EDITOR_TYPE, null);
        this.isActive = this.editorType != null && (Boolean)configProps.get(PN_ACTIVE, (Object)false) != false;
        String configPath = (String)configProps.get(PN_CONFIG_PATH, (Object)(configProps.getPath() + NN_CONFIG_DEFAULT));
        if (!configPath.startsWith("/")) {
            String basePath = configProps.getPath();
            configPath = basePath + "/" + configPath;
        }
        this.configPath = configPath;
    }

    public InplaceEditingConfig(InplaceEditingConfig config) {
        this.isActive = config.isActive();
        this.editorType = config.getEditorType();
        this.configPath = config.getConfigPath();
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getEditorType() {
        return this.editorType;
    }

    public String getConfigPath() {
        return this.configPath;
    }
}

