/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.api;

import com.day.cq.wcm.api.PageModification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.sling.event.EventPropertiesMap;
import org.apache.sling.event.EventUtil;
import org.osgi.service.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PageEvent
implements Serializable {
    public static final String EVENT_TOPIC = "com/day/cq/wcm/core/page";
    private static final String PROPERTY_MODIFICATIONS = "modifications";
    private final boolean isLocal;
    private final List<PageModification> modifications;

    public PageEvent(PageModification mod) {
        this(Collections.singletonList(mod), true);
    }

    public PageEvent(List<PageModification> mods) {
        this(mods, true);
    }

    public PageEvent(List<PageModification> mods, boolean isLocal) {
        this.modifications = mods;
        this.isLocal = isLocal;
    }

    public Iterator<PageModification> getModifications() {
        return this.modifications.iterator();
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public static PageEvent fromEvent(Event evt) {
        if (!evt.getTopic().equals(EVENT_TOPIC)) {
            return null;
        }
        ArrayList<PageModification> mods = new ArrayList<PageModification>();
        List modProps = (List)evt.getProperty(PROPERTY_MODIFICATIONS);
        if (modProps != null) {
            for (EventPropertiesMap modProp : modProps) {
                mods.add(PageModification.fromEventProperties(modProp));
            }
        }
        return new PageEvent(mods, EventUtil.isLocal((Event)evt));
    }

    protected EventPropertiesMap getEventProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<EventPropertiesMap> modProps = new ArrayList<EventPropertiesMap>();
        Iterator<PageModification> i = this.getModifications();
        while (i.hasNext()) {
            modProps.add(i.next().getEventProperties());
        }
        properties.put(PROPERTY_MODIFICATIONS, modProps);
        if (!this.isLocal) {
            properties.put("event.application", "unknown");
        }
        return new EventPropertiesMap(properties);
    }

    public Event toEvent() {
        return EventUtil.createDistributableEvent((String)EVENT_TOPIC, (Dictionary)this.getEventProperties());
    }

    public Event toNonDistributableEvent() {
        return new Event(EVENT_TOPIC, (Dictionary)this.getEventProperties());
    }
}

