/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.components.DropTarget;
import com.day.cq.wcm.api.components.EditConfig;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCMUtils {
    private static final Logger log = LoggerFactory.getLogger(WCMUtils.class);
    public static final String DEBUG_PARAM = "debug";

    private WCMUtils() {
    }

    public static Component getComponent(Resource resource) {
        ComponentManager compMgr = (ComponentManager)resource.getResourceResolver().adaptTo(ComponentManager.class);
        if (compMgr == null) {
            log.warn("Unable to retrieve component manager for {}", (Object)resource);
            return null;
        }
        return compMgr.getComponentOfResource(resource);
    }

    public static String getInheritedProperty(Page page, ResourceResolver resolver, String name) {
        String value = null;
        while (value == null && page != null) {
            value = (String)page.getProperties().get(name, String.class);
            if (value != null) continue;
            Resource res = resolver.getResource(page.getPath() + "/..");
            page = res == null ? null : (Page)res.adaptTo(Page.class);
        }
        return value;
    }

    public static Style getStyle(SlingHttpServletRequest request) {
        Designer d = (Designer)request.getResourceResolver().adaptTo(Designer.class);
        String suffix = request.getRequestPathInfo().getSuffix();
        if (suffix == null) {
            ComponentContext ctx = WCMUtils.getComponentContext((ServletRequest)request);
            if (ctx != null) {
                Design design = d.getDesign(ctx.getPage());
                return design == null ? null : design.getStyle(ctx.getCell());
            }
        } else {
            if (suffix.startsWith("/")) {
                suffix = suffix.substring(1);
            }
            return d.getStyle(request.getResource(), suffix);
        }
        return null;
    }

    public static ComponentContext getComponentContext(ServletRequest request) {
        return (ComponentContext)request.getAttribute("com.day.cq.wcm.componentcontext");
    }

    public static DropTarget getDropTarget(ServletRequest request, String name) {
        ComponentContext componentContext = WCMUtils.getComponentContext(request);
        if (componentContext != null && componentContext.getEditContext() != null) {
            EditConfig cfg = componentContext.getEditContext().getEditConfig();
            return (DropTarget)cfg.getDropTargets().get(name);
        }
        return null;
    }

    public static Node getCurrentNode(SlingHttpServletRequest request, boolean create) {
        Resource res = request.getResource();
        Node node = (Node)res.adaptTo(Node.class);
        if (node == null && create) {
            String path = res.getPath();
            int idx = path.lastIndexOf(47);
            String name = path.substring(idx + 1);
            path = path.substring(0, idx);
            try {
                Node parent = (Node)((Session)request.getResourceResolver().adaptTo(Session.class)).getItem(path);
                node = parent.addNode(name);
                node.setProperty("sling:resourceType", res.getResourceType());
                parent.save();
            }
            catch (RepositoryException e) {
                log.error("Unable to create new node for " + res);
            }
        }
        return node;
    }

    public static String getKeywords(Page page) {
        StringBuffer keywords = new StringBuffer();
        Tag[] tags = page.getTags();
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                keywords.append(", ");
            }
            keywords.append(tags[i].getTitle());
        }
        return keywords.toString();
    }
}

