/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceSearch {
    private static final Logger log = LoggerFactory.getLogger(ReferenceSearch.class);
    private String searchRoot = "/";
    private boolean exact = false;

    public String getSearchRoot() {
        return this.searchRoot;
    }

    public ReferenceSearch setSearchRoot(String searchRoot) {
        this.searchRoot = searchRoot == null || searchRoot.equals("") ? "/" : searchRoot;
        return this;
    }

    public boolean isExact() {
        return this.exact;
    }

    public ReferenceSearch setExact(boolean exact) {
        this.exact = exact;
        return this;
    }

    public Map<String, Info> search(ResourceResolver resolver, String path) {
        if (path == null) {
            return Collections.emptyMap();
        }
        String root = this.searchRoot.equals("/") ? "" : this.searchRoot;
        PageManager manager = (PageManager)resolver.adaptTo(PageManager.class);
        HashMap<String, Info> infos = new HashMap<String, Info>();
        Pattern pattern = this.getReplacementPattern(path);
        String query = String.format("%s//*[jcr:contains(., '%s')]", root, path);
        this.search(resolver, manager, infos, pattern, query);
        query = String.format("%s//*[jcr:like(@path, '%s%%')]", root, path);
        this.search(resolver, manager, infos, pattern, query);
        Iterator entries = infos.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            if (!((Info)entry.getValue()).getProperties().isEmpty()) continue;
            entries.remove();
        }
        return infos;
    }

    private void search(ResourceResolver resolver, PageManager manager, Map<String, Info> infos, Pattern pattern, String query) {
        log.info("Searching for references using: {}", (Object)query);
        Iterator iter = resolver.findResources(query, "xpath");
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            Page page = manager.getContainingPage(res);
            if (page == null) continue;
            Info info = infos.get(page.getPath());
            if (info == null) {
                info = new Info(page);
                infos.put(page.getPath(), info);
            }
            try {
                Node node = (Node)res.adaptTo(Node.class);
                PropertyIterator pIter = node.getProperties();
                block3: while (pIter.hasNext()) {
                    Property p = pIter.nextProperty();
                    if (p.getType() != 1 && p.getType() != 7) continue;
                    if (p.getDefinition().isMultiple()) {
                        for (Value v : p.getValues()) {
                            String value = v.getString();
                            if (!pattern.matcher(value).find()) continue;
                            info.addProperty(p.getPath());
                            continue block3;
                        }
                        continue;
                    }
                    String value = p.getString();
                    if (!pattern.matcher(value).find()) continue;
                    info.addProperty(p.getPath());
                }
            }
            catch (RepositoryException e) {
                log.error("Error while accessing " + res.getPath(), (Throwable)e);
            }
        }
    }

    public Collection<String> adjustReferences(ResourceResolver resolver, String path, String destination, String[] refPaths) {
        if (refPaths == null) {
            return Collections.emptyList();
        }
        HashSet<String> adjusted = new HashSet<String>();
        for (String p : refPaths) {
            Resource r = resolver.getResource(p);
            if (r == null) {
                log.warn("Given path does not address a resource: {}", (Object)p);
                continue;
            }
            Page page = (Page)r.adaptTo(Page.class);
            if (page == null) {
                log.warn("Given path does not address a page: {}", (Object)p);
                continue;
            }
            Resource content = page.getContentResource();
            if (content == null) {
                log.warn("Given page does not have content: {}", (Object)p);
                continue;
            }
            try {
                adjusted.addAll(this.adjustReferences((Node)content.adaptTo(Node.class), path, destination));
            }
            catch (RepositoryException e) {
                log.error("Error while adjusting references on " + page.getPath(), (Throwable)e);
            }
        }
        return adjusted;
    }

    public Collection<String> adjustReferences(Node node, String path, String destination) throws RepositoryException {
        HashSet<String> adjusted = new HashSet<String>();
        Pattern pattern = this.getReplacementPattern(path);
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            Property p = iter.nextProperty();
            if (p.getType() != 1 && p.getType() != 7) continue;
            if (p.getDefinition().isMultiple()) {
                Value[] values = p.getValues();
                boolean modified = false;
                for (int i = 0; i < values.length; ++i) {
                    String value = this.rewrite(pattern, values[i].getString(), destination);
                    if (value == null) continue;
                    values[i] = node.getSession().getValueFactory().createValue(value, p.getType());
                    modified = true;
                }
                if (!modified) continue;
                p.setValue(values);
                adjusted.add(p.getPath());
                log.info("Adjusted property {}.", (Object)p.getPath());
                continue;
            }
            String value = this.rewrite(pattern, p.getString(), destination);
            if (value == null) continue;
            p.setValue(value);
            log.info("Adjusted property {}.", (Object)p.getPath());
        }
        iter = node.getNodes();
        while (iter.hasNext()) {
            adjusted.addAll(this.adjustReferences(iter.nextNode(), path, destination));
        }
        return adjusted;
    }

    protected Pattern getReplacementPattern(String path) {
        if (this.exact) {
            return Pattern.compile("([\"']|^)(" + path + ")([;.?#\"']|$)");
        }
        return Pattern.compile("([\"']|^)(" + path + ")\\b");
    }

    protected String rewrite(Pattern p, String value, String to) {
        String repl;
        Matcher m = p.matcher(value);
        StringBuffer ret = null;
        String string = repl = this.exact ? "$1" + to + "$3" : "$1" + to;
        while (m.find()) {
            if (ret == null) {
                ret = new StringBuffer();
            }
            m.appendReplacement(ret, repl);
        }
        if (ret == null) {
            return null;
        }
        m.appendTail(ret);
        return ret.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Info {
        private final Page page;
        private final Set<String> properties = new HashSet<String>();

        public Info(Page page) {
            this.page = page;
        }

        private void addProperty(String path) {
            this.properties.add(path);
        }

        public Page getPage() {
            return this.page;
        }

        public Set<String> getProperties() {
            return this.properties;
        }
    }
}

