/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons.search;

import com.day.text.ISO9075;
import com.day.text.Text;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryManager;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.commons.iterator.RowIteratorAdapter;

public final class GQL {
    private static final String PATH = "path";
    private static final String TYPE = "type";
    private static final String ORDER = "order";
    private static final String LIMIT = "limit";
    private static final String OR = "OR";
    private static final String JCR_MIXIN_TYPES = "jcr:mixinTypes";
    private static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    private static final String JCR_ROOT = "jcr:root";
    private static final String JCR_CONTAINS = "jcr:contains";
    private static final String JCR_SCORE = "jcr:score";
    private static final String DESCENDING = "descending";
    private static final String REP_EXCERPT = "rep:excerpt";
    private final String statement;
    private final Session session;
    private final List conditions = new ArrayList();
    private final String commonPathPrefix;
    private final Filter filter;
    private Map ntNames;
    private Map childNodeNames;
    private Map propertyNames;
    private String pathConstraint = "//*";
    private OptionalExpression typeConstraints = null;
    private Expression orderBy = new OrderByExpression();
    private int offset = 0;
    private int numResults = Integer.MAX_VALUE;

    private GQL(String statement, Session session, String commonPathPrefix, Filter filter) {
        this.statement = statement;
        this.session = session;
        this.commonPathPrefix = commonPathPrefix;
        this.filter = filter;
    }

    public static RowIterator execute(String statement, Session session) {
        return GQL.execute(statement, session, null);
    }

    public static RowIterator execute(String statement, Session session, String commonPathPrefix) {
        return GQL.execute(statement, session, commonPathPrefix, null);
    }

    public static RowIterator execute(String statement, Session session, String commonPathPrefix, Filter filter) {
        GQL query = new GQL(statement, session, commonPathPrefix, filter);
        return query.execute();
    }

    public static void parse(String statement, Session session, ParserCallback callback) throws RepositoryException {
        GQL query = new GQL(statement, session, null, null);
        query.parse(callback);
    }

    private RowIterator execute() {
        try {
            String stmt = this.translateStatement();
            QueryManager qm = this.session.getWorkspace().getQueryManager();
            RowIterator nodes = qm.createQuery(stmt, "xpath").execute().getRows();
            if (this.filter != null) {
                nodes = new FilteredRowIterator(nodes);
            }
            if (this.offset > 0) {
                try {
                    nodes.skip((long)this.offset);
                }
                catch (NoSuchElementException e) {
                    return RowIteratorAdapter.EMPTY;
                }
            }
            if (this.numResults == Integer.MAX_VALUE) {
                return new RowIterAdapter((RangeIterator)nodes, nodes.getSize());
            }
            ArrayList<Row> resultRows = new ArrayList<Row>();
            while (this.numResults-- > 0 && nodes.hasNext()) {
                resultRows.add(nodes.nextRow());
            }
            return new RowIterAdapter(resultRows, nodes.getSize());
        }
        catch (RepositoryException e) {
            return RowIteratorAdapter.EMPTY;
        }
    }

    private String translateStatement() throws RepositoryException {
        this.parse(new ParserCallback(){

            public void term(String property, String value, boolean optional) throws RepositoryException {
                GQL.this.pushExpression(property, value, optional);
            }
        });
        StringBuffer stmt = new StringBuffer();
        stmt.append(this.pathConstraint);
        RequiredExpression predicate = new RequiredExpression();
        if (this.typeConstraints != null) {
            predicate.addOperand(this.typeConstraints);
        }
        Iterator it = this.conditions.iterator();
        while (it.hasNext()) {
            predicate.addOperand((Expression)it.next());
        }
        if (predicate.getSize() > 0) {
            stmt.append("[");
        }
        predicate.toString(stmt);
        if (predicate.getSize() > 0) {
            stmt.append("]");
        }
        stmt.append(" ");
        this.orderBy.toString(stmt);
        return stmt.toString();
    }

    private void collectNodeTypes(String ntName) throws RepositoryException {
        NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
        String[] resolvedNames = this.resolveNodeTypeName(ntName);
        for (int i = 0; i < resolvedNames.length; ++i) {
            try {
                NodeType base = ntMgr.getNodeType(resolvedNames[i]);
                if (base.isMixin()) {
                    this.addTypeConstraint(new MixinComparision(resolvedNames[i]));
                } else {
                    this.addTypeConstraint(new PrimaryTypeComparision(resolvedNames[i]));
                }
                NodeTypeIterator allTypes = ntMgr.getAllNodeTypes();
                while (allTypes.hasNext()) {
                    NodeType nt = allTypes.nextNodeType();
                    NodeType[] superTypes = nt.getSupertypes();
                    if (!Arrays.asList(superTypes).contains(base)) continue;
                    if (nt.isMixin()) {
                        this.addTypeConstraint(new MixinComparision(nt.getName()));
                        continue;
                    }
                    this.addTypeConstraint(new PrimaryTypeComparision(nt.getName()));
                }
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                this.addTypeConstraint(new PrimaryTypeComparision(resolvedNames[i]));
            }
        }
    }

    private void addTypeConstraint(Expression expr) {
        if (this.typeConstraints == null) {
            this.typeConstraints = new OptionalExpression();
        }
        this.typeConstraints.addOperand(expr);
    }

    private String[] resolveNodeTypeName(String ntName) throws RepositoryException {
        String[] names;
        if (GQL.isPrefixed(ntName)) {
            names = new String[]{ntName};
        } else {
            if (this.ntNames == null) {
                NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
                this.ntNames = new HashMap();
                NodeTypeIterator it = ntMgr.getAllNodeTypes();
                while (it.hasNext()) {
                    String[] nts;
                    String name;
                    String localName = name = it.nextNodeType().getName();
                    int idx = name.indexOf(58);
                    if (idx != -1) {
                        localName = name.substring(idx + 1);
                    }
                    if ((nts = (String[])this.ntNames.get(localName)) == null) {
                        nts = new String[]{name};
                    } else {
                        String[] tmp = new String[nts.length + 1];
                        System.arraycopy(nts, 0, tmp, 0, nts.length);
                        tmp[nts.length] = name;
                        nts = tmp;
                    }
                    this.ntNames.put(localName, nts);
                }
            }
            if ((names = (String[])this.ntNames.get(ntName)) == null) {
                names = new String[]{ntName};
            }
        }
        return names;
    }

    private String resolvePropertyName(String name) throws RepositoryException {
        String pn;
        if (GQL.isPrefixed(name)) {
            return name;
        }
        if (this.propertyNames == null) {
            this.propertyNames = new HashMap();
            NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = ntMgr.getAllNodeTypes();
            while (it.hasNext()) {
                NodeType nt = it.nextNodeType();
                PropertyDefinition[] defs = nt.getDeclaredPropertyDefinitions();
                for (int i = 0; i < defs.length; ++i) {
                    String pn2 = defs[i].getName();
                    if (pn2.equals("*")) continue;
                    String localName = pn2;
                    int idx = pn2.indexOf(58);
                    if (idx != -1) {
                        localName = pn2.substring(idx + 1);
                    }
                    this.propertyNames.put(localName, pn2);
                }
            }
        }
        if ((pn = (String)this.propertyNames.get(name)) != null) {
            return pn;
        }
        return name;
    }

    private String resolveChildNodeName(String name) throws RepositoryException {
        String cnn;
        if (GQL.isPrefixed(name)) {
            return name;
        }
        if (this.childNodeNames == null) {
            this.childNodeNames = new HashMap();
            NodeTypeManager ntMgr = this.session.getWorkspace().getNodeTypeManager();
            NodeTypeIterator it = ntMgr.getAllNodeTypes();
            while (it.hasNext()) {
                NodeType nt = it.nextNodeType();
                NodeDefinition[] defs = nt.getDeclaredChildNodeDefinitions();
                for (int i = 0; i < defs.length; ++i) {
                    String cnn2 = defs[i].getName();
                    if (cnn2.equals("*")) continue;
                    String localName = cnn2;
                    int idx = cnn2.indexOf(58);
                    if (idx != -1) {
                        localName = cnn2.substring(idx + 1);
                    }
                    this.childNodeNames.put(localName, cnn2);
                }
            }
        }
        if ((cnn = (String)this.childNodeNames.get(name)) != null) {
            return cnn;
        }
        return name;
    }

    private static boolean isPrefixed(String name) {
        return name.indexOf(58) != -1;
    }

    private void parse(ParserCallback callback) throws RepositoryException {
        char[] stmt = new char[this.statement.length() + 1];
        this.statement.getChars(0, this.statement.length(), stmt, 0);
        stmt[this.statement.length()] = 32;
        StringBuffer property = new StringBuffer();
        StringBuffer value = new StringBuffer();
        boolean quoted = false;
        boolean optional = false;
        block6: for (int i = 0; i < stmt.length; ++i) {
            char c = stmt[i];
            switch (c) {
                case ' ': {
                    if (quoted) {
                        value.append(c);
                        continue block6;
                    }
                    if (value.length() <= 0) continue block6;
                    String p = property.toString();
                    String v = value.toString();
                    if (v.equals(OR) && p.length() == 0) {
                        optional = true;
                    } else {
                        callback.term(p, v, optional);
                        optional = false;
                    }
                    property.setLength(0);
                    value.setLength(0);
                    continue block6;
                }
                case ':': {
                    if (quoted) {
                        value.append(c);
                        continue block6;
                    }
                    if (property.length() == 0) {
                        property.append(value);
                        value.setLength(0);
                        continue block6;
                    }
                    value.append(c);
                    continue block6;
                }
                case '\"': {
                    quoted = !quoted;
                    continue block6;
                }
                case '!': 
                case '\'': 
                case '*': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '}': 
                case '~': {
                    continue block6;
                }
                default: {
                    value.append(c);
                }
            }
        }
    }

    private void pushExpression(String property, String value, boolean optional) throws RepositoryException {
        if (property.equals(PATH)) {
            String path = value.startsWith("/") ? "/jcr:root" + value : value;
            this.pathConstraint = ISO9075.encodePath((String)path) + "//*";
        } else if (property.equals(TYPE)) {
            String[] nts = Text.explode((String)value, (int)44);
            if (nts.length > 0) {
                for (int i = 0; i < nts.length; ++i) {
                    this.collectNodeTypes(nts[i]);
                }
            }
        } else if (property.equals(ORDER)) {
            this.orderBy = new OrderByExpression(value);
        } else if (property.equals(LIMIT)) {
            int idx = value.indexOf("..");
            if (idx != -1) {
                String lower = value.substring(0, idx);
                String uppper = value.substring(idx + "..".length());
                if (lower.length() > 0) {
                    try {
                        this.offset = Integer.parseInt(lower);
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (uppper.length() > 0) {
                    try {
                        this.numResults = Integer.parseInt(uppper) - this.offset;
                        if (this.numResults < 0) {
                            this.numResults = Integer.MAX_VALUE;
                        }
                    }
                    catch (NumberFormatException e) {}
                }
            } else {
                try {
                    this.numResults = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {}
            }
        } else {
            ContainsExpression expr = new ContainsExpression(property, value);
            if (optional) {
                Expression last = (Expression)this.conditions.get(this.conditions.size() - 1);
                if (last instanceof OptionalExpression) {
                    ((OptionalExpression)last).addOperand(expr);
                } else {
                    OptionalExpression op = new OptionalExpression();
                    op.addOperand(last);
                    op.addOperand(expr);
                    this.conditions.set(this.conditions.size() - 1, op);
                }
            } else {
                this.conditions.add(expr);
            }
        }
    }

    private static String checkProhibited(String value) {
        if (value.startsWith("-")) {
            return value.substring(1);
        }
        return value;
    }

    private final class FilteredRowIterator
    implements RowIterator {
        private final RowIterator rows;
        private Row next;
        private long position = 0L;

        public FilteredRowIterator(RowIterator rows) {
            this.rows = rows;
            this.fetchNext();
        }

        public void skip(long skipNum) {
            while (skipNum-- > 0L && this.hasNext()) {
                this.nextRow();
            }
        }

        public long getSize() {
            return -1L;
        }

        public long getPosition() {
            return this.position;
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Row nextRow() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                Row row = this.next;
                return row;
            }
            finally {
                ++this.position;
                this.fetchNext();
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        private void fetchNext() {
            this.next = null;
            while (this.next == null && this.rows.hasNext()) {
                Row r = this.rows.nextRow();
                try {
                    if (!GQL.this.filter.include(r)) continue;
                    this.next = r;
                    return;
                }
                catch (RepositoryException repositoryException) {
                }
            }
        }
    }

    private final class RowIterAdapter
    extends RowIteratorAdapter {
        private final long size;

        public RowIterAdapter(RangeIterator rangeIterator, long size) {
            super(rangeIterator);
            this.size = size;
        }

        public RowIterAdapter(Collection collection, long size) {
            super(collection);
            this.size = size;
        }

        public Row nextRow() {
            Row next = super.nextRow();
            next = GQL.this.commonPathPrefix != null ? new RowAdapter(next, GQL.this.commonPathPrefix) : new RowAdapter(next, ".");
            return next;
        }

        public long getSize() {
            return this.size;
        }
    }

    private static final class RowAdapter
    implements Row {
        private final Row row;
        private final String excerptPath;

        private RowAdapter(Row row, String excerptPath) {
            this.row = row;
            this.excerptPath = excerptPath;
        }

        public Value[] getValues() throws RepositoryException {
            return this.row.getValues();
        }

        public Value getValue(String propertyName) throws ItemNotFoundException, RepositoryException {
            if (propertyName.startsWith(GQL.REP_EXCERPT)) {
                propertyName = "rep:excerpt(" + this.excerptPath + ")";
            }
            return this.row.getValue(propertyName);
        }
    }

    private class OrderByExpression
    implements Expression {
        private final String value;

        OrderByExpression() {
            this.value = "";
        }

        OrderByExpression(String value) {
            this.value = value;
        }

        public void toString(StringBuffer buffer) throws RepositoryException {
            buffer.append("order by ");
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(Text.explode((String)this.value, (int)44)));
            int length = buffer.length();
            String comma = "";
            for (String name : names) {
                boolean asc;
                if (name.startsWith("-")) {
                    name = name.substring(1);
                    asc = false;
                } else if (name.startsWith("+")) {
                    name = name.substring(1);
                    asc = true;
                } else {
                    asc = true;
                }
                if (name.length() <= 0) continue;
                buffer.append(comma);
                name = GQL.this.resolvePropertyName(name);
                buffer.append("@").append(ISO9075.encode((String)name));
                if (!asc) {
                    buffer.append(" ").append(GQL.DESCENDING);
                }
                comma = ", ";
            }
            if (buffer.length() == length) {
                this.defaultOrderBy(buffer);
            }
        }

        private void defaultOrderBy(StringBuffer buffer) {
            buffer.append("@").append(GQL.JCR_SCORE).append(" ").append(GQL.DESCENDING);
        }
    }

    private class OptionalExpression
    extends NAryExpression {
        private OptionalExpression() {
        }

        protected String getOperation() {
            return " or ";
        }
    }

    private class RequiredExpression
    extends NAryExpression {
        private RequiredExpression() {
        }

        protected String getOperation() {
            return " and ";
        }
    }

    private abstract class NAryExpression
    implements Expression {
        private final List operands = new ArrayList();

        private NAryExpression() {
        }

        public void toString(StringBuffer buffer) throws RepositoryException {
            if (this.operands.size() > 1) {
                buffer.append("(");
            }
            String op = "";
            Iterator it = this.operands.iterator();
            while (it.hasNext()) {
                buffer.append(op);
                Expression expr = (Expression)it.next();
                expr.toString(buffer);
                op = this.getOperation();
            }
            if (this.operands.size() > 1) {
                buffer.append(")");
            }
        }

        void addOperand(Expression expr) {
            this.operands.add(expr);
        }

        int getSize() {
            return this.operands.size();
        }

        protected abstract String getOperation();
    }

    private final class ContainsExpression
    extends PropertyExpression {
        private boolean prohibited;

        ContainsExpression(String property, String value) {
            super(property, GQL.checkProhibited(value.toLowerCase()));
            this.prohibited = false;
            this.prohibited = value.startsWith("-");
        }

        public void toString(StringBuffer buffer) throws RepositoryException {
            if (this.prohibited) {
                buffer.append("not(");
            }
            buffer.append(GQL.JCR_CONTAINS).append("(");
            if (this.property.length() == 0) {
                if (GQL.this.commonPathPrefix == null) {
                    buffer.append(".");
                } else {
                    buffer.append(ISO9075.encodePath((String)GQL.this.commonPathPrefix));
                }
            } else {
                String[] parts = Text.explode((String)this.property, (int)47);
                if (GQL.this.commonPathPrefix != null) {
                    buffer.append(ISO9075.encodePath((String)GQL.this.commonPathPrefix));
                    buffer.append("/");
                }
                String slash = "";
                for (int i = 0; i < parts.length; ++i) {
                    if (i == parts.length - 1) {
                        if (!parts[i].equals(".")) {
                            buffer.append(slash);
                            buffer.append("@");
                            buffer.append(ISO9075.encode((String)GQL.this.resolvePropertyName(parts[i])));
                        }
                    } else {
                        buffer.append(slash);
                        buffer.append(ISO9075.encode((String)GQL.this.resolveChildNodeName(parts[i])));
                    }
                    slash = "/";
                }
            }
            buffer.append(", '");
            if (this.value.indexOf(32) != -1) {
                buffer.append('\"').append(this.value).append('\"');
            } else {
                buffer.append(this.value);
            }
            buffer.append("')");
            if (this.prohibited) {
                buffer.append(")");
            }
        }
    }

    private class PrimaryTypeComparision
    extends ValueComparison {
        PrimaryTypeComparision(String value) {
            super(GQL.JCR_PRIMARY_TYPE, value);
        }
    }

    private class MixinComparision
    extends ValueComparison {
        MixinComparision(String value) {
            super(GQL.JCR_MIXIN_TYPES, value);
        }
    }

    private abstract class ValueComparison
    extends PropertyExpression {
        ValueComparison(String property, String value) {
            super(property, value);
        }

        public void toString(StringBuffer buffer) throws RepositoryException {
            buffer.append("@");
            buffer.append(ISO9075.encode((String)GQL.this.resolvePropertyName(this.property)));
            buffer.append("='").append(this.value).append("'");
        }
    }

    private abstract class PropertyExpression
    implements Expression {
        protected final String property;
        protected final String value;

        PropertyExpression(String property, String value) {
            this.property = property;
            this.value = value;
        }
    }

    private static interface Expression {
        public void toString(StringBuffer var1) throws RepositoryException;
    }

    public static interface ParserCallback {
        public void term(String var1, String var2, boolean var3) throws RepositoryException;
    }

    public static interface Filter {
        public boolean include(Row var1) throws RepositoryException;
    }
}

