/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.commons.SlingRepositoryException;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.designer.Style;
import com.day.cq.wcm.commons.RequestHelper;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.image.Layer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;

public abstract class AbstractImageServlet
extends SlingSafeMethodsServlet {
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            if (this.checkModifiedSince(request, response)) {
                return;
            }
            String type = this.getImageType(request.getRequestPathInfo().getExtension());
            if (type == null) {
                response.sendError(404, "Image type not supported");
                return;
            }
            ImageContext context = new ImageContext(request, type);
            Layer layer = this.createLayer(context);
            this.writeLayer(request, response, context, layer);
        }
        catch (RepositoryException e) {
            throw new SlingRepositoryException(e);
        }
    }

    protected void writeLayer(SlingHttpServletRequest request, SlingHttpServletResponse response, ImageContext context, Layer layer) throws IOException, RepositoryException {
        response.setContentType(this.getImageType());
        int size = layer.getHeight() * layer.getWidth();
        if (size < 0x100000) {
            ByteArrayOutputStream out = new ByteArrayOutputStream(size);
            layer.write(this.getImageType(), this.getImageQuality(), (OutputStream)out);
            byte[] bytes = out.toByteArray();
            response.setContentLength(bytes.length);
            response.getOutputStream().write(bytes);
        } else {
            layer.write(this.getImageType(), this.getImageQuality(), (OutputStream)response.getOutputStream());
        }
    }

    protected String getImageType() {
        return "image/png";
    }

    protected String getImageType(String ext) {
        if ("png".equals(ext)) {
            return "image/png";
        }
        if ("gif".equals(ext)) {
            return "image/gif";
        }
        if ("jpg".equals(ext) || "jpeg".equals(ext)) {
            return "image/jpg";
        }
        return null;
    }

    protected double getImageQuality() {
        return 1.0;
    }

    protected boolean checkModifiedSince(SlingHttpServletRequest req, SlingHttpServletResponse resp) {
        return RequestHelper.handleIfModifiedSince((HttpServletRequest)req, (HttpServletResponse)resp, (Node)req.getResource().adaptTo(Node.class));
    }

    protected abstract Layer createLayer(ImageContext var1) throws RepositoryException, IOException;

    public static class ImageContext {
        public final SlingHttpServletRequest request;
        public final Resource resource;
        public final ResourceResolver resolver;
        public final Node node;
        public final ValueMap properties;
        public final Style style;
        public final Page currentPage;
        public final ValueMap pageProperties;
        public final Component component;
        public final String requestImageType;

        public ImageContext(SlingHttpServletRequest request, String type) {
            this.request = request;
            this.resource = request.getResource();
            this.resolver = request.getResourceResolver();
            this.node = (Node)this.resource.adaptTo(Node.class);
            ValueMap props = (ValueMap)this.resource.adaptTo(ValueMap.class);
            this.properties = props == null ? ValueMap.EMPTY : props;
            this.style = WCMUtils.getStyle(request);
            PageManager pageManager = (PageManager)this.resolver.adaptTo(PageManager.class);
            this.currentPage = pageManager.getContainingPage(this.resource);
            this.pageProperties = this.currentPage == null ? ValueMap.EMPTY : this.currentPage.getProperties();
            this.component = WCMUtils.getComponent(this.resource);
            this.requestImageType = type;
        }
    }
}

