/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.tagging.Tag;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentContext;
import com.day.cq.wcm.api.components.ComponentManager;
import com.day.cq.wcm.api.designer.Design;
import com.day.cq.wcm.api.designer.Designer;
import com.day.cq.wcm.api.designer.Style;
import com.day.text.Text;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WCMUtils {
    private static final Logger log = LoggerFactory.getLogger(WCMUtils.class);
    public static final String DEBUG_PARAM = "debug";

    private WCMUtils() {
    }

    public static Component getComponent(Resource resource) {
        if (resource == null) {
            log.debug("Resource to get component from must not be null");
            return null;
        }
        ComponentManager compMgr = (ComponentManager)resource.getResourceResolver().adaptTo(ComponentManager.class);
        if (compMgr == null) {
            log.warn("Unable to retrieve component manager for {}", (Object)resource);
            return null;
        }
        return compMgr.getComponentOfResource(resource);
    }

    public static String getInheritedProperty(Page page, ResourceResolver resolver, String name) {
        String value = null;
        while (value == null && page != null) {
            value = (String)page.getProperties().get(name, String.class);
            if (value != null) continue;
            Resource res = resolver.getResource(page.getPath() + "/..");
            page = res == null ? null : (Page)res.adaptTo(Page.class);
        }
        return value;
    }

    public static Style getStyle(SlingHttpServletRequest request) {
        Design design;
        PageManager pMgr;
        ComponentContext ctx = WCMUtils.getComponentContext((ServletRequest)request);
        Page page = ctx == null ? null : ctx.getPage();
        Resource res = request.getResource();
        if (page == null && (page = (pMgr = (PageManager)request.getResourceResolver().adaptTo(PageManager.class)).getContainingPage(res)) == null) {
            return null;
        }
        Designer d = (Designer)request.getResourceResolver().adaptTo(Designer.class);
        String designId = "";
        String cellPath = "";
        String suffix = request.getRequestPathInfo().getSuffix();
        if (suffix != null && suffix.length() > 0) {
            int idx;
            if (!suffix.startsWith("/")) {
                suffix = "/" + suffix;
            }
            if ((idx = suffix.indexOf("/-/")) >= 0) {
                designId = suffix.substring(0, idx);
                cellPath = suffix.substring(idx + 3);
            } else {
                designId = suffix;
            }
        }
        if (designId.length() > 0 && d.hasDesign(designId)) {
            design = d.getDesign(designId);
        } else {
            cellPath = "";
            design = d.getDesign(page);
        }
        if (design == null) {
            return null;
        }
        if (cellPath.length() > 0) {
            return design.getStyle(cellPath);
        }
        if (ctx == null) {
            return design.getStyle(Text.getName((String)res.getPath()));
        }
        return design.getStyle(ctx.getCell());
    }

    public static ComponentContext getComponentContext(ServletRequest request) {
        return (ComponentContext)request.getAttribute("com.day.cq.wcm.componentcontext");
    }

    public static Node getCurrentNode(SlingHttpServletRequest request, boolean create) {
        Resource res = request.getResource();
        Node node = (Node)res.adaptTo(Node.class);
        if (node == null && create) {
            String path = res.getPath();
            int idx = path.lastIndexOf(47);
            String name = path.substring(idx + 1);
            path = path.substring(0, idx);
            try {
                Node parent = (Node)((Session)request.getResourceResolver().adaptTo(Session.class)).getItem(path);
                node = parent.addNode(name);
                node.setProperty("sling:resourceType", res.getResourceType());
                parent.save();
            }
            catch (RepositoryException e) {
                log.error("Unable to create new node for " + res);
            }
        }
        return node;
    }

    public static Node getNode(Resource resource) {
        if (resource != null) {
            return (Node)resource.adaptTo(Node.class);
        }
        return null;
    }

    public static String getKeywords(Page page) {
        StringBuffer keywords = new StringBuffer();
        Tag[] tags = page.getTags();
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                keywords.append(", ");
            }
            keywords.append(tags[i].getTitle());
        }
        return keywords.toString();
    }
}

