/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHelper {
    private static final Logger log = LoggerFactory.getLogger(RequestHelper.class);

    public static boolean handleIfModifiedSince(HttpServletRequest req, HttpServletResponse resp, ValueMap properties) {
        Calendar lastMod = (Calendar)properties.get("jcr:lastModified", Calendar.class);
        if (lastMod == null) {
            lastMod = (Calendar)properties.get("cq:lastModified", Calendar.class);
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("If-Modified-Since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod.getTimeInMillis());
        }
        return false;
    }

    public static boolean handleIfModifiedSince(HttpServletRequest req, HttpServletResponse resp, Node node) {
        Calendar lastMod = null;
        try {
            while (node.getDepth() > 0 && lastMod == null) {
                if (node.hasProperty("jcr:lastModified")) {
                    lastMod = node.getProperty("jcr:lastModified").getDate();
                    continue;
                }
                if (node.hasProperty("cq:lastModified")) {
                    lastMod = node.getProperty("cq:lastModified").getDate();
                    continue;
                }
                node = node.getParent();
            }
        }
        catch (RepositoryException e) {
            log.warn("Error while searching for last modified property: " + (Object)((Object)e));
            return false;
        }
        if (lastMod != null) {
            long ims;
            long modTime = lastMod.getTimeInMillis() / 1000L;
            if (modTime <= (ims = req.getDateHeader("If-Modified-Since") / 1000L)) {
                resp.setStatus(304);
                return true;
            }
            resp.setDateHeader("Last-Modified", lastMod.getTimeInMillis());
        }
        return false;
    }
}

