/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.commons;

import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.WCMException;
import com.day.text.Text;
import java.util.StringTokenizer;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;

public class UGCUtil {
    public static String resourceToUGCPath(Resource resource) {
        StringBuilder path = new StringBuilder("/content/usergenerated");
        path.append(UGCUtil.getPagePath(resource));
        path.append("/").append("jcr:content");
        path.append("/").append(UGCUtil.getIdFromResource(resource));
        return path.toString();
    }

    public static String UGCToResourcePath(Resource resource) {
        String pagePath = StringUtils.substringAfter((String)resource.getPath(), (String)"/content/usergenerated");
        return resource.getResourceResolver().map(pagePath);
    }

    public static String getPagePath(Resource resource) {
        return StringUtils.substringBefore((String)resource.getPath(), (String)"/jcr:content");
    }

    public static String prepareUserGeneratedContent(ResourceResolver resolver, String pagePath) throws WCMException {
        String ugcPagePath = "/content/usergenerated";
        StringTokenizer pathElems = new StringTokenizer(pagePath, "/");
        while (pathElems.hasMoreTokens()) {
            if (resolver.getResource(ugcPagePath = ugcPagePath + "/" + pathElems.nextToken()) != null) continue;
            if (ugcPagePath.equals("/content/usergenerated/content")) {
                UGCUtil.createNode(resolver, ugcPagePath, "sling:Folder");
                UGCUtil.save(resolver);
                continue;
            }
            UGCUtil.createPage(resolver, ugcPagePath, null, null, null, null);
        }
        return ugcPagePath;
    }

    public static String getIdFromResource(Resource resource) {
        return StringUtils.substringBefore((String)ResourceUtil.getName((Resource)resource), (String)".");
    }

    protected static void save(ResourceResolver resolver) throws WCMException, IllegalArgumentException {
        Session session = (Session)resolver.adaptTo(Session.class);
        if (session == null) {
            throw new IllegalArgumentException("resolver must be adaptable to session");
        }
        try {
            session.save();
        }
        catch (RepositoryException re) {
            throw new WCMException("failed to save changes", (Throwable)re);
        }
    }

    protected static Page createPage(ResourceResolver resolver, String path, String template, String resourceTypeProp, String resourceType, String title) throws WCMException {
        String parentPath = Text.getRelativeParent((String)path, (int)1);
        String name = Text.getName((String)path);
        return UGCUtil.createPage(resolver, parentPath, name, template, resourceTypeProp, resourceType, title);
    }

    protected static Page createPage(ResourceResolver resolver, String parentPath, String name, String template, String resourceTypeProp, String resourceType, String title) throws WCMException {
        Throwable e;
        try {
            if (resolver.getResource(parentPath) == null) {
                UGCUtil.createNode(resolver, parentPath, "nt:unstructured");
                UGCUtil.save(resolver);
            }
            if (!JcrUtil.isValidName((String)name)) {
                name = JcrUtil.createValidName((String)name, (String[])JcrUtil.HYPHEN_LABEL_CHAR_MAPPING);
            }
            Page page = ((PageManager)resolver.adaptTo(PageManager.class)).create(parentPath, name, template, title);
            if (StringUtils.isNotEmpty((String)resourceTypeProp)) {
                ((Node)page.getContentResource().adaptTo(Node.class)).setProperty(resourceTypeProp, resourceType);
            }
            return page;
        }
        catch (RepositoryException re) {
            e = re;
        }
        catch (WCMException wcme) {
            e = wcme;
        }
        throw new WCMException("failed to create page", e);
    }

    protected static Node createNode(ResourceResolver resolver, String path, String nodeType) throws WCMException {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try {
            Node root = ((Session)resolver.adaptTo(Session.class)).getRootNode();
            StringTokenizer names = new StringTokenizer(Text.getRelativeParent((String)path, (int)1), "/");
            while (names.hasMoreTokens()) {
                String name = names.nextToken();
                if (!root.hasNode(name)) {
                    root.addNode(name);
                }
                root = root.getNode(name);
            }
            return root.addNode(Text.getName((String)path), nodeType);
        }
        catch (Exception e) {
            throw new WCMException("failed to create node", (Throwable)e);
        }
    }
}

