/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.api.components.ComponentContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsHelper {
    private static final String REQ_ATTR_GLOBAL_LOAD_RSRC = "cq5.form.loadmap";
    private static final String REQ_ATTR_CLIENT_VALIDATION = "cq5.form.clientvalidation";
    private static final String REQ_ATTR_FORMID = "cq5.form.id";
    private static final String REQ_ATTR_WRITTEN_JAVASCRIPT = "cq5.form.javascript";
    private static final String REQ_ATTR_ACTION = "cq5.form.action";
    private static final String REQ_ATTR_IS_INIT = "cq5.form.init";

    private FormsHelper() {
    }

    public static void startForm(SlingHttpServletRequest req, SlingHttpServletResponse response, JspWriter out) throws IOException, ServletException {
        Resource resource = req.getResource();
        FormsHelper.initialize(req, resource);
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String actionType = (String)properties.get("actionType", (Object)"");
        if (actionType.length() != 0) {
            out.flush();
            FormsHelper.includeResource(req, response, req.getResource(), "actions." + actionType + ".init");
        }
        if (req.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC) == null) {
            Resource loadResource = null;
            String loadPath = (String)properties.get("loadPath", null);
            if (loadPath != null) {
                loadResource = resource.getResourceResolver().getResource(loadPath);
            }
            FormsHelper.setFormLoadResource(req, loadResource);
        }
        FormsHelper.writeJavaScript(req, response, resource, out);
    }

    private static void initialize(SlingHttpServletRequest request, Resource formResource) {
        ValueMap properties = formResource == null ? ValueMap.EMPTY : ResourceUtil.getValueMap((Resource)formResource);
        Boolean clientValidation = (Boolean)properties.get("clientValidation", (Object)Boolean.FALSE);
        request.setAttribute(REQ_ATTR_CLIENT_VALIDATION, (Object)clientValidation);
        request.setAttribute(REQ_ATTR_FORMID, properties.get("formid", (Object)"new_form"));
        request.setAttribute(REQ_ATTR_IS_INIT, (Object)"true");
    }

    private static void checkInit(SlingHttpServletRequest request) {
        if (request.getAttribute(REQ_ATTR_IS_INIT) == null) {
            Resource formStart = FormsHelper.searchFormStart(request.getResource());
            FormsHelper.initialize(request, formStart);
        }
    }

    private static Resource searchFormStart(Resource resource) {
        Resource current;
        if (ResourceUtil.getName((Resource)resource).equals("jcr:content")) {
            return null;
        }
        if (resource.getPath().lastIndexOf("/") == 0) {
            return null;
        }
        Resource parent = ResourceUtil.getParent((Resource)resource);
        Iterator i = ResourceUtil.listChildren((Resource)parent);
        while (i.hasNext() && !(current = (Resource)i.next()).getPath().equals(resource.getPath())) {
            if (!current.getResourceType().equals("foundation/components/form/start")) continue;
            return current;
        }
        return FormsHelper.searchFormStart(parent);
    }

    public static void endForm(SlingHttpServletRequest req) {
        FormsHelper.setFormLoadResource(req, null);
        req.removeAttribute(REQ_ATTR_CLIENT_VALIDATION);
        req.removeAttribute(REQ_ATTR_FORMID);
        req.removeAttribute(REQ_ATTR_IS_INIT);
    }

    public static void setActionPath(SlingHttpServletRequest req, String path) {
        req.setAttribute(REQ_ATTR_ACTION, (Object)path);
    }

    public static String getActionPath(SlingHttpServletRequest req) {
        return (String)req.getAttribute(REQ_ATTR_ACTION);
    }

    public static void setFormLoadResource(SlingHttpServletRequest req, Resource rsrc) {
        req.removeAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
        if (rsrc != null) {
            ValueMap map = ResourceUtil.getValueMap((Resource)rsrc);
            req.setAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC, (Object)map);
        }
    }

    public static String getFormsPreCheckMethodName(SlingHttpServletRequest req) {
        return "cq5forms_preCheck_" + FormsHelper.getFormId(req);
    }

    private static void writeJavaScript(SlingHttpServletRequest req, SlingHttpServletResponse response, Resource formResource, JspWriter out) throws IOException, ServletException {
        if (FormsHelper.doClientValidation(req)) {
            if (req.getAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT) == null) {
                req.setAttribute(REQ_ATTR_WRITTEN_JAVASCRIPT, (Object)true);
                out.println("<script type=\"text/javascript\">");
                out.println("  function cq5forms_showMsg(fid, field, msg) {    alert(msg);    document.forms[fid].elements[field].focus();  }");
                out.println("</script>");
            }
            out.println("<script type=\"text/javascript\">");
            out.println("  function " + FormsHelper.getFormsPreCheckMethodName(req) + "(submitid) {");
            out.println("    var dMsgs = \"Please fill out the required field.\";");
            Iterator<Resource> iter = FormsHelper.getFormElements(formResource);
            while (iter.hasNext()) {
                Resource element = iter.next();
                out.flush();
                FormsHelper.includeResource(req, response, element, "clientvalidation");
            }
            out.println("    return true;");
            out.println("  }");
            out.println("</script>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void includeResource(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, String selectorString) throws IOException, ServletException {
        Object oldValue = request.getAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
        try {
            request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, (Object)"true");
            RequestDispatcherOptions options = new RequestDispatcherOptions();
            options.setReplaceSelectors(selectorString);
            request.getRequestDispatcher(resource, options).include((ServletRequest)new RequestWrapper(request), (ServletResponse)response);
        }
        finally {
            if (oldValue == null) {
                request.removeAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE);
            } else {
                request.setAttribute(ComponentContext.BYPASS_COMPONENT_HANDLING_ON_INCLUDE_ATTRIBUTE, oldValue);
            }
        }
    }

    public static ValueMap getFormValues(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (ValueMap)req.getAttribute(REQ_ATTR_GLOBAL_LOAD_RSRC);
    }

    public static boolean doClientValidation(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        Boolean value = (Boolean)req.getAttribute(REQ_ATTR_CLIENT_VALIDATION);
        if (value == null) {
            value = Boolean.FALSE;
        }
        return value;
    }

    public static String getFormId(SlingHttpServletRequest req) {
        FormsHelper.checkInit(req);
        return (String)req.getAttribute(REQ_ATTR_FORMID);
    }

    public static String getParameterName(Resource rsrc) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)rsrc);
        String name = (String)properties.get("name", (Object)"");
        if (name.length() == 0) {
            name = ResourceUtil.getName((Resource)rsrc);
            name = FormsHelper.filterElementName(name);
        }
        return name;
    }

    public static Iterator<Resource> getFormElements(Resource formResource) {
        ArrayList<Resource> list = new ArrayList<Resource>();
        Iterator iter = ResourceUtil.listChildren((Resource)ResourceUtil.getParent((Resource)formResource));
        while (!((Resource)iter.next()).getPath().equals(formResource.getPath())) {
        }
        FormsHelper.collectFormElements(list, iter);
        return list.iterator();
    }

    private static boolean collectFormElements(List<Resource> list, Iterator<Resource> iter) {
        Resource n;
        boolean stop = false;
        while (!stop && iter.hasNext() && !"foundation/components/form/end".equals((n = iter.next()).getResourceType())) {
            if ("foundation/components/form/element".equals(n.getResourceType())) {
                list.add(n);
                continue;
            }
            Iterator cI = ResourceUtil.listChildren((Resource)n);
            if (cI == null) continue;
            stop = FormsHelper.collectFormElements(list, cI);
        }
        return stop;
    }

    private static String filterElementName(String nodeName) {
        StringBuffer sb = new StringBuffer();
        int lastAdded = 0;
        nodeName = nodeName.toLowerCase();
        for (int i = 0; i < nodeName.length(); ++i) {
            char c = nodeName.charAt(i);
            int toAdd = c;
            if ("abcdefghijklmnopqrstuvwxyz0123456789_ABCDEFGHIJKLMNOPQRSTUVWXYZ./:-".indexOf(c) < 0) {
                if (lastAdded == 95) continue;
                toAdd = 95;
            } else if (i == 0 && Character.isDigit(c)) {
                sb.append('_');
            }
            sb.append((char)toAdd);
            lastAdded = toAdd;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static class RequestWrapper
    extends SlingHttpServletRequestWrapper {
        public RequestWrapper(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

