/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.wcm.foundation.forms.FormsManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.JcrResourceResolverFactory;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormsManagerImpl
implements FormsManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<EventListenerWrapper> listeners = new ArrayList<EventListenerWrapper>();
    private static final String ACTION_PATH = "foundation/components/form/start/actions";
    private static final String CONSTRAINT_PATH = "foundation/components/form/element/constraints";
    private String[] constraintSearchPaths;
    private String[] actionSearchPaths;
    private SlingRepository repository;
    private JcrResourceResolverFactory resolverFactory;
    private Map<String, String> actions;
    private Map<String, String> constraints;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.actions == null) {
                this.searchFormElements();
            }
            return this.actions.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<String> getConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            if (this.constraints == null) {
                this.searchFormElements();
            }
            return this.constraints.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void activate(ComponentContext context) throws RepositoryException {
        EventListenerWrapper wrapper;
        this.session = this.repository.loginAdministrative(this.repository.getDefaultWorkspace());
        ResourceResolver resourceResolver = this.resolverFactory.getResourceResolver(this.session);
        String[] searchPaths = resourceResolver.getSearchPath();
        this.actionSearchPaths = new String[searchPaths.length];
        this.constraintSearchPaths = new String[searchPaths.length];
        for (int i = 0; i < searchPaths.length; ++i) {
            this.actionSearchPaths[i] = searchPaths[i] + ACTION_PATH;
            this.constraintSearchPaths[i] = searchPaths[i] + CONSTRAINT_PATH;
        }
        for (String path : this.actionSearchPaths) {
            wrapper = new EventListenerWrapper(this, 1);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)wrapper, 31, path, false, null, null, true);
            this.listeners.add(wrapper);
        }
        for (String path : this.constraintSearchPaths) {
            wrapper = new EventListenerWrapper(this, 2);
            this.session.getWorkspace().getObservationManager().addEventListener((EventListener)wrapper, 31, path, false, null, null, true);
            this.listeners.add(wrapper);
        }
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.searchFormElements();
        }
        this.logger.info("FormsManager service started");
    }

    protected void deactivate(ComponentContext componentContext) {
        if (this.session != null) {
            for (EventListenerWrapper listener : this.listeners) {
                try {
                    this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)listener);
                }
                catch (RepositoryException e) {}
            }
            this.listeners.clear();
            this.session.logout();
            this.session = null;
        }
        this.actions = null;
        this.logger.info("FormsManager service shut down");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearActions() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.actions = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConstraints() {
        FormsManagerImpl formsManagerImpl = this;
        synchronized (formsManagerImpl) {
            this.constraints = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchFormElements() {
        Node current;
        NodeIterator ni;
        Node folder;
        if (this.actions == null) {
            HashMap<String, String> localActions = new HashMap<String, String>();
            try {
                for (String path : this.actionSearchPaths) {
                    if (!this.session.itemExists(path)) continue;
                    folder = (Node)this.session.getItem(path);
                    ni = folder.getNodes();
                    while (ni.hasNext()) {
                        current = ni.nextNode();
                        if (!current.hasProperty("jcr:title")) continue;
                        localActions.put(current.getName(), current.getPath());
                    }
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Error while searching forms actions.", (Throwable)e);
            }
            finally {
                this.actions = localActions;
            }
        }
        if (this.constraints == null) {
            HashMap<String, String> localConstraints = new HashMap<String, String>();
            try {
                for (String path : this.constraintSearchPaths) {
                    if (!this.session.itemExists(path)) continue;
                    folder = (Node)this.session.getItem(path);
                    ni = folder.getNodes();
                    while (ni.hasNext()) {
                        current = ni.nextNode();
                        if (!current.hasProperty("jcr:title")) continue;
                        localConstraints.put(current.getName(), current.getPath());
                    }
                }
            }
            catch (RepositoryException e) {
                this.logger.error("Error while searching forms constraints.", (Throwable)e);
            }
            finally {
                this.constraints = localConstraints;
            }
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        this.resolverFactory = jcrResourceResolverFactory;
    }

    protected void unbindResolverFactory(JcrResourceResolverFactory jcrResourceResolverFactory) {
        if (this.resolverFactory == jcrResourceResolverFactory) {
            this.resolverFactory = null;
        }
    }

    public static final class EventListenerWrapper
    implements EventListener {
        public static final int ACTION = 1;
        public static final int CONSTRAINT = 2;
        private final FormsManagerImpl delegatee;
        private final int type;

        public EventListenerWrapper(FormsManagerImpl listener, int type) {
            this.delegatee = listener;
            this.type = type;
        }

        public void onEvent(EventIterator i) {
            if (this.type == 1) {
                this.delegatee.clearActions();
            } else if (this.type == 2) {
                this.delegatee.clearConstraints();
            }
        }
    }
}

