/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.sling.engine.auth.AuthenticationHandler;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthorizationHeaderAuthenticationHandler
implements AuthenticationHandler {
    public static final String PAR_REALM_NAME = "auth.http.realm";
    static final String REQUEST_LOGIN_PARAMETER = "sling:authRequestLogin";
    static final String NOT_LOGGED_IN_USER = "__forced_logout_user__";
    private static final String HEADER_WWW_AUTHENTICATE = "WWW-Authenticate";
    private static final String HEADER_AUTHORIZATION = "Authorization";
    private static final String AUTHENTICATION_SCHEME_BASIC = "Basic";
    private static final String DEFAULT_REALM = "Day Communique 5";
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String realm = "Day Communique 5";

    public AuthenticationInfo authenticate(HttpServletRequest request, HttpServletResponse response) {
        AuthenticationInfo info = this.extractAuthentication(request);
        if (info != null) {
            return info;
        }
        if (request.getParameter(REQUEST_LOGIN_PARAMETER) != null) {
            try {
                this.requestAuthentication(request, response);
                return AuthenticationInfo.DOING_AUTH;
            }
            catch (IOException ioe) {
                this.log.error("authenticate: Failed requesting authentication", (Throwable)ioe);
            }
        }
        return null;
    }

    public boolean requestAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!response.isCommitted()) {
            response.setHeader(HEADER_WWW_AUTHENTICATE, "Basic realm=\"" + this.realm + "\"");
            response.sendError(401);
        } else {
            this.log.error("requestAuthentication: Response is committed, cannot request authentication");
        }
        return true;
    }

    protected void activate(ComponentContext componentContext) {
        String newRealm = (String)componentContext.getProperties().get(PAR_REALM_NAME);
        if (newRealm == null || newRealm.length() == 0) {
            newRealm = DEFAULT_REALM;
        }
        if (!newRealm.equals(this.realm)) {
            this.log.info("Setting new realm name {} (was {})", (Object)newRealm, (Object)this.realm);
            this.realm = newRealm;
        }
    }

    protected AuthenticationInfo extractAuthentication(HttpServletRequest request) {
        String decoded;
        int blank;
        String authHeader = request.getHeader(HEADER_AUTHORIZATION);
        if (authHeader == null || authHeader.length() == 0) {
            Cookie[] cookies = request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!HEADER_AUTHORIZATION.equalsIgnoreCase(cookies[i].getName())) continue;
                    authHeader = cookies[i].getValue();
                    break;
                }
            }
            if (authHeader == null || authHeader.length() == 0) {
                return null;
            }
        }
        if ((blank = (authHeader = authHeader.trim()).indexOf(32)) <= 0) {
            return null;
        }
        String authType = authHeader.substring(0, blank);
        String authInfo = authHeader.substring(blank).trim();
        if (!authType.equalsIgnoreCase(AUTHENTICATION_SCHEME_BASIC)) {
            return null;
        }
        try {
            byte[] encoded = authInfo.getBytes("ISO-8859-1");
            byte[] bytes = Base64.decodeBase64((byte[])encoded);
            decoded = new String(bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException uee) {
            this.log.error("extractAuthentication: Cannot en/decode authentication info", (Throwable)uee);
            return null;
        }
        int colIdx = decoded.indexOf(58);
        SimpleCredentials creds = colIdx < 0 ? new SimpleCredentials(decoded, new char[0]) : new SimpleCredentials(decoded.substring(0, colIdx), decoded.substring(colIdx + 1).toCharArray());
        if (NOT_LOGGED_IN_USER.equals(creds.getUserID())) {
            return null;
        }
        return new AuthenticationInfo("BASIC", (Credentials)creds);
    }
}

