/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.foundation.Paragraph;
import com.day.text.Text;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphSystem {
    public static final Logger log = LoggerFactory.getLogger(ParagraphSystem.class);
    public static final String COL_CTL_TYPE = "controlType";
    public static final String COL_CTL_LAYOUT = "layout";
    private final Resource resource;
    private final ResourceResolver resolver;
    private String colCtrlResourceType;
    private String colCtrlSuffix = "/colctrl";
    private String defaultLayout = "1;cq-colctrl-default";
    private List<Paragraph> paras;

    public ParagraphSystem(Resource resource) {
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
        String type = resource.getResourceType() + this.colCtrlSuffix;
        if (type.startsWith("/")) {
            for (String sp : this.resolver.getSearchPath()) {
                if (!type.startsWith(sp)) continue;
                type = type.substring(sp.length());
                break;
            }
        }
        this.colCtrlResourceType = type;
    }

    public String getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(String defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public List<Paragraph> paragraphs() {
        this.initParas();
        return this.paras;
    }

    private void initParas() {
        if (this.paras != null) {
            return;
        }
        if (this.resource.adaptTo(Node.class) == null) {
            try {
                String path = this.resource.getPath();
                int idx = path.lastIndexOf(47);
                String parentPath = path.substring(0, idx);
                String name = path.substring(idx + 1);
                Session s = (Session)this.resolver.adaptTo(Session.class);
                Node parentNode = (Node)s.getItem(parentPath);
                Node parNode = parentNode.addNode(name);
                parNode.setProperty("sling:resourceType", this.resource.getResourceType());
                parentNode.save();
            }
            catch (Exception e) {
                log.warn("Could not create missing {} node.", (Object)this.resource.getPath(), (Object)e);
            }
        }
        this.paras = new LinkedList<Paragraph>();
        int colNum = 0;
        int numCols = 0;
        String layout = "default";
        LinkedList<Paragraph> toRemove = new LinkedList<Paragraph>();
        LinkedList<Paragraph> toCreate = new LinkedList<Paragraph>();
        Resource lastStartResource = null;
        int lastStartIndex = 0;
        Resource followingLastStartResource = null;
        Iterator iter = this.resolver.listChildren(this.resource);
        while (iter.hasNext()) {
            Resource res = (Resource)iter.next();
            if (lastStartResource != null && followingLastStartResource == null) {
                followingLastStartResource = res;
            }
            if (res.getResourceType().endsWith(this.colCtrlSuffix)) {
                ValueMap resProps = (ValueMap)res.adaptTo(ValueMap.class);
                Paragraph.Type type = null;
                try {
                    type = Paragraph.Type.valueOf(((String)resProps.get(COL_CTL_TYPE, (Object)"start")).toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
                if (type == Paragraph.Type.START) {
                    if (numCols > 0) {
                        Paragraph para;
                        while (colNum < numCols - 1) {
                            para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            if (followingLastStartResource != null) {
                                this.paras.add(++lastStartIndex, para);
                            } else {
                                this.paras.add(para);
                            }
                            toCreate.add(para);
                        }
                        para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
                        if (followingLastStartResource != null) {
                            this.paras.add(++lastStartIndex, para);
                        } else {
                            this.paras.add(para);
                        }
                        toCreate.add(para);
                    }
                    colNum = 0;
                    numCols = 1;
                    layout = (String)resProps.get(COL_CTL_LAYOUT, (Object)this.defaultLayout);
                    int i = layout.indexOf(59);
                    if (i > 0) {
                        try {
                            numCols = Integer.parseInt(layout.substring(0, i));
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        layout = layout.substring(i + 1);
                    }
                    Paragraph toInsert = new Paragraph(res, type, colNum, layout, numCols);
                    this.paras.add(toInsert);
                    lastStartResource = res;
                    lastStartIndex = this.paras.indexOf(toInsert);
                    followingLastStartResource = null;
                    continue;
                }
                if (type == Paragraph.Type.BREAK) {
                    Paragraph para = new Paragraph(res, type, ++colNum, layout, numCols);
                    if (numCols > 0) {
                        if (colNum >= numCols) {
                            toRemove.add(para);
                            continue;
                        }
                        this.paras.add(para);
                        continue;
                    }
                    toRemove.add(para);
                    continue;
                }
                if (type == Paragraph.Type.END) {
                    if (numCols > 0) {
                        while (colNum < numCols - 1) {
                            Paragraph para = new Paragraph(res, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                            this.paras.add(para);
                            toCreate.add(para);
                        }
                        numCols = 0;
                        colNum = 0;
                        this.paras.add(new Paragraph(res, Paragraph.Type.END, colNum, layout, numCols));
                        continue;
                    }
                    Paragraph para = new Paragraph(res, Paragraph.Type.END);
                    toRemove.add(para);
                    continue;
                }
                Paragraph para = new Paragraph(res, Paragraph.Type.END);
                toRemove.add(para);
                continue;
            }
            this.paras.add(new Paragraph(res, Paragraph.Type.NORMAL, colNum, layout, numCols));
        }
        if (numCols > 0) {
            Paragraph para;
            while (colNum < numCols - 1) {
                para = new Paragraph(followingLastStartResource, Paragraph.Type.BREAK, ++colNum, layout, numCols);
                if (followingLastStartResource != null) {
                    this.paras.add(++lastStartIndex, para);
                } else {
                    this.paras.add(para);
                }
                toCreate.add(para);
            }
            para = new Paragraph(followingLastStartResource, Paragraph.Type.END, colNum, layout, numCols);
            if (followingLastStartResource != null) {
                this.paras.add(++lastStartIndex, para);
            } else {
                this.paras.add(para);
            }
            toCreate.add(para);
        }
        try {
            this.fixStructure(toRemove, toCreate);
        }
        catch (RepositoryException e) {
            log.error("Error while fixing paragraph system structure.", (Throwable)e);
        }
    }

    private void fixStructure(List<Paragraph> toRemove, List<Paragraph> toCreate) throws RepositoryException {
        Node parent = (Node)this.resource.adaptTo(Node.class);
        for (Paragraph p : toRemove) {
            Node pn = p.adaptTo(Node.class);
            if (pn == null) continue;
            pn.remove();
        }
        int nr = 0;
        for (Paragraph p : toCreate) {
            String type = p.getType().toString().toLowerCase();
            Node node = parent.addNode("col_" + type + System.currentTimeMillis() + nr++);
            node.setProperty("sling:resourceType", this.colCtrlResourceType);
            node.setProperty(COL_CTL_TYPE, type);
            if (p.getResource() != null) {
                String beforeName = Text.getName((String)p.getResource().getPath());
                parent.orderBefore(node.getName(), beforeName);
            }
            p.setResource(this.resolver.getResource(node.getPath()));
        }
        if (!toCreate.isEmpty() || !toRemove.isEmpty()) {
            try {
                parent.save();
            }
            catch (RepositoryException e) {
                parent.refresh(false);
                throw e;
            }
        }
    }
}

