/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms;

import com.day.cq.wcm.foundation.forms.FormsHelper;
import com.day.cq.wcm.foundation.forms.ValidationInfo;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspWriter;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;

public class ValidationHelper {
    private static final String REQ_ATTR_VALIDATION_INFO = "cq5.form.validationinfo";

    private ValidationHelper() {
    }

    public static ValidationInfo getValidationInfo(SlingHttpServletRequest request) {
        ValidationInfo info = (ValidationInfo)request.getAttribute(REQ_ATTR_VALIDATION_INFO);
        if (info == null) {
            info = new ValidationInfo(FormsHelper.getFormId(request), request.getParameterMap());
            request.setAttribute(REQ_ATTR_VALIDATION_INFO, (Object)info);
        }
        return info;
    }

    public static boolean hasValidationInfo(HttpServletRequest request) {
        ValidationInfo info = (ValidationInfo)request.getAttribute(REQ_ATTR_VALIDATION_INFO);
        return info != null;
    }

    public static boolean fieldSupportsRequired(ValueMap properties) {
        String elementType = (String)properties.get("elementType", (Object)"text");
        boolean fieldSupportsRequired = "textarea".equals(elementType) || "text".equals(elementType);
        return fieldSupportsRequired;
    }

    public static String getRequiredMessage(Resource resource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String msg = (String)properties.get("requiredMessage", (Object)"");
        if (msg.length() == 0) {
            msg = "Field is required.";
        }
        return msg;
    }

    public static String getConstraintMessage(Resource resource) {
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String msg = (String)properties.get("constraintMessage", (Object)"");
        if (msg.length() == 0) {
            msg = "Field is not valid.";
        }
        return msg;
    }

    public static boolean checkRequired(SlingHttpServletRequest request, Resource resource) {
        boolean required;
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String name = FormsHelper.getParameterName(resource);
        String value = request.getParameter(name);
        boolean isEmpty = value == null || value.trim().length() == 0;
        boolean fieldSupportsRequired = ValidationHelper.fieldSupportsRequired(properties);
        if (fieldSupportsRequired && (required = ((Boolean)properties.get("required", (Object)false)).booleanValue()) && isEmpty) {
            ValidationHelper.getValidationInfo(request).addErrorMessage(name, ValidationHelper.getRequiredMessage(resource));
            return false;
        }
        return true;
    }

    public static void checkConstraint(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource) throws IOException, ServletException {
        boolean isEmpty;
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String name = FormsHelper.getParameterName(resource);
        String value = request.getParameter(name);
        boolean bl = isEmpty = value == null || value.trim().length() == 0;
        if (!isEmpty) {
            String constraint;
            boolean fieldSupportsConstraint;
            String elementType = (String)properties.get("elementType", (Object)"");
            boolean bl2 = fieldSupportsConstraint = "textarea".equals(elementType) || "text".equals(elementType) || "password".equals(elementType);
            if (fieldSupportsConstraint && (constraint = (String)properties.get("constraintType", (Object)"")).length() > 0) {
                FormsHelper.includeResource(request, response, resource, "constraints." + constraint + ".servervalidation");
            }
        }
    }

    public static void writeRequiredCheck(SlingHttpServletRequest request, Resource resource, JspWriter out) throws IOException {
        boolean required;
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String formId = FormsHelper.getFormId(request);
        String name = FormsHelper.getParameterName(resource);
        boolean fieldSupportsRequired = ValidationHelper.fieldSupportsRequired(properties);
        if (fieldSupportsRequired && (required = ((Boolean)properties.get("required", (Object)false)).booleanValue())) {
            out.print("if (");
            out.print(ValidationHelper.getFormElementQualifier(request, resource));
            out.print(".value.length==0) {");
            out.print(" cq5forms_showMsg('");
            out.print(formId);
            out.print("','");
            out.print(name);
            out.print("','");
            out.print(ValidationHelper.getRequiredMessage(resource));
            out.print("'); return false; }");
        }
    }

    public static String getFormElementQualifier(SlingHttpServletRequest request, Resource resource) {
        String formId = FormsHelper.getFormId(request);
        String name = FormsHelper.getParameterName(resource);
        return "document.forms[\"" + formId + "\"].elements[\"" + name + "\"]";
    }

    public static void writeConstraintCheck(SlingHttpServletRequest request, SlingHttpServletResponse response, Resource resource, JspWriter out) throws IOException, ServletException {
        String constraint;
        boolean fieldSupportsConstraint;
        ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
        String elementType = (String)properties.get("elementType", (Object)"");
        boolean bl = fieldSupportsConstraint = "textarea".equals(elementType) || "text".equals(elementType) || "password".equals(elementType);
        if (fieldSupportsConstraint && (constraint = (String)properties.get("constraintType", (Object)"")).length() > 0) {
            out.flush();
            FormsHelper.includeResource(request, response, resource, "constraints." + constraint + ".clientvalidation");
        }
    }

    public static void writeRegexpText(SlingHttpServletRequest request, Resource resource, String regexp, JspWriter out) throws IOException {
        String id = ValidationHelper.getFormElementQualifier(request, resource);
        String name = FormsHelper.getParameterName(resource);
        out.println("{ var result=false;");
        out.print("var pattern = ");
        out.print(regexp);
        out.print("; var t = pattern.exec(");
        out.print(id);
        out.print(".value);");
        out.println("if (t) {");
        out.println("var len = ");
        out.print(id);
        out.print(".value.length;");
        out.println("var pattlen = t[0].length;");
        out.println("result = (pattlen == len); ");
        out.println("}");
        out.println("if ( !result ) {");
        out.print("cq5forms_showMsg('");
        out.print(FormsHelper.getFormId(request));
        out.print("','");
        out.print(name);
        out.print("','");
        out.print(ValidationHelper.getConstraintMessage(resource));
        out.print("');");
        out.println("return false; } }");
    }
}

