/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.commons.servlets.AbstractPredicateServlet;
import com.day.cq.wcm.foundation.forms.FormsManager;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.commons.collections.Predicate;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormsListServlet
extends AbstractPredicateServlet {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private FormsManager formsManager;

    protected void doGet(SlingHttpServletRequest req, SlingHttpServletResponse resp, Predicate predicate) throws ServletException, IOException {
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        try {
            JSONWriter w = new JSONWriter((Writer)resp.getWriter());
            if (req.getRequestURI().contains("/actions")) {
                this.writeActions(req, w);
            } else {
                this.writeConstraints(req, w);
            }
        }
        catch (Exception e) {
            this.logger.error("Error while generating JSON list", (Throwable)e);
            resp.sendError(500, e.toString());
            return;
        }
    }

    private void writeActions(SlingHttpServletRequest req, JSONWriter w) throws JSONException {
        Iterator<String> resourceIter = this.formsManager.getActions();
        w.array();
        while (resourceIter.hasNext()) {
            String path = resourceIter.next();
            Resource r = req.getResourceResolver().getResource(path);
            if (r == null) continue;
            w.object();
            w.key("value");
            w.value((Object)ResourceUtil.getName((Resource)r));
            String text = ResourceUtil.getName((Resource)r);
            ValueMap props = (ValueMap)r.adaptTo(ValueMap.class);
            if (props != null) {
                text = (String)props.get("jcr:title", (Object)text);
            }
            w.key("text");
            w.value((Object)text);
            w.endObject();
        }
        w.endArray();
    }

    private void writeConstraints(SlingHttpServletRequest req, JSONWriter w) throws JSONException {
        Iterator<String> resourceIter = this.formsManager.getConstraints();
        w.array();
        w.object();
        w.key("value").value((Object)"");
        w.key("text").value((Object)"None");
        w.endObject();
        while (resourceIter.hasNext()) {
            String path = resourceIter.next();
            Resource r = req.getResourceResolver().getResource(path);
            if (r == null) continue;
            w.object();
            w.key("value");
            w.value((Object)ResourceUtil.getName((Resource)r));
            String text = ResourceUtil.getName((Resource)r);
            ValueMap props = (ValueMap)r.adaptTo(ValueMap.class);
            if (props != null) {
                text = (String)props.get("jcr:title", (Object)text);
            }
            w.key("text");
            w.value((Object)text);
            w.endObject();
        }
        w.endArray();
    }

    protected void bindFormsManager(FormsManager formsManager) {
        this.formsManager = formsManager;
    }

    protected void unbindFormsManager(FormsManager formsManager) {
        if (this.formsManager == formsManager) {
            this.formsManager = null;
        }
    }
}

