/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.forms.impl;

import com.day.cq.mailer.MailService;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.ServletException;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.SimpleEmail;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.OptingServlet;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailServlet
extends SlingAllMethodsServlet
implements OptingServlet {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected static final String EXTENSION = "html";
    protected static final String SELECTOR = "mail";
    protected static final String MAILTO_PROPERTY = "mailto";
    protected static final String SUBJECT_PROPERTY = "subject";
    protected static final String FROM_PROPERTY = "from";
    protected MailService mailService;

    public boolean accepts(SlingHttpServletRequest request) {
        return EXTENSION.equals(request.getRequestPathInfo().getExtension()) && SELECTOR.equals(request.getRequestPathInfo().getSelectorString());
    }

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        if (ResourceUtil.isNonExistingResource((Resource)request.getResource())) {
            this.logger.debug("Received fake request!");
            response.setStatus(500);
            return;
        }
        ValueMap values = (ValueMap)request.getResource().adaptTo(ValueMap.class);
        String mailTo = (String)values.get(MAILTO_PROPERTY, null);
        int status = 200;
        if (mailTo == null || mailTo.length() == 0) {
            this.logger.error("The mailto configuration is missing in the form begin at " + request.getResource().getPath());
            status = 500;
        } else {
            SimpleEmail email = new SimpleEmail();
            try {
                StringBuffer buffer = new StringBuffer();
                buffer.append("You've received a new form based mail from " + request.getResource().getPath());
                buffer.append("\n\nValues:\n\n");
                Enumeration names = request.getParameterNames();
                while (names.hasMoreElements()) {
                    String[] pValues;
                    String name = names.nextElement().toString();
                    if (name.startsWith(":")) continue;
                    buffer.append(name);
                    buffer.append(" : \n");
                    for (String v : pValues = request.getParameterValues(name)) {
                        buffer.append(v);
                        buffer.append("\n");
                    }
                    buffer.append("\n");
                }
                email.setMsg(buffer.toString());
                email.addTo(mailTo);
                String subject = (String)values.get(SUBJECT_PROPERTY, (Object)"Form Mail");
                email.setSubject(subject);
                String fromAddress = (String)values.get(FROM_PROPERTY, null);
                if (fromAddress != null && fromAddress.length() > 0) {
                    email.setFrom(fromAddress);
                }
                this.logger.debug("Sending mail from form.");
                this.mailService.sendEmail((Email)email);
            }
            catch (EmailException e) {
                this.logger.error("Error sending email: " + e.getMessage(), (Throwable)e);
                status = 500;
            }
            String redirectTo = request.getParameter(":redirect");
            if (redirectTo != null) {
                int pos = redirectTo.indexOf(63);
                redirectTo = redirectTo + (pos == -1 ? (char)'?' : '&') + "status=" + status;
                response.sendRedirect(redirectTo);
                return;
            }
            response.setStatus(status);
        }
    }

    protected void bindMailService(MailService mailService) {
        this.mailService = mailService;
    }

    protected void unbindMailService(MailService mailService) {
        if (this.mailService == mailService) {
            this.mailService = null;
        }
    }
}

