/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation.impl;

import com.day.cq.wcm.foundation.impl.AuthorizationHeaderAuthenticationHandler;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.apache.sling.engine.auth.AuthenticationInfo;
import org.osgi.service.component.ComponentContext;

public class SsoAuthenticationHandler
extends AuthorizationHeaderAuthenticationHandler {
    public static final String PROPERTY_HEADERS = "headers";
    public static final String PROPERTY_COOKIES = "cookies";
    public static final String PROPERTY_PARAMETERS = "parameters";
    private String[] headerNames;
    private String[] cookieNames;
    private String[] parameterNames;

    protected void activate(ComponentContext componentContext) {
        super.activate(componentContext);
        this.headerNames = this.getConfigValues(componentContext, PROPERTY_HEADERS);
        this.cookieNames = this.getConfigValues(componentContext, PROPERTY_COOKIES);
        this.parameterNames = this.getConfigValues(componentContext, PROPERTY_PARAMETERS);
    }

    protected void deactivate(ComponentContext componentContext) {
        this.headerNames = null;
        this.cookieNames = null;
        this.parameterNames = null;
    }

    private String[] getConfigValues(ComponentContext componentContext, String propName) {
        String[] values = OsgiUtil.toStringArray(componentContext.getProperties().get(propName));
        if (values != null && values.length == 1 && values[0].length() == 0) {
            values = null;
        }
        return values;
    }

    public AuthenticationInfo authenticate(HttpServletRequest request, HttpServletResponse response) {
        SSOInfo ssoInfo = this.getSsoUid(request);
        if (ssoInfo != null) {
            this.log.debug("accepting trusted credentials, uid={0} found in ", (Object)ssoInfo.ssoUid, (Object)ssoInfo.providerId);
            SimpleCredentials credentials = new SimpleCredentials(ssoInfo.ssoUid, "no_password_needed".toCharArray());
            credentials.setAttribute("TrustedInfo", (Object)ssoInfo.providerId);
            AuthenticationInfo info = new AuthenticationInfo("SSO", (Credentials)credentials);
            return info;
        }
        return super.authenticate(request, response);
    }

    private SSOInfo getSsoUid(HttpServletRequest request) {
        SSOInfo ssoInfo = this.getSsoUidFromHeader(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        ssoInfo = this.getSsoUidFromCookie(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        ssoInfo = this.getSsoUidFromParameter(request);
        if (ssoInfo != null) {
            return ssoInfo;
        }
        return null;
    }

    private SSOInfo getSsoUidFromHeader(HttpServletRequest request) {
        if (this.headerNames != null) {
            for (int i = 0; i < this.headerNames.length; ++i) {
                String value = request.getHeader(this.headerNames[i]);
                if (value == null) continue;
                this.log.debug("found header {0}={1}", (Object)this.headerNames[i], (Object)value);
                return new SSOInfo(value, "header", this.headerNames[i]);
            }
        }
        return null;
    }

    private SSOInfo getSsoUidFromParameter(HttpServletRequest request) {
        if (this.parameterNames != null) {
            for (int i = 0; i < this.parameterNames.length; ++i) {
                String value = request.getHeader(this.parameterNames[i]);
                if (value == null) continue;
                this.log.debug("found header {0}={1}", (Object)this.parameterNames[i], (Object)value);
                return new SSOInfo(value, "parameter", this.parameterNames[i]);
            }
        }
        return null;
    }

    private SSOInfo getSsoUidFromCookie(HttpServletRequest request) {
        Cookie[] cookies;
        if (this.cookieNames != null && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < this.cookieNames.length; ++i) {
                for (int j = 0; j < cookies.length; ++j) {
                    if (!this.cookieNames[i].equalsIgnoreCase(cookies[j].getName())) continue;
                    this.log.debug("found cookie {0}={1}", (Object)this.cookieNames[i], (Object)cookies[j].getValue());
                    return new SSOInfo(cookies[j].getValue(), "cookie", this.cookieNames[i]);
                }
            }
        }
        return null;
    }

    protected static final class SSOInfo {
        public String ssoUid;
        public String providerId;

        public SSOInfo(String id, String provider, String name) {
            this.ssoUid = id;
            this.providerId = provider + ':' + name;
        }
    }
}

