/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.wcm.foundation;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.commons.WCMUtils;
import com.day.text.Text;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Download {
    private static final Logger log = LoggerFactory.getLogger(Download.class);
    public static final String PN_REFERENCE = "fileReference";
    public static final String NN_FILE = "file";
    public static final String PN_FILE_NAME = "fileName";
    public static final String PN_TITLE = "jcr:title";
    public static final String PN_DESCRIPTION = "jcr:description";
    protected final Resource resource;
    protected final ValueMap properties;
    protected final Node node;
    private final Map<String, String> overlaid = new HashMap<String, String>();
    private String fileNodePath = null;
    private String source = "";
    private String extension = ".res";
    private String selector = "";
    private String suffix = "";
    protected Map<String, String> attrs;
    private Object innerHtml;
    private Property data;

    public Download(Resource resource) {
        this.resource = resource;
        this.properties = resource == null ? ValueMap.EMPTY : (ValueMap)resource.adaptTo(ValueMap.class);
        this.node = resource == null ? null : (Node)resource.adaptTo(Node.class);
    }

    public Resource getResource() {
        return this.resource;
    }

    public String get(String name) {
        String value = this.overlaid.get(name);
        if (value == null) {
            value = (String)this.properties.get(name, (Object)"");
        }
        return value;
    }

    public int get(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.get(name));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void set(String name, String value) {
        this.overlaid.put(name, value);
    }

    public void addAttribute(String name, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap<String, String>();
        }
        this.attrs.put(name, value);
    }

    public void addCssClass(String name) {
        if (this.attrs == null || !this.attrs.containsKey("class")) {
            this.addAttribute("class", name);
        } else {
            String prev = this.attrs.get("class");
            if (prev.length() == 0) {
                prev = name;
            } else if (!(prev.equals(name) || prev.contains(" " + name) || prev.contains(name + " "))) {
                prev = prev + " " + name;
            }
            this.attrs.put("class", prev);
        }
    }

    public String getFileReference() {
        return this.get(PN_REFERENCE);
    }

    public void setFileReference(String fileReference) {
        this.set(PN_REFERENCE, fileReference);
    }

    public Object getInnerHtml() {
        return this.innerHtml;
    }

    public void setInnerHtml(Object innerHtml) {
        this.innerHtml = innerHtml;
    }

    public String getFileNodePath() {
        if (this.fileNodePath == null) {
            this.fileNodePath = NN_FILE;
        }
        if (this.fileNodePath.length() > 0 && this.fileNodePath.charAt(0) != '/') {
            try {
                this.fileNodePath = this.node != null && this.node.hasNode(this.fileNodePath) ? this.node.getNode(this.fileNodePath).getPath() : "";
            }
            catch (RepositoryException e) {
                this.fileNodePath = "";
                log.warn("Error while accessing the repository.", (Throwable)e);
            }
        }
        return this.fileNodePath;
    }

    public void setFileNodePath(String fileNodePath) {
        this.fileNodePath = fileNodePath;
    }

    public String getFileName() {
        return this.getFileName(false);
    }

    public String getFileName(boolean computeDefault) {
        String fileRef;
        String fileName = this.get(PN_FILE_NAME);
        if (computeDefault && (fileName == null || fileName.length() == 0) && (fileRef = this.getFileReference()) != null && fileRef.length() != 0) {
            int index = fileRef.lastIndexOf(47);
            if (index > -1 && fileRef.length() > index) {
                return fileRef.substring(index + 1);
            }
            return fileRef;
        }
        return fileName;
    }

    public void setFileName(String fileName) {
        this.set(PN_FILE_NAME, fileName);
    }

    public String getTitle() {
        return this.get(PN_TITLE);
    }

    public String getTitle(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml((String)this.get(PN_TITLE)) : this.get(PN_TITLE);
    }

    public void setTitle(String title) {
        this.set(PN_TITLE, title);
    }

    public String getDescription() {
        return this.get(PN_DESCRIPTION);
    }

    public String getDescription(boolean escape) {
        return escape ? StringEscapeUtils.escapeHtml((String)this.get(PN_DESCRIPTION)) : this.get(PN_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(PN_DESCRIPTION, description);
    }

    public String getHref() {
        if (this.source.length() > 0) {
            return this.source;
        }
        if (this.selector.length() > 0) {
            this.source = this.resource.getPath() + this.selector + this.extension + this.suffix;
        } else if (this.getFileNodePath().length() > 0) {
            this.source = this.getFileNodePath() + this.extension + this.suffix;
        } else if (this.getFileReference().length() > 0) {
            this.source = this.getFileReference() + this.suffix;
        }
        return this.source;
    }

    public void setHref(String href) {
        this.source = href;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension == null ? "" : (!extension.startsWith(".") ? "." + extension : extension);
    }

    public String getIconType() {
        String fileName = this.getFileName(true);
        if (fileName != null && fileName.lastIndexOf(46) > 0) {
            return fileName.substring(fileName.lastIndexOf(46) + 1).toLowerCase();
        }
        return "dat";
    }

    public String getIconPath() {
        Component c = WCMUtils.getComponent((Resource)this.resource);
        if (c == null) {
            return null;
        }
        Resource icon = c.getLocalResource("resources/" + this.getIconType() + ".gif");
        if (icon == null) {
            icon = c.getLocalResource("resources/default.gif");
        }
        return icon == null ? null : icon.getPath();
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix == null ? "" : (!suffix.startsWith("/") ? "/" + suffix : suffix);
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String selector) {
        this.selector = selector == null ? "" : (!selector.startsWith(".") ? "." + selector : selector);
    }

    public boolean hasContent() {
        try {
            return this.getData() != null;
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public void draw(Writer w) throws IOException {
        if (!this.hasContent()) {
            return;
        }
        PrintWriter out = new PrintWriter(w);
        out.printf("<a href=\"%s\" ", Text.escape((String)this.getHref(), (char)'%', (boolean)true));
        out.printf("title=\"%s\" ", this.getTitle(true));
        if (this.attrs != null) {
            for (Map.Entry<String, String> e : this.attrs.entrySet()) {
                out.printf("%s=\"%s\" ", StringEscapeUtils.escapeHtml((String)e.getKey().toString()), StringEscapeUtils.escapeHtml((String)e.getValue().toString()));
            }
        }
        out.print(">");
        out.print(this.innerHtml == null ? this.getFileName() : this.innerHtml);
        out.print("</a>");
    }

    public String getString() {
        StringWriter w = new StringWriter();
        try {
            this.draw(w);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return w.getBuffer().toString();
    }

    public String getMimeType() throws RepositoryException {
        Property data = this.getData();
        return data.getParent().getProperty("jcr:mimeType").getString();
    }

    public Property getData() throws RepositoryException {
        Node fileNode;
        if (this.data != null) {
            return this.data;
        }
        if (this.node == null) {
            return null;
        }
        String ref = this.getFileReference();
        Session s = this.node.getSession();
        if (ref.length() > 0) {
            if (ref.charAt(0) != '/') {
                fileNode = s.getNodeByUUID(ref);
            } else {
                Resource res = this.resource.getResourceResolver().resolve(ref);
                if (res == null) {
                    return null;
                }
                this.data = (Property)res.adaptTo(Property.class);
                if (this.data != null) {
                    return this.data;
                }
                fileNode = (Node)res.adaptTo(Node.class);
                if (fileNode == null) {
                    return null;
                }
            }
        } else if (this.node.hasNode(NN_FILE)) {
            fileNode = this.node.getNode(NN_FILE);
        } else {
            return null;
        }
        if (fileNode.hasNode("jcr:content")) {
            fileNode = fileNode.getNode("jcr:content");
        }
        if (fileNode.hasProperty("jcr:data")) {
            this.data = fileNode.getProperty("jcr:data");
            return this.data;
        }
        return null;
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }
}

